/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import jaxx.runtime.SwingUtil;

public class CloseButton
extends JButton {
    protected Shape shape;
    protected Shape base;

    public CloseButton(AbstractAction action) {
        super(action);
        this.setModel(new DefaultButtonModel());
        this.init(null, SwingUtil.createImageIcon((String)"close-white.png"));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setBackground(Color.BLACK);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setAlignmentY(0.0f);
        this.initShape();
    }

    protected void initShape() {
        if (!this.getBounds().equals(this.base)) {
            Dimension s = this.getPreferredSize();
            this.base = this.getBounds();
            this.shape = new Ellipse2D.Float(0.0f, 0.0f, s.width - 1, s.height - 1);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Icon icon = this.getIcon();
        Insets i = this.getInsets();
        int iw = Math.max(icon.getIconWidth(), icon.getIconHeight());
        return new Dimension(iw + i.right + i.left, iw + i.top + i.bottom);
    }

    @Override
    protected void paintBorder(Graphics g) {
        this.initShape();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.draw(this.shape);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public boolean contains(int x, int y) {
        this.initShape();
        return this.shape.contains(x, y);
    }
}

