package com.franciaflex.faxtomail.ui.swing.content.transmit;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class MailFolderChooserUI extends JPanel implements FaxToMailUI<MailFolderChooserUIModel, MailFolderChooserUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTW8bRRh+s42dOElLm6ghFa3kQJES1I7TSj2FjyYB00QOoCRFFT7Q8e44mWp2Z5iZTTZEQfwEfgLcuSBx44Q4cObABfEXEOLAFfHOeO2NHbeOEFG0Tt6PZ5559n1ef/sHlIyGxWc0y4hOE8tjRrbWnjz5sPWMhfZdZkLNlZUaOj9jAQRNmI56cWPhtWbDtdfy9tqGjJVMWHKme7UBU8YeC2YOGLMWbvV3hMbUdnvp1UyluovaIzUM9eu//gy+ir78JgDIFLKbxKtUR3UVNxlvQMAjC7N40iGtCZrsIw3Nk33ke9nFNgQ15gMas8/gC5hoQFlRjWAWXr34lT2G78+UhWsx5aIuRcT0xoGUhmkL74cyJm1Nk5DTtmAZadPMSldIUk7MERIioUws4hOLZSbmlmwP4jzeVMqfU7ZQimXEhIXG/4S87eAK+ImYGUP3GUrnVMpypK0GbTHhaiq90su3t3ZDLYX4iCZsxcLLfQ1Fqr/rSkIP+T61XCZ7GkcCrvW1uZirnO01TN7ecihiZZCSj/aDz4SoBxPrqbV4dZjrq+9EXeVCweaQCh5Ry4rkrbxCwyt984aTTIpJLkZtrAklnWLYwkLz/PDvYKoz9gsDY+8Affaf+blff/j9+3p31ifw7OtDS89YFWdQaalwyLg7+qXOoKeWi9o2VatNqBgm0OfexzeHENvN00gOz/Nvgbh28oiaA4QoTfz240/zT3+5BEEdpoSkUZ26+k2o2AONKuAcZeqdh57RzNEkPq86bsglphmP03hHHm3I1HkquL+SoQI3hyjQo9Gq/Pz33O53D7sqBMjqxnPLCyVKn0CZJ4InzHs+t/NQj08rw9JIFrYdZmRAK8+vM5rUubBM0xamZdyS6zLLbVJzJTOuZCDxun8un9MksDBuWeaWS+HS0DuwcCTpOa/ckjpy22P1pHp2gtd9uPMWjkmoGc7te7Gyx53E0oM71fx3uXqapY7LXadRTrowtxrB95KFaS2l/ZgbjtfHpdOmwuBnpY22umv45/h3cO+ehas4BkdmB2sf0STyJhi3OmXDTh9w/gVI5KItvUA0FAPxSMf3FqY6/2+6zQflbnTaSin2uNrzcHcuCkcsV8Mu0rdlRl2jhLKzxE0Rfh0tnlT9+ib4motTl5ari29Vk1SI6mnv0m+MZtndXQPXnizis59SpQQPvehrvsbCzsl/+eronGDIXh5Yy5VyzjkdlJhcnPzzRB7YzKNkxrVTFvRYYjFceRP7aLXFkwiv8vY59DH3nBqJ6MJ+nZyfZp+7gQj/AqkDnHxlCQAA";
    private static final Log log = LogFactory.getLog(MailFolderChooserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected final MailFolderChooserUIHandler handler = createHandler();
    protected MailFolderChooserUI mailFolderChooser = this;
    protected JLabel message;
    protected MailFolderChooserUIModel model;
    protected JTree navigationTree;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MailFolderChooserUI(FaxToMailUI parentUI, MailFolderChooserUIModel model) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
                setContextValue(model);
            $initialize();
    }

    public MailFolderChooserUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MailFolderChooserUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MailFolderChooserUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public MailFolderChooserUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MailFolderChooserUI() {
        $initialize();
    }

    public MailFolderChooserUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MailFolderChooserUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public MailFolderChooserUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public MailFolderChooserUIHandler getHandler() {
        return handler;
    }

    public JLabel getMessage() {
        return message;
    }

    public MailFolderChooserUIModel getModel() {
        return model;
    }

    public JTree getNavigationTree() {
        return navigationTree;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMailFolderChooser() {
        if (!allComponentsCreated) {
            return;
        }
        add(message, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.chooseMailFolder.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.chooseMailFolder.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected MailFolderChooserUIHandler createHandler() {
        return new MailFolderChooserUIHandler();
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JLabel());
        
        message.setName("message");
        message.setText(t("faxtomail.chooseMailFolder.message"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(MailFolderChooserUIModel.class));
    }

    protected void createNavigationTree() {
        $objectMap.put("navigationTree", navigationTree = new JTree());
        
        navigationTree.setName("navigationTree");
        navigationTree.setRootVisible(false);
        if (navigationTree.getFont() != null) {
            navigationTree.setFont(navigationTree.getFont().deriveFont((float) 11));
        }
        navigationTree.setShowsRootHandles(true);
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("faxtomail.chooseMailFolder.action.validate"));
        validateButton.setToolTipText(t("faxtomail.chooseMailFolder.action.validate.tip"));
        validateButton.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.content.transmit.actions.TransmitAction.class);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMailFolderChooser();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(navigationTree);
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        message.setBorder( javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5) );
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setIcon(SwingUtil.createActionIcon("validate"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("mailFolderChooser", mailFolderChooser);
        createModel();
        createMessage();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createNavigationTree();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createValidateButton();
        // inline creation of mailFolderChooser
        setName("mailFolderChooser");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("mailFolder", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    validateButton.setEnabled( model.getMailFolder() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("mailFolder", this);
                }
            }
        });
    }

}