/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.fdf.FDFCatalog;
import org.apache.pdfbox.pdmodel.fdf.FDFDictionary;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDXFAResource;

public final class PDAcroForm
implements COSObjectable {
    private static final int FLAG_SIGNATURES_EXIST = 1;
    private static final int FLAG_APPEND_ONLY = 2;
    private final COSDictionary acroForm;
    private final PDDocument document;
    private Map<String, PDFieldTreeNode> fieldCache;

    public PDAcroForm(PDDocument doc) {
        this.document = doc;
        this.acroForm = new COSDictionary();
        COSArray fields = new COSArray();
        this.acroForm.setItem(COSName.FIELDS, (COSBase)fields);
    }

    public PDAcroForm(PDDocument doc, COSDictionary form) {
        this.document = doc;
        this.acroForm = form;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.acroForm;
    }

    public void importFDF(FDFDocument fdf) throws IOException {
        List<FDFField> fields = fdf.getCatalog().getFDF().getFields();
        if (fields != null) {
            for (FDFField field : fields) {
                FDFField fdfField = field;
                PDFieldTreeNode docField = this.getField(fdfField.getPartialFieldName());
                if (docField == null) continue;
                docField.importFDF(fdfField);
            }
        }
    }

    public FDFDocument exportFDF() throws IOException {
        FDFDocument fdf = new FDFDocument();
        FDFCatalog catalog = fdf.getCatalog();
        FDFDictionary fdfDict = new FDFDictionary();
        catalog.setFDF(fdfDict);
        ArrayList<FDFField> fdfFields = new ArrayList<FDFField>();
        List<PDFieldTreeNode> fields = this.getFields();
        for (PDFieldTreeNode docField : fields) {
            this.addFieldAndChildren(docField, fdfFields);
        }
        fdfDict.setID(this.document.getDocument().getDocumentID());
        if (!fdfFields.isEmpty()) {
            fdfDict.setFields(fdfFields);
        }
        return fdf;
    }

    private void addFieldAndChildren(PDFieldTreeNode docField, List<FDFField> fdfFields) throws IOException {
        Object fieldValue = docField.getValue();
        FDFField fdfField = new FDFField();
        fdfField.setPartialFieldName(docField.getPartialName());
        fdfField.setValue(fieldValue);
        List<COSObjectable> kids = docField.getKids();
        ArrayList<FDFField> childFDFFields = new ArrayList<FDFField>();
        if (kids != null) {
            for (COSObjectable kid : kids) {
                this.addFieldAndChildren((PDFieldTreeNode)kid, childFDFFields);
            }
            if (!childFDFFields.isEmpty()) {
                fdfField.setKids(childFDFFields);
            }
        }
        if (fieldValue != null || !childFDFFields.isEmpty()) {
            fdfFields.add(fdfField);
        }
    }

    public List<PDFieldTreeNode> getFields() {
        COSArray cosFields = (COSArray)this.acroForm.getDictionaryObject(COSName.FIELDS);
        if (cosFields == null) {
            return Collections.emptyList();
        }
        ArrayList<PDFieldTreeNode> pdFields = new ArrayList<PDFieldTreeNode>();
        for (int i = 0; i < cosFields.size(); ++i) {
            PDFieldTreeNode field;
            COSDictionary element = (COSDictionary)cosFields.getObject(i);
            if (element == null || (field = PDFieldTreeNode.createField(this, element, null)) == null) continue;
            pdFields.add(field);
        }
        return new COSArrayList<PDFieldTreeNode>(pdFields, cosFields);
    }

    public void setFields(List<PDFieldTreeNode> fields) {
        this.acroForm.setItem(COSName.FIELDS, (COSBase)COSArrayList.converterToCOSArray(fields));
    }

    public void setCacheFields(boolean cache) throws IOException {
        if (cache) {
            this.fieldCache = new HashMap<String, PDFieldTreeNode>();
            List<PDFieldTreeNode> fields = this.getFields();
            for (PDFieldTreeNode next : fields) {
                this.fieldCache.put(next.getFullyQualifiedName(), next);
            }
        } else {
            this.fieldCache = null;
        }
    }

    public boolean isCachingFields() {
        return this.fieldCache != null;
    }

    public PDFieldTreeNode getField(String name) throws IOException {
        PDFieldTreeNode retval = null;
        if (this.fieldCache != null) {
            retval = this.fieldCache.get(name);
        } else {
            String[] nameSubSection = name.split("\\.");
            COSArray fields = (COSArray)this.acroForm.getDictionaryObject(COSName.FIELDS);
            for (int i = 0; i < fields.size() && retval == null; ++i) {
                COSString fieldName;
                COSDictionary element = (COSDictionary)fields.getObject(i);
                if (element == null || !(fieldName = (COSString)element.getDictionaryObject(COSName.T)).getString().equals(name) && !fieldName.getString().equals(nameSubSection[0])) continue;
                PDFieldTreeNode root = PDFieldTreeNode.createField(this, element, null);
                if (nameSubSection.length > 1) {
                    PDFieldTreeNode kid = root.findKid(nameSubSection, 1);
                    if (kid != null) {
                        retval = kid;
                        continue;
                    }
                    retval = root;
                    continue;
                }
                retval = root;
            }
        }
        return retval;
    }

    public String getDefaultAppearance() {
        COSString defaultAppearance = (COSString)this.getCOSObject().getItem(COSName.DA);
        return defaultAppearance.getString();
    }

    public void setDefaultAppearance(String daValue) {
        if (daValue != null) {
            this.getCOSObject().setString(COSName.DA, daValue);
        } else {
            this.getCOSObject().removeItem(COSName.DA);
        }
    }

    public boolean isNeedAppearances() {
        return this.getCOSObject().getBoolean(COSName.NEED_APPEARANCES, false);
    }

    public void setNeedAppearances(Boolean value) {
        if (value != null) {
            this.getCOSObject().setBoolean(COSName.NEED_APPEARANCES, (boolean)value);
        } else {
            this.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
        }
    }

    public PDResources getDefaultResources() {
        PDResources retval = null;
        COSDictionary dr = (COSDictionary)this.acroForm.getDictionaryObject(COSName.DR);
        if (dr != null) {
            retval = new PDResources(dr);
        }
        return retval;
    }

    public void setDefaultResources(PDResources dr) {
        COSDictionary drDict = null;
        if (dr != null) {
            drDict = dr.getCOSObject();
        }
        this.acroForm.setItem(COSName.DR, (COSBase)drDict);
    }

    public boolean hasXFA() {
        return this.acroForm.containsKey(COSName.XFA);
    }

    public boolean xfaIsDynamic() {
        return this.hasXFA() && this.getFields().isEmpty();
    }

    public PDXFAResource getXFA() {
        PDXFAResource xfa = null;
        COSBase base = this.acroForm.getDictionaryObject(COSName.XFA);
        if (base != null) {
            xfa = new PDXFAResource(base);
        }
        return xfa;
    }

    public void setXFA(PDXFAResource xfa) {
        this.acroForm.setItem(COSName.XFA, (COSObjectable)xfa);
    }

    public int getQ() {
        int retval = 0;
        COSNumber number = (COSNumber)this.getCOSObject().getDictionaryObject(COSName.Q);
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public void setQ(int q) {
        this.getCOSObject().setInt(COSName.Q, q);
    }

    public boolean isSignaturesExist() {
        return this.getCOSObject().getFlag(COSName.SIG_FLAGS, 1);
    }

    public void setSignaturesExist(boolean signaturesExist) {
        this.getCOSObject().setFlag(COSName.SIG_FLAGS, 1, signaturesExist);
    }

    public boolean isAppendOnly() {
        return this.getCOSObject().getFlag(COSName.SIG_FLAGS, 2);
    }

    public void setAppendOnly(boolean appendOnly) {
        this.getCOSObject().setFlag(COSName.SIG_FLAGS, 2, appendOnly);
    }
}

