/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.PushBackInputStream;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.pdfparser.COSParser;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;

public class FDFParser
extends COSParser {
    private static final Log LOG = LogFactory.getLog(FDFParser.class);
    private final RandomAccessBufferedFileInputStream raStream;
    private File tempPDFFile;

    public FDFParser(String filename) throws IOException {
        this(new File(filename));
    }

    public FDFParser(File file) throws IOException {
        this.fileLen = file.length();
        this.raStream = new RandomAccessBufferedFileInputStream(file);
        this.init();
    }

    public FDFParser(InputStream input) throws IOException {
        this.tempPDFFile = this.createTmpFile(input);
        this.fileLen = this.tempPDFFile.length();
        this.raStream = new RandomAccessBufferedFileInputStream(this.tempPDFFile);
        this.init();
    }

    private void init() throws IOException {
        String eofLookupRangeStr = System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange");
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'"));
            }
        }
        this.document = new COSDocument(false);
        this.pdfSource = new PushBackInputStream(this.raStream, 4096);
    }

    private void initialParse() throws IOException {
        COSDictionary trailer = null;
        long startXRefOffset = this.getStartxrefOffset();
        trailer = startXRefOffset > 0L ? this.parseXref(startXRefOffset) : this.rebuildTrailer();
        COSBase rootObject = this.parseTrailerValuesDynamically(trailer);
        if (rootObject instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)rootObject, null);
        }
        this.initialParseDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.parseFDFHeader()) {
                throw new IOException("Error: Header doesn't contain versioninfo");
            }
            this.initialParse();
            exceptionOccurred = false;
        }
        finally {
            IOUtils.closeQuietly(this.pdfSource);
            this.deleteTempFile();
            if (exceptionOccurred && this.document != null) {
                IOUtils.closeQuietly(this.document);
                this.document = null;
            }
        }
    }

    public FDFDocument getFDFDocument() throws IOException {
        return new FDFDocument(this.getDocument());
    }

    private void deleteTempFile() {
        if (this.tempPDFFile != null) {
            try {
                if (!this.tempPDFFile.delete()) {
                    LOG.warn((Object)("Temporary file '" + this.tempPDFFile.getName() + "' can't be deleted"));
                }
            }
            catch (SecurityException e) {
                LOG.warn((Object)("Temporary file '" + this.tempPDFFile.getName() + "' can't be deleted"), (Throwable)e);
            }
        }
    }
}

