/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSeedValue;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public class PDSignatureField
extends PDField {
    public PDSignatureField(PDAcroForm theAcroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(theAcroForm, field, parentNode);
    }

    public PDSignatureField(PDAcroForm theAcroForm) throws IOException {
        super(theAcroForm);
        this.getCOSObject().setItem(COSName.FT, (COSBase)COSName.SIG);
        this.getWidget().setLocked(true);
        this.getWidget().setPrinted(true);
        this.setPartialName(this.generatePartialName());
    }

    private String generatePartialName() {
        PDAcroForm acroForm = this.getAcroForm();
        List<PDFieldTreeNode> fields = acroForm.getFields();
        String fieldName = "Signature";
        HashSet<String> sigNames = new HashSet<String>();
        for (PDFieldTreeNode field : fields) {
            if (!(field instanceof PDSignatureField)) continue;
            sigNames.add(field.getPartialName());
        }
        int i = 1;
        while (sigNames.contains(fieldName + i)) {
            ++i;
        }
        return fieldName + i;
    }

    @Override
    public String toString() {
        return "PDSignatureField";
    }

    public void setSignature(PDSignature value) {
        this.setValue(value);
    }

    public PDSignature getSignature() {
        return this.getValue();
    }

    public void setValue(PDSignature value) {
        if (value == null) {
            this.getCOSObject().removeItem(COSName.V);
        } else {
            this.getCOSObject().setItem(COSName.V, (COSObjectable)value);
        }
    }

    @Override
    public void setValue(String fieldValue) {
        throw new IllegalArgumentException("Signature fields don't support a string for the value entry.");
    }

    @Override
    public PDSignature getValue() {
        COSBase dictionary = this.getCOSObject().getDictionaryObject(COSName.V);
        if (dictionary == null) {
            return null;
        }
        return new PDSignature((COSDictionary)dictionary);
    }

    public PDSeedValue getSeedValue() {
        COSDictionary dict = (COSDictionary)this.getCOSObject().getDictionaryObject(COSName.SV);
        PDSeedValue sv = null;
        if (dict != null) {
            sv = new PDSeedValue(dict);
        }
        return sv;
    }

    public void setSeedValue(PDSeedValue sv) {
        if (sv != null) {
            this.getCOSObject().setItem(COSName.SV, sv.getCOSObject());
        }
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        throw new IllegalArgumentException("Signature fields don't support the \"DV\" entry.");
    }
}

