/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.Type1Equivalent;
import org.apache.fontbox.type1.DamagedFontException;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.ExternalFonts;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType1Equivalent;
import org.apache.pdfbox.pdmodel.font.PDType1FontEmbedder;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.pdmodel.font.encoding.StandardEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.Type1Encoding;
import org.apache.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;
import org.apache.pdfbox.util.Matrix;

public class PDType1Font
extends PDSimpleFont
implements PDType1Equivalent {
    private static final Log LOG = LogFactory.getLog(PDType1Font.class);
    private static final Map<String, String> ALT_NAMES = new HashMap<String, String>();
    private static final int PFB_START_MARKER = 128;
    public static final PDType1Font TIMES_ROMAN;
    public static final PDType1Font TIMES_BOLD;
    public static final PDType1Font TIMES_ITALIC;
    public static final PDType1Font TIMES_BOLD_ITALIC;
    public static final PDType1Font HELVETICA;
    public static final PDType1Font HELVETICA_BOLD;
    public static final PDType1Font HELVETICA_OBLIQUE;
    public static final PDType1Font HELVETICA_BOLD_OBLIQUE;
    public static final PDType1Font COURIER;
    public static final PDType1Font COURIER_BOLD;
    public static final PDType1Font COURIER_OBLIQUE;
    public static final PDType1Font COURIER_BOLD_OBLIQUE;
    public static final PDType1Font SYMBOL;
    public static final PDType1Font ZAPF_DINGBATS;
    private final Type1Font type1font;
    private final Type1Equivalent type1Equivalent;
    private final boolean isEmbedded;
    private final boolean isDamaged;
    private Matrix fontMatrix;

    private PDType1Font(String baseFont) {
        super(baseFont);
        this.dict.setItem(COSName.SUBTYPE, (COSBase)COSName.TYPE1);
        this.dict.setName(COSName.BASE_FONT, baseFont);
        this.encoding = new WinAnsiEncoding();
        this.dict.setItem(COSName.ENCODING, (COSBase)COSName.WIN_ANSI_ENCODING);
        this.type1font = null;
        Type1Equivalent t1Equiv = ExternalFonts.getType1EquivalentFont(this.getBaseFont());
        if (t1Equiv != null) {
            this.type1Equivalent = t1Equiv;
        } else {
            String fontName;
            this.type1Equivalent = ExternalFonts.getType1FallbackFont(this.getFontDescriptor());
            try {
                fontName = this.type1Equivalent.getName();
            }
            catch (IOException e) {
                fontName = "?";
            }
            LOG.warn((Object)("Using fallback font " + fontName + " for base font " + this.getBaseFont()));
        }
        this.isEmbedded = false;
        this.isDamaged = false;
    }

    public PDType1Font(PDDocument doc, InputStream afmIn, InputStream pfbIn) throws IOException {
        PDType1FontEmbedder embedder = new PDType1FontEmbedder(doc, this.dict, afmIn, pfbIn);
        this.encoding = embedder.getFontEncoding();
        this.type1font = embedder.getType1Font();
        this.type1Equivalent = embedder.getType1Font();
        this.isEmbedded = true;
        this.isDamaged = false;
    }

    public PDType1Font(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        PDFontDescriptor fd = this.getFontDescriptor();
        Type1Font t1 = null;
        boolean fontIsDamaged = false;
        if (fd != null) {
            PDStream fontFile3 = fd.getFontFile3();
            if (fontFile3 != null) {
                throw new IllegalArgumentException("Use PDType1CFont for FontFile3");
            }
            PDStream fontFile = fd.getFontFile();
            if (fontFile != null) {
                try {
                    COSStream stream = fontFile.getStream();
                    int length1 = stream.getInt(COSName.LENGTH1);
                    int length2 = stream.getInt(COSName.LENGTH2);
                    byte[] bytes = fontFile.getByteArray();
                    length1 = this.repairLength1(bytes, length1);
                    if (bytes.length > 0 && (bytes[0] & 0xFF) == 128) {
                        t1 = Type1Font.createWithPFB((byte[])bytes);
                    } else {
                        byte[] segment1 = Arrays.copyOfRange(bytes, 0, length1);
                        byte[] segment2 = Arrays.copyOfRange(bytes, length1, length1 + length2);
                        if (length1 > 0 && length2 > 0) {
                            t1 = Type1Font.createWithSegments((byte[])segment1, (byte[])segment2);
                        }
                    }
                }
                catch (DamagedFontException e) {
                    LOG.warn((Object)("Can't read damaged embedded Type1 font " + fd.getFontName()));
                    fontIsDamaged = true;
                }
                catch (IOException e) {
                    LOG.error((Object)("Can't read the embedded Type1 font " + fd.getFontName()), (Throwable)e);
                    fontIsDamaged = true;
                }
            }
        }
        this.isEmbedded = t1 != null;
        this.isDamaged = fontIsDamaged;
        if (t1 == null) {
            t1 = ExternalFonts.getType1Font(this.getBaseFont());
        }
        this.type1font = t1;
        if (this.type1font != null) {
            this.type1Equivalent = this.type1font;
        } else {
            Type1Equivalent t1Equiv = ExternalFonts.getType1EquivalentFont(this.getBaseFont());
            if (t1Equiv != null) {
                this.type1Equivalent = t1Equiv;
            } else {
                this.type1Equivalent = ExternalFonts.getType1FallbackFont(this.getFontDescriptor());
                LOG.warn((Object)("Using fallback font " + this.type1Equivalent.getName() + " for " + this.getBaseFont()));
            }
        }
        this.readEncoding();
    }

    private int repairLength1(byte[] bytes, int length1) {
        int offset;
        for (offset = Math.max(0, length1 - 4); offset > 0; --offset) {
            if (bytes[offset + 0] != 101 || bytes[offset + 1] != 120 || bytes[offset + 2] != 101 || bytes[offset + 3] != 99) continue;
            offset += 4;
            while (offset < length1 && (bytes[offset] == 13 || bytes[offset] == 10 || bytes[offset] == 32)) {
                ++offset;
            }
            break;
        }
        if (length1 - offset != 0 && offset > 0) {
            LOG.warn((Object)("Ignored invalid Length1 for Type 1 font " + this.getName()));
            return offset;
        }
        return length1;
    }

    public String getBaseFont() {
        return this.dict.getNameAsString(COSName.BASE_FONT);
    }

    @Override
    public float getHeight(int code) throws IOException {
        String name = this.codeToName(code);
        if (this.getStandard14AFM() != null) {
            String afmName = this.getEncoding().getName(code);
            return this.getStandard14AFM().getCharacterHeight(afmName);
        }
        return (float)this.type1Equivalent.getPath(name).getBounds().getHeight();
    }

    @Override
    protected byte[] encode(int unicode) throws IOException {
        if (unicode > 255) {
            throw new IllegalArgumentException("This font type only supports 8-bit code points");
        }
        String name = this.getGlyphList().codePointToName(unicode);
        String nameInFont = this.getNameInFont(name);
        Map<String, Integer> inverted = this.getInvertedEncoding();
        if (nameInFont.equals(".notdef") || !this.type1Equivalent.hasGlyph(nameInFont)) {
            throw new IllegalArgumentException(String.format("No glyph for U+%04X in font %s", unicode, this.getName()));
        }
        int code = inverted.get(name);
        return new byte[]{(byte)code};
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        String name = this.codeToName(code);
        if (!this.isEmbedded && name.equals(".notdef")) {
            return 250.0f;
        }
        return this.type1Equivalent.getWidth(name);
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public float getAverageFontWidth() {
        if (this.getStandard14AFM() != null) {
            return this.getStandard14AFM().getAverageCharacterWidth();
        }
        return super.getAverageFontWidth();
    }

    @Override
    public int readCode(InputStream in) throws IOException {
        return in.read();
    }

    @Override
    protected Encoding readEncodingFromFont() throws IOException {
        if (this.getStandard14AFM() != null) {
            return new Type1Encoding(this.getStandard14AFM());
        }
        if (this.type1Equivalent.getEncoding() != null) {
            return Type1Encoding.fromFontBox(this.type1Equivalent.getEncoding());
        }
        return StandardEncoding.INSTANCE;
    }

    public Type1Font getType1Font() {
        return this.type1font;
    }

    @Override
    public Type1Equivalent getType1Equivalent() {
        return this.type1Equivalent;
    }

    @Override
    public String getName() {
        return this.getBaseFont();
    }

    @Override
    public BoundingBox getBoundingBox() throws IOException {
        return this.type1Equivalent.getFontBBox();
    }

    @Override
    public String codeToName(int code) throws IOException {
        String name = this.getEncoding().getName(code);
        return this.getNameInFont(name);
    }

    private String getNameInFont(String name) throws IOException {
        String uniName;
        if (this.isEmbedded() || this.type1Equivalent.hasGlyph(name)) {
            return name;
        }
        String altName = ALT_NAMES.get(name);
        if (altName != null && !name.equals(".notdef") && this.type1Equivalent.hasGlyph(altName)) {
            return altName;
        }
        String unicodes = this.getGlyphList().toUnicode(name);
        if (unicodes != null && unicodes.length() == 1 && this.type1Equivalent.hasGlyph(uniName = String.format("uni%04X", unicodes.codePointAt(0)))) {
            return uniName;
        }
        return ".notdef";
    }

    @Override
    public GeneralPath getPath(String name) throws IOException {
        if (name.equals(".notdef") && !this.isEmbedded) {
            return new GeneralPath();
        }
        return this.type1Equivalent.getPath(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Matrix getFontMatrix() {
        if (this.fontMatrix != null) return this.fontMatrix;
        if (this.type1font != null) {
            List numbers = this.type1font.getFontMatrix();
            if (numbers == null || numbers.size() != 6) return super.getFontMatrix();
            this.fontMatrix = new Matrix(((Number)numbers.get(0)).floatValue(), ((Number)numbers.get(1)).floatValue(), ((Number)numbers.get(2)).floatValue(), ((Number)numbers.get(3)).floatValue(), ((Number)numbers.get(4)).floatValue(), ((Number)numbers.get(5)).floatValue());
            return this.fontMatrix;
        } else {
            this.fontMatrix = DEFAULT_FONT_MATRIX;
        }
        return this.fontMatrix;
    }

    @Override
    public boolean isDamaged() {
        return this.isDamaged;
    }

    static {
        ALT_NAMES.put("ff", "f_f");
        ALT_NAMES.put("ffi", "f_f_i");
        ALT_NAMES.put("ffl", "f_f_l");
        ALT_NAMES.put("fi", "f_i");
        ALT_NAMES.put("fl", "f_l");
        ALT_NAMES.put("st", "s_t");
        ALT_NAMES.put("IJ", "I_J");
        ALT_NAMES.put("ij", "i_j");
        ALT_NAMES.put("ellipsis", "elipsis");
        TIMES_ROMAN = new PDType1Font("Times-Roman");
        TIMES_BOLD = new PDType1Font("Times-Bold");
        TIMES_ITALIC = new PDType1Font("Times-Italic");
        TIMES_BOLD_ITALIC = new PDType1Font("Times-BoldItalic");
        HELVETICA = new PDType1Font("Helvetica");
        HELVETICA_BOLD = new PDType1Font("Helvetica-Bold");
        HELVETICA_OBLIQUE = new PDType1Font("Helvetica-Oblique");
        HELVETICA_BOLD_OBLIQUE = new PDType1Font("Helvetica-BoldOblique");
        COURIER = new PDType1Font("Courier");
        COURIER_BOLD = new PDType1Font("Courier-Bold");
        COURIER_OBLIQUE = new PDType1Font("Courier-Oblique");
        COURIER_BOLD_OBLIQUE = new PDType1Font("Courier-BoldOblique");
        SYMBOL = new PDType1Font("Symbol");
        ZAPF_DINGBATS = new PDType1Font("ZapfDingbats");
    }
}

