package com.franciaflex.faxtomail.ui.swing.content.search;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2016 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class SearchToGroupUI extends JPanel implements FaxToMailUI<SearchUIModel, SearchToGroupUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ARCHIVED_BETWEEN_END_DATE_PICKER_DATE = "archivedBetweenEndDatePicker.date";
    public static final String BINDING_ARCHIVED_BETWEEN_END_DATE_PICKER_VISIBLE = "archivedBetweenEndDatePicker.visible";
    public static final String BINDING_ARCHIVED_BETWEEN_LABEL_VISIBLE = "archivedBetweenLabel.visible";
    public static final String BINDING_ARCHIVED_BETWEEN_START_DATE_PICKER_DATE = "archivedBetweenStartDatePicker.date";
    public static final String BINDING_ARCHIVED_BETWEEN_START_DATE_PICKER_VISIBLE = "archivedBetweenStartDatePicker.visible";
    public static final String BINDING_ARCHIVED_BY_COMBO_BOX_SELECTED_ITEM = "archivedByComboBox.selectedItem";
    public static final String BINDING_ARCHIVED_BY_COMBO_BOX_VISIBLE = "archivedByComboBox.visible";
    public static final String BINDING_ARCHIVED_BY_LABEL_VISIBLE = "archivedByLabel.visible";
    public static final String BINDING_BODY_FIELD_TEXT = "bodyField.text";
    public static final String BINDING_COMMAND_NB_FIELD_TEXT = "commandNbField.text";
    public static final String BINDING_CURRENT_PAGE_LABEL_TEXT = "currentPageLabel.text";
    public static final String BINDING_EDI_CODE_NUMBER_FIELD_TEXT = "ediCodeNumberField.text";
    public static final String BINDING_EDI_CODE_NUMBER_FIELD_VISIBLE = "ediCodeNumberField.visible";
    public static final String BINDING_EDI_CODE_NUMBER_LABEL_VISIBLE = "ediCodeNumberLabel.visible";
    public static final String BINDING_GROUP_BUTTON_ENABLED = "groupButton.enabled";
    public static final String BINDING_LOCAL_REFERENCE_FIELD_TEXT = "localReferenceField.text";
    public static final String BINDING_MESSAGE_FIELD_TEXT = "messageField.text";
    public static final String BINDING_MODIFIED_BETWEEN_END_DATE_PICKER_DATE = "modifiedBetweenEndDatePicker.date";
    public static final String BINDING_MODIFIED_BETWEEN_END_DATE_PICKER_VISIBLE = "modifiedBetweenEndDatePicker.visible";
    public static final String BINDING_MODIFIED_BETWEEN_LABEL_VISIBLE = "modifiedBetweenLabel.visible";
    public static final String BINDING_MODIFIED_BETWEEN_START_DATE_PICKER_DATE = "modifiedBetweenStartDatePicker.date";
    public static final String BINDING_MODIFIED_BETWEEN_START_DATE_PICKER_VISIBLE = "modifiedBetweenStartDatePicker.visible";
    public static final String BINDING_MODIFIED_BY_COMBO_BOX_VISIBLE = "modifiedByComboBox.visible";
    public static final String BINDING_MODIFIED_BY_LABEL_VISIBLE = "modifiedByLabel.visible";
    public static final String BINDING_NEXT_PAGE_BUTTON_ENABLED = "nextPageButton.enabled";
    public static final String BINDING_OBJECT_FIELD_TEXT = "objectField.text";
    public static final String BINDING_PREVIOUS_PAGE_BUTTON_ENABLED = "previousPageButton.enabled";
    public static final String BINDING_PRINTED_BETWEEN_END_DATE_PICKER_DATE = "printedBetweenEndDatePicker.date";
    public static final String BINDING_PRINTED_BETWEEN_END_DATE_PICKER_VISIBLE = "printedBetweenEndDatePicker.visible";
    public static final String BINDING_PRINTED_BETWEEN_LABEL_VISIBLE = "printedBetweenLabel.visible";
    public static final String BINDING_PRINTED_BETWEEN_START_DATE_PICKER_DATE = "printedBetweenStartDatePicker.date";
    public static final String BINDING_PRINTED_BETWEEN_START_DATE_PICKER_VISIBLE = "printedBetweenStartDatePicker.visible";
    public static final String BINDING_PRINTED_BY_COMBO_BOX_SELECTED_ITEM = "printedByComboBox.selectedItem";
    public static final String BINDING_PRINTED_BY_COMBO_BOX_VISIBLE = "printedByComboBox.visible";
    public static final String BINDING_PRINTED_BY_LABEL_VISIBLE = "printedByLabel.visible";
    public static final String BINDING_PROJECT_REFERENCE_FIELD_TEXT = "projectReferenceField.text";
    public static final String BINDING_RECEIVED_BETWEEN_END_DATE_PICKER_DATE = "receivedBetweenEndDatePicker.date";
    public static final String BINDING_RECEIVED_BETWEEN_START_DATE_PICKER_DATE = "receivedBetweenStartDatePicker.date";
    public static final String BINDING_REPLIED_BETWEEN_END_DATE_PICKER_DATE = "repliedBetweenEndDatePicker.date";
    public static final String BINDING_REPLIED_BETWEEN_END_DATE_PICKER_VISIBLE = "repliedBetweenEndDatePicker.visible";
    public static final String BINDING_REPLIED_BETWEEN_LABEL_VISIBLE = "repliedBetweenLabel.visible";
    public static final String BINDING_REPLIED_BETWEEN_START_DATE_PICKER_DATE = "repliedBetweenStartDatePicker.date";
    public static final String BINDING_REPLIED_BETWEEN_START_DATE_PICKER_VISIBLE = "repliedBetweenStartDatePicker.visible";
    public static final String BINDING_REPLIED_BY_COMBO_BOX_SELECTED_ITEM = "repliedByComboBox.selectedItem";
    public static final String BINDING_REPLIED_BY_COMBO_BOX_VISIBLE = "repliedByComboBox.visible";
    public static final String BINDING_REPLIED_BY_LABEL_VISIBLE = "repliedByLabel.visible";
    public static final String BINDING_SENDER_FIELD_TEXT = "senderField.text";
    public static final String BINDING_SHOW_ADVANCED_SEARCH_BUTTON_TEXT = "showAdvancedSearchButton.text";
    public static final String BINDING_TAKEN_BY_COMBO_BOX_SELECTED_ITEM = "takenByComboBox.selectedItem";
    public static final String BINDING_TAKEN_BY_COMBO_BOX_VISIBLE = "takenByComboBox.visible";
    public static final String BINDING_TAKEN_BY_LABEL_VISIBLE = "takenByLabel.visible";
    public static final String BINDING_TOTAL_DEMAND_COUNT_VALUE_TEXT = "totalDemandCountValue.text";
    public static final String BINDING_TOTAL_PAGE_NUMBER_LABEL_TEXT = "totalPageNumberLabel.text";
    public static final String BINDING_TRANSFER_BETWEEN_END_DATE_PICKER_DATE = "transferBetweenEndDatePicker.date";
    public static final String BINDING_TRANSFER_BETWEEN_END_DATE_PICKER_VISIBLE = "transferBetweenEndDatePicker.visible";
    public static final String BINDING_TRANSFER_BETWEEN_LABEL_VISIBLE = "transferBetweenLabel.visible";
    public static final String BINDING_TRANSFER_BETWEEN_START_DATE_PICKER_DATE = "transferBetweenStartDatePicker.date";
    public static final String BINDING_TRANSFER_BETWEEN_START_DATE_PICKER_VISIBLE = "transferBetweenStartDatePicker.visible";
    public static final String BINDING_TRANSFER_BY_COMBO_BOX_SELECTED_ITEM = "transferByComboBox.selectedItem";
    public static final String BINDING_TRANSFER_BY_COMBO_BOX_VISIBLE = "transferByComboBox.visible";
    public static final String BINDING_TRANSFER_BY_LABEL_VISIBLE = "transferByLabel.visible";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL1_VISIBLE = "$JLabel1.visible";
    private static final String BINDING_$JLABEL2_VISIBLE = "$JLabel2.visible";
    private static final String BINDING_$JLABEL3_VISIBLE = "$JLabel3.visible";
    private static final String BINDING_$JLABEL4_VISIBLE = "$JLabel4.visible";
    private static final String BINDING_$JLABEL5_VISIBLE = "$JLabel5.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SearchToGroupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXDatePicker archivedBetweenEndDatePicker;
    protected JLabel archivedBetweenLabel;
    protected JXDatePicker archivedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> archivedByComboBox;
    protected JLabel archivedByLabel;
    protected JTextField bodyField;
    protected JLabel bodyLabel;
    protected JButton cancelButton;
    protected JTextField clientField;
    protected JLabel clientLabel;
    protected JTextField commandNbField;
    protected JLabel commandNbLabel;
    protected JLabel currentPageLabel;
    protected JXTable dataTable;
    protected JComboBox<DemandType> docTypeComboBox;
    protected JLabel docTypeLabel;
    protected JTextField ediCodeNumberField;
    protected JLabel ediCodeNumberLabel;
    protected JComboBox<Range> gammeComboBox;
    protected JLabel gammeLabel;
    protected JButton groupButton;
    protected final SearchToGroupUIHandler handler = createHandler();
    protected JTextField localReferenceField;
    protected JLabel localReferenceLabel;
    protected JTextField messageField;
    protected JLabel messageLabel;
    protected SearchUIModel model;
    protected JXDatePicker modifiedBetweenEndDatePicker;
    protected JLabel modifiedBetweenLabel;
    protected JXDatePicker modifiedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> modifiedByComboBox;
    protected JLabel modifiedByLabel;
    protected JButton nextPageButton;
    protected JTextField objectField;
    protected JLabel objectLabel;
    protected JLabel pageNumberLabel;
    protected JButton previousPageButton;
    protected JXDatePicker printedBetweenEndDatePicker;
    protected JLabel printedBetweenLabel;
    protected JXDatePicker printedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> printedByComboBox;
    protected JLabel printedByLabel;
    protected JComboBox<Priority> priorityComboBox;
    protected JLabel priorityLabel;
    protected JTextField projectReferenceField;
    protected JLabel projectReferenceLabel;
    protected JXDatePicker receivedBetweenEndDatePicker;
    protected JLabel receivedBetweenLabel;
    protected JXDatePicker receivedBetweenStartDatePicker;
    protected JXDatePicker repliedBetweenEndDatePicker;
    protected JLabel repliedBetweenLabel;
    protected JXDatePicker repliedBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> repliedByComboBox;
    protected JLabel repliedByLabel;
    protected JComboBox<Integer> resultPerPageCombo;
    protected JLabel resultsPerPageLabel;
    protected JButton searchButton;
    protected JScrollPane searchScrollPane;
    protected SearchToGroupUI searchToGroupPanel = this;
    protected JTextField senderField;
    protected JLabel senderLabel;
    protected JToggleButton showAdvancedSearchButton;
    protected JComboBox<DemandStatus> statusComboBox;
    protected JLabel statusLabel;
    protected BeanFilterableComboBox<FaxToMailUser> takenByComboBox;
    protected JLabel takenByLabel;
    protected JLabel totalDemandCountLabel;
    protected JLabel totalDemandCountValue;
    protected JLabel totalPageNumberLabel;
    protected JXDatePicker transferBetweenEndDatePicker;
    protected JLabel transferBetweenLabel;
    protected JXDatePicker transferBetweenStartDatePicker;
    protected BeanFilterableComboBox<FaxToMailUser> transferByComboBox;
    protected JLabel transferByLabel;
    protected JComboBox<WaitingState> waitingStateComboBox;
    protected JLabel waitingStateLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JScrollPane $JScrollPane0;
    private JSplitPane $JSplitPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SearchToGroupUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public SearchToGroupUI() {
        $initialize();
    }

    public SearchToGroupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SearchToGroupUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SearchToGroupUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SearchToGroupUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SearchToGroupUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SearchToGroupUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SearchToGroupUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__archivedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxArchivedDate(archivedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__archivedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinArchivedDate(archivedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__groupButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.group();
    }

    public void doActionPerformed__on__modifiedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxModificationDate(modifiedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__modifiedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinModificationDate(modifiedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__nextPageButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.goToNextPage();
    }

    public void doActionPerformed__on__previousPageButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.goToPreviousPage();
    }

    public void doActionPerformed__on__printedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxPrintingDate(printedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__printedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinPrintingDate(printedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__receivedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxReceptionDate(receivedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__receivedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinReceptionDate(receivedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__repliedBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxReplyDate(repliedBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__repliedBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinReplyDate(repliedBetweenStartDatePicker.getDate());
    }

    public void doActionPerformed__on__searchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.searchDemandes();
    }

    public void doActionPerformed__on__transferBetweenEndDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMaxTransferDate(transferBetweenEndDatePicker.getDate());
    }

    public void doActionPerformed__on__transferBetweenStartDatePicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setMinTransferDate(transferBetweenStartDatePicker.getDate());
    }

    public void doKeyReleased__on__bodyField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "body");
    }

    public void doKeyReleased__on__clientField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "clientCode");
    }

    public void doKeyReleased__on__commandNbField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "commandNb");
    }

    public void doKeyReleased__on__ediCodeNumberField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "ediCodeNumber");
    }

    public void doKeyReleased__on__localReferenceField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "localReference");
    }

    public void doKeyReleased__on__messageField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "message");
    }

    public void doKeyReleased__on__objectField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "demandObject");
    }

    public void doKeyReleased__on__projectReferenceField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "projectReference");
    }

    public void doKeyReleased__on__senderField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "sender");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXDatePicker getArchivedBetweenEndDatePicker() {
        return archivedBetweenEndDatePicker;
    }

    public JLabel getArchivedBetweenLabel() {
        return archivedBetweenLabel;
    }

    public JXDatePicker getArchivedBetweenStartDatePicker() {
        return archivedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getArchivedByComboBox() {
        return archivedByComboBox;
    }

    public JLabel getArchivedByLabel() {
        return archivedByLabel;
    }

    public JTextField getBodyField() {
        return bodyField;
    }

    public JLabel getBodyLabel() {
        return bodyLabel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextField getClientField() {
        return clientField;
    }

    public JLabel getClientLabel() {
        return clientLabel;
    }

    public JTextField getCommandNbField() {
        return commandNbField;
    }

    public JLabel getCommandNbLabel() {
        return commandNbLabel;
    }

    public JLabel getCurrentPageLabel() {
        return currentPageLabel;
    }

    public JXTable getDataTable() {
        return dataTable;
    }

    public JComboBox<DemandType> getDocTypeComboBox() {
        return docTypeComboBox;
    }

    public JLabel getDocTypeLabel() {
        return docTypeLabel;
    }

    public JTextField getEdiCodeNumberField() {
        return ediCodeNumberField;
    }

    public JLabel getEdiCodeNumberLabel() {
        return ediCodeNumberLabel;
    }

    public JComboBox<Range> getGammeComboBox() {
        return gammeComboBox;
    }

    public JLabel getGammeLabel() {
        return gammeLabel;
    }

    public JButton getGroupButton() {
        return groupButton;
    }

    public SearchToGroupUIHandler getHandler() {
        return handler;
    }

    public JTextField getLocalReferenceField() {
        return localReferenceField;
    }

    public JLabel getLocalReferenceLabel() {
        return localReferenceLabel;
    }

    public JTextField getMessageField() {
        return messageField;
    }

    public JLabel getMessageLabel() {
        return messageLabel;
    }

    public SearchUIModel getModel() {
        return model;
    }

    public JXDatePicker getModifiedBetweenEndDatePicker() {
        return modifiedBetweenEndDatePicker;
    }

    public JLabel getModifiedBetweenLabel() {
        return modifiedBetweenLabel;
    }

    public JXDatePicker getModifiedBetweenStartDatePicker() {
        return modifiedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getModifiedByComboBox() {
        return modifiedByComboBox;
    }

    public JLabel getModifiedByLabel() {
        return modifiedByLabel;
    }

    public JButton getNextPageButton() {
        return nextPageButton;
    }

    public JTextField getObjectField() {
        return objectField;
    }

    public JLabel getObjectLabel() {
        return objectLabel;
    }

    public JLabel getPageNumberLabel() {
        return pageNumberLabel;
    }

    public JButton getPreviousPageButton() {
        return previousPageButton;
    }

    public JXDatePicker getPrintedBetweenEndDatePicker() {
        return printedBetweenEndDatePicker;
    }

    public JLabel getPrintedBetweenLabel() {
        return printedBetweenLabel;
    }

    public JXDatePicker getPrintedBetweenStartDatePicker() {
        return printedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getPrintedByComboBox() {
        return printedByComboBox;
    }

    public JLabel getPrintedByLabel() {
        return printedByLabel;
    }

    public JComboBox<Priority> getPriorityComboBox() {
        return priorityComboBox;
    }

    public JLabel getPriorityLabel() {
        return priorityLabel;
    }

    public JTextField getProjectReferenceField() {
        return projectReferenceField;
    }

    public JLabel getProjectReferenceLabel() {
        return projectReferenceLabel;
    }

    public JXDatePicker getReceivedBetweenEndDatePicker() {
        return receivedBetweenEndDatePicker;
    }

    public JLabel getReceivedBetweenLabel() {
        return receivedBetweenLabel;
    }

    public JXDatePicker getReceivedBetweenStartDatePicker() {
        return receivedBetweenStartDatePicker;
    }

    public JXDatePicker getRepliedBetweenEndDatePicker() {
        return repliedBetweenEndDatePicker;
    }

    public JLabel getRepliedBetweenLabel() {
        return repliedBetweenLabel;
    }

    public JXDatePicker getRepliedBetweenStartDatePicker() {
        return repliedBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getRepliedByComboBox() {
        return repliedByComboBox;
    }

    public JLabel getRepliedByLabel() {
        return repliedByLabel;
    }

    public JComboBox<Integer> getResultPerPageCombo() {
        return resultPerPageCombo;
    }

    public JLabel getResultsPerPageLabel() {
        return resultsPerPageLabel;
    }

    public JButton getSearchButton() {
        return searchButton;
    }

    public JScrollPane getSearchScrollPane() {
        return searchScrollPane;
    }

    public JTextField getSenderField() {
        return senderField;
    }

    public JLabel getSenderLabel() {
        return senderLabel;
    }

    public JToggleButton getShowAdvancedSearchButton() {
        return showAdvancedSearchButton;
    }

    public JComboBox<DemandStatus> getStatusComboBox() {
        return statusComboBox;
    }

    public JLabel getStatusLabel() {
        return statusLabel;
    }

    public BeanFilterableComboBox<FaxToMailUser> getTakenByComboBox() {
        return takenByComboBox;
    }

    public JLabel getTakenByLabel() {
        return takenByLabel;
    }

    public JLabel getTotalDemandCountLabel() {
        return totalDemandCountLabel;
    }

    public JLabel getTotalDemandCountValue() {
        return totalDemandCountValue;
    }

    public JLabel getTotalPageNumberLabel() {
        return totalPageNumberLabel;
    }

    public JXDatePicker getTransferBetweenEndDatePicker() {
        return transferBetweenEndDatePicker;
    }

    public JLabel getTransferBetweenLabel() {
        return transferBetweenLabel;
    }

    public JXDatePicker getTransferBetweenStartDatePicker() {
        return transferBetweenStartDatePicker;
    }

    public BeanFilterableComboBox<FaxToMailUser> getTransferByComboBox() {
        return transferByComboBox;
    }

    public JLabel getTransferByLabel() {
        return transferByLabel;
    }

    public JComboBox<WaitingState> getWaitingStateComboBox() {
        return waitingStateComboBox;
    }

    public JLabel getWaitingStateLabel() {
        return waitingStateLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSearchScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        searchScrollPane.getViewport().add($Table0);
    }

    protected void addChildrenToSearchToGroupPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($JSplitPane0, BorderLayout.CENTER);
        add($JPanel4, BorderLayout.SOUTH);
    }

    protected void createArchivedBetweenEndDatePicker() {
        $objectMap.put("archivedBetweenEndDatePicker", archivedBetweenEndDatePicker = new JXDatePicker());
        
        archivedBetweenEndDatePicker.setName("archivedBetweenEndDatePicker");
        archivedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__archivedBetweenEndDatePicker"));
        archivedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createArchivedBetweenLabel() {
        $objectMap.put("archivedBetweenLabel", archivedBetweenLabel = new JLabel());
        
        archivedBetweenLabel.setName("archivedBetweenLabel");
        archivedBetweenLabel.setText(t("faxtomail.search.archivedBetween.label"));
    }

    protected void createArchivedBetweenStartDatePicker() {
        $objectMap.put("archivedBetweenStartDatePicker", archivedBetweenStartDatePicker = new JXDatePicker());
        
        archivedBetweenStartDatePicker.setName("archivedBetweenStartDatePicker");
        archivedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__archivedBetweenStartDatePicker"));
        archivedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createArchivedByComboBox() {
        $objectMap.put("archivedByComboBox", archivedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        archivedByComboBox.setName("archivedByComboBox");
        archivedByComboBox.setMaximumRowCount(20);
        archivedByComboBox.setShowDecorator(false);
        archivedByComboBox.setProperty("archivedBy");
        archivedByComboBox.setShowReset(true);
    }

    protected void createArchivedByLabel() {
        $objectMap.put("archivedByLabel", archivedByLabel = new JLabel());
        
        archivedByLabel.setName("archivedByLabel");
        archivedByLabel.setText(t("faxtomail.demande.archivedBy.label"));
    }

    protected void createBodyField() {
        $objectMap.put("bodyField", bodyField = new JTextField());
        
        bodyField.setName("bodyField");
        bodyField.setColumns(15);
        bodyField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__bodyField"));
    }

    protected void createBodyLabel() {
        $objectMap.put("bodyLabel", bodyLabel = new JLabel());
        
        bodyLabel.setName("bodyLabel");
        bodyLabel.setText(t("faxtomail.demande.body.label"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.searchToGroup.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.searchToGroup.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createClientField() {
        $objectMap.put("clientField", clientField = new JTextField());
        
        clientField.setName("clientField");
        clientField.setColumns(15);
        clientField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientField"));
    }

    protected void createClientLabel() {
        $objectMap.put("clientLabel", clientLabel = new JLabel());
        
        clientLabel.setName("clientLabel");
        clientLabel.setText(t("faxtomail.demande.client.label"));
    }

    protected void createCommandNbField() {
        $objectMap.put("commandNbField", commandNbField = new JTextField());
        
        commandNbField.setName("commandNbField");
        commandNbField.setColumns(15);
        commandNbField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commandNbField"));
    }

    protected void createCommandNbLabel() {
        $objectMap.put("commandNbLabel", commandNbLabel = new JLabel());
        
        commandNbLabel.setName("commandNbLabel");
        commandNbLabel.setText(t("faxtomail.demande.commandNb.label"));
    }

    protected void createCurrentPageLabel() {
        $objectMap.put("currentPageLabel", currentPageLabel = new JLabel());
        
        currentPageLabel.setName("currentPageLabel");
    }

    protected void createDataTable() {
        $objectMap.put("dataTable", dataTable = new JXTable());
        
        dataTable.setName("dataTable");
        dataTable.setEditable(true);
        dataTable.setAutoCreateRowSorter(true);
    }

    protected void createDocTypeComboBox() {
        $objectMap.put("docTypeComboBox", docTypeComboBox = new JComboBox<DemandType>());
        
        docTypeComboBox.setName("docTypeComboBox");
    }

    protected void createDocTypeLabel() {
        $objectMap.put("docTypeLabel", docTypeLabel = new JLabel());
        
        docTypeLabel.setName("docTypeLabel");
        docTypeLabel.setText(t("faxtomail.demande.docType.label"));
    }

    protected void createEdiCodeNumberField() {
        $objectMap.put("ediCodeNumberField", ediCodeNumberField = new JTextField());
        
        ediCodeNumberField.setName("ediCodeNumberField");
        ediCodeNumberField.setColumns(15);
        ediCodeNumberField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__ediCodeNumberField"));
    }

    protected void createEdiCodeNumberLabel() {
        $objectMap.put("ediCodeNumberLabel", ediCodeNumberLabel = new JLabel());
        
        ediCodeNumberLabel.setName("ediCodeNumberLabel");
        ediCodeNumberLabel.setText(t("faxtomail.demande.ediError.label"));
    }

    protected void createGammeComboBox() {
        $objectMap.put("gammeComboBox", gammeComboBox = new JComboBox<Range>());
        
        gammeComboBox.setName("gammeComboBox");
    }

    protected void createGammeLabel() {
        $objectMap.put("gammeLabel", gammeLabel = new JLabel());
        
        gammeLabel.setName("gammeLabel");
        gammeLabel.setText(t("faxtomail.demande.gamme.label"));
    }

    protected void createGroupButton() {
        $objectMap.put("groupButton", groupButton = new JButton());
        
        groupButton.setName("groupButton");
        groupButton.setText(t("faxtomail.searchToGroup.action.group"));
        groupButton.setToolTipText(t("faxtomail.searchToGroup.action.group.tip"));
        groupButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__groupButton"));
    }

    protected SearchToGroupUIHandler createHandler() {
        return new SearchToGroupUIHandler();
    }

    protected void createLocalReferenceField() {
        $objectMap.put("localReferenceField", localReferenceField = new JTextField());
        
        localReferenceField.setName("localReferenceField");
        localReferenceField.setColumns(15);
        localReferenceField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__localReferenceField"));
    }

    protected void createLocalReferenceLabel() {
        $objectMap.put("localReferenceLabel", localReferenceLabel = new JLabel());
        
        localReferenceLabel.setName("localReferenceLabel");
        localReferenceLabel.setText(t("faxtomail.demande.localReference.label"));
    }

    protected void createMessageField() {
        $objectMap.put("messageField", messageField = new JTextField());
        
        messageField.setName("messageField");
        messageField.setColumns(15);
        messageField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__messageField"));
    }

    protected void createMessageLabel() {
        $objectMap.put("messageLabel", messageLabel = new JLabel());
        
        messageLabel.setName("messageLabel");
        messageLabel.setText(t("faxtomail.demande.comment.label"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SearchUIModel.class));
    }

    protected void createModifiedBetweenEndDatePicker() {
        $objectMap.put("modifiedBetweenEndDatePicker", modifiedBetweenEndDatePicker = new JXDatePicker());
        
        modifiedBetweenEndDatePicker.setName("modifiedBetweenEndDatePicker");
        modifiedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__modifiedBetweenEndDatePicker"));
        modifiedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createModifiedBetweenLabel() {
        $objectMap.put("modifiedBetweenLabel", modifiedBetweenLabel = new JLabel());
        
        modifiedBetweenLabel.setName("modifiedBetweenLabel");
        modifiedBetweenLabel.setText(t("faxtomail.search.modifiedBetween.label"));
    }

    protected void createModifiedBetweenStartDatePicker() {
        $objectMap.put("modifiedBetweenStartDatePicker", modifiedBetweenStartDatePicker = new JXDatePicker());
        
        modifiedBetweenStartDatePicker.setName("modifiedBetweenStartDatePicker");
        modifiedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__modifiedBetweenStartDatePicker"));
        modifiedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createModifiedByComboBox() {
        $objectMap.put("modifiedByComboBox", modifiedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        modifiedByComboBox.setName("modifiedByComboBox");
        modifiedByComboBox.setMaximumRowCount(20);
        modifiedByComboBox.setShowDecorator(false);
        modifiedByComboBox.setShowReset(true);
    }

    protected void createModifiedByLabel() {
        $objectMap.put("modifiedByLabel", modifiedByLabel = new JLabel());
        
        modifiedByLabel.setName("modifiedByLabel");
        modifiedByLabel.setText(t("faxtomail.search.modifiedBy.label"));
    }

    protected void createNextPageButton() {
        $objectMap.put("nextPageButton", nextPageButton = new JButton());
        
        nextPageButton.setName("nextPageButton");
        nextPageButton.setText(t("faxtomail.demandeList.goToNextPage"));
        nextPageButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__nextPageButton"));
    }

    protected void createObjectField() {
        $objectMap.put("objectField", objectField = new JTextField());
        
        objectField.setName("objectField");
        objectField.setColumns(15);
        objectField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__objectField"));
    }

    protected void createObjectLabel() {
        $objectMap.put("objectLabel", objectLabel = new JLabel());
        
        objectLabel.setName("objectLabel");
        objectLabel.setText(t("faxtomail.demande.object.label"));
    }

    protected void createPageNumberLabel() {
        $objectMap.put("pageNumberLabel", pageNumberLabel = new JLabel());
        
        pageNumberLabel.setName("pageNumberLabel");
        pageNumberLabel.setText(t("faxtomail.demandeList.pages"));
    }

    protected void createPreviousPageButton() {
        $objectMap.put("previousPageButton", previousPageButton = new JButton());
        
        previousPageButton.setName("previousPageButton");
        previousPageButton.setText(t("faxtomail.demandeList.goToPreviousPage"));
        previousPageButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__previousPageButton"));
    }

    protected void createPrintedBetweenEndDatePicker() {
        $objectMap.put("printedBetweenEndDatePicker", printedBetweenEndDatePicker = new JXDatePicker());
        
        printedBetweenEndDatePicker.setName("printedBetweenEndDatePicker");
        printedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printedBetweenEndDatePicker"));
        printedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createPrintedBetweenLabel() {
        $objectMap.put("printedBetweenLabel", printedBetweenLabel = new JLabel());
        
        printedBetweenLabel.setName("printedBetweenLabel");
        printedBetweenLabel.setText(t("faxtomail.search.printedBetween.label"));
    }

    protected void createPrintedBetweenStartDatePicker() {
        $objectMap.put("printedBetweenStartDatePicker", printedBetweenStartDatePicker = new JXDatePicker());
        
        printedBetweenStartDatePicker.setName("printedBetweenStartDatePicker");
        printedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printedBetweenStartDatePicker"));
        printedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createPrintedByComboBox() {
        $objectMap.put("printedByComboBox", printedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        printedByComboBox.setName("printedByComboBox");
        printedByComboBox.setMaximumRowCount(20);
        printedByComboBox.setShowDecorator(false);
        printedByComboBox.setProperty("printingBy");
        printedByComboBox.setShowReset(true);
    }

    protected void createPrintedByLabel() {
        $objectMap.put("printedByLabel", printedByLabel = new JLabel());
        
        printedByLabel.setName("printedByLabel");
        printedByLabel.setText(t("faxtomail.demande.printedBy.label"));
    }

    protected void createPriorityComboBox() {
        $objectMap.put("priorityComboBox", priorityComboBox = new JComboBox<Priority>());
        
        priorityComboBox.setName("priorityComboBox");
    }

    protected void createPriorityLabel() {
        $objectMap.put("priorityLabel", priorityLabel = new JLabel());
        
        priorityLabel.setName("priorityLabel");
        priorityLabel.setText(t("faxtomail.demande.priority.label"));
    }

    protected void createProjectReferenceField() {
        $objectMap.put("projectReferenceField", projectReferenceField = new JTextField());
        
        projectReferenceField.setName("projectReferenceField");
        projectReferenceField.setColumns(15);
        projectReferenceField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__projectReferenceField"));
    }

    protected void createProjectReferenceLabel() {
        $objectMap.put("projectReferenceLabel", projectReferenceLabel = new JLabel());
        
        projectReferenceLabel.setName("projectReferenceLabel");
        projectReferenceLabel.setText(t("faxtomail.demande.projectReference.label"));
    }

    protected void createReceivedBetweenEndDatePicker() {
        $objectMap.put("receivedBetweenEndDatePicker", receivedBetweenEndDatePicker = new JXDatePicker());
        
        receivedBetweenEndDatePicker.setName("receivedBetweenEndDatePicker");
        receivedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__receivedBetweenEndDatePicker"));
        receivedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createReceivedBetweenLabel() {
        $objectMap.put("receivedBetweenLabel", receivedBetweenLabel = new JLabel());
        
        receivedBetweenLabel.setName("receivedBetweenLabel");
        receivedBetweenLabel.setText(t("faxtomail.search.receivedBetween.label"));
    }

    protected void createReceivedBetweenStartDatePicker() {
        $objectMap.put("receivedBetweenStartDatePicker", receivedBetweenStartDatePicker = new JXDatePicker());
        
        receivedBetweenStartDatePicker.setName("receivedBetweenStartDatePicker");
        receivedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__receivedBetweenStartDatePicker"));
        receivedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createRepliedBetweenEndDatePicker() {
        $objectMap.put("repliedBetweenEndDatePicker", repliedBetweenEndDatePicker = new JXDatePicker());
        
        repliedBetweenEndDatePicker.setName("repliedBetweenEndDatePicker");
        repliedBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__repliedBetweenEndDatePicker"));
        repliedBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createRepliedBetweenLabel() {
        $objectMap.put("repliedBetweenLabel", repliedBetweenLabel = new JLabel());
        
        repliedBetweenLabel.setName("repliedBetweenLabel");
        repliedBetweenLabel.setText(t("faxtomail.search.repliedBetween.label"));
    }

    protected void createRepliedBetweenStartDatePicker() {
        $objectMap.put("repliedBetweenStartDatePicker", repliedBetweenStartDatePicker = new JXDatePicker());
        
        repliedBetweenStartDatePicker.setName("repliedBetweenStartDatePicker");
        repliedBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__repliedBetweenStartDatePicker"));
        repliedBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createRepliedByComboBox() {
        $objectMap.put("repliedByComboBox", repliedByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        repliedByComboBox.setName("repliedByComboBox");
        repliedByComboBox.setMaximumRowCount(20);
        repliedByComboBox.setShowDecorator(false);
        repliedByComboBox.setProperty("replyBy");
        repliedByComboBox.setShowReset(true);
    }

    protected void createRepliedByLabel() {
        $objectMap.put("repliedByLabel", repliedByLabel = new JLabel());
        
        repliedByLabel.setName("repliedByLabel");
        repliedByLabel.setText(t("faxtomail.demande.repliedBy.label"));
    }

    protected void createResultPerPageCombo() {
        $objectMap.put("resultPerPageCombo", resultPerPageCombo = new JComboBox<Integer>());
        
        resultPerPageCombo.setName("resultPerPageCombo");
    }

    protected void createResultsPerPageLabel() {
        $objectMap.put("resultsPerPageLabel", resultsPerPageLabel = new JLabel());
        
        resultsPerPageLabel.setName("resultsPerPageLabel");
        resultsPerPageLabel.setText(t("faxtomail.demandeList.resultPerPage"));
    }

    protected void createSearchButton() {
        $objectMap.put("searchButton", searchButton = new JButton());
        
        searchButton.setName("searchButton");
        searchButton.setText(t("faxtomail.search.button.label"));
        searchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__searchButton"));
    }

    protected void createSearchScrollPane() {
        $objectMap.put("searchScrollPane", searchScrollPane = new JScrollPane());
        
        searchScrollPane.setName("searchScrollPane");
    }

    protected void createSenderField() {
        $objectMap.put("senderField", senderField = new JTextField());
        
        senderField.setName("senderField");
        senderField.setColumns(15);
        senderField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__senderField"));
    }

    protected void createSenderLabel() {
        $objectMap.put("senderLabel", senderLabel = new JLabel());
        
        senderLabel.setName("senderLabel");
        senderLabel.setText(t("faxtomail.demande.sender.label"));
    }

    protected void createShowAdvancedSearchButton() {
        $objectMap.put("showAdvancedSearchButton", showAdvancedSearchButton = new JToggleButton());
        
        showAdvancedSearchButton.setName("showAdvancedSearchButton");
    }

    protected void createStatusComboBox() {
        $objectMap.put("statusComboBox", statusComboBox = new JComboBox<DemandStatus>());
        
        statusComboBox.setName("statusComboBox");
    }

    protected void createStatusLabel() {
        $objectMap.put("statusLabel", statusLabel = new JLabel());
        
        statusLabel.setName("statusLabel");
        statusLabel.setText(t("faxtomail.demande.status.label"));
    }

    protected void createTakenByComboBox() {
        $objectMap.put("takenByComboBox", takenByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        takenByComboBox.setName("takenByComboBox");
        takenByComboBox.setMaximumRowCount(20);
        takenByComboBox.setShowDecorator(false);
        takenByComboBox.setProperty("takenBy");
        takenByComboBox.setShowReset(true);
    }

    protected void createTakenByLabel() {
        $objectMap.put("takenByLabel", takenByLabel = new JLabel());
        
        takenByLabel.setName("takenByLabel");
        takenByLabel.setText(t("faxtomail.demande.takenBy.label"));
    }

    protected void createTotalDemandCountLabel() {
        $objectMap.put("totalDemandCountLabel", totalDemandCountLabel = new JLabel());
        
        totalDemandCountLabel.setName("totalDemandCountLabel");
        totalDemandCountLabel.setText(t("faxtomail.demandeList.totalCount"));
    }

    protected void createTotalDemandCountValue() {
        $objectMap.put("totalDemandCountValue", totalDemandCountValue = new JLabel());
        
        totalDemandCountValue.setName("totalDemandCountValue");
    }

    protected void createTotalPageNumberLabel() {
        $objectMap.put("totalPageNumberLabel", totalPageNumberLabel = new JLabel());
        
        totalPageNumberLabel.setName("totalPageNumberLabel");
    }

    protected void createTransferBetweenEndDatePicker() {
        $objectMap.put("transferBetweenEndDatePicker", transferBetweenEndDatePicker = new JXDatePicker());
        
        transferBetweenEndDatePicker.setName("transferBetweenEndDatePicker");
        transferBetweenEndDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__transferBetweenEndDatePicker"));
        transferBetweenEndDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createTransferBetweenLabel() {
        $objectMap.put("transferBetweenLabel", transferBetweenLabel = new JLabel());
        
        transferBetweenLabel.setName("transferBetweenLabel");
        transferBetweenLabel.setText(t("faxtomail.search.transferBetween.label"));
    }

    protected void createTransferBetweenStartDatePicker() {
        $objectMap.put("transferBetweenStartDatePicker", transferBetweenStartDatePicker = new JXDatePicker());
        
        transferBetweenStartDatePicker.setName("transferBetweenStartDatePicker");
        transferBetweenStartDatePicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__transferBetweenStartDatePicker"));
        transferBetweenStartDatePicker.putClientProperty("selectOnFocus", true);
    }

    protected void createTransferByComboBox() {
        $objectMap.put("transferByComboBox", transferByComboBox = new BeanFilterableComboBox<FaxToMailUser>(this));
        
        transferByComboBox.setName("transferByComboBox");
        transferByComboBox.setMaximumRowCount(20);
        transferByComboBox.setShowDecorator(false);
        transferByComboBox.setProperty("transferBy");
        transferByComboBox.setShowReset(true);
    }

    protected void createTransferByLabel() {
        $objectMap.put("transferByLabel", transferByLabel = new JLabel());
        
        transferByLabel.setName("transferByLabel");
        transferByLabel.setText(t("faxtomail.demande.transferBy.label"));
    }

    protected void createWaitingStateComboBox() {
        $objectMap.put("waitingStateComboBox", waitingStateComboBox = new JComboBox<WaitingState>());
        
        waitingStateComboBox.setName("waitingStateComboBox");
    }

    protected void createWaitingStateLabel() {
        $objectMap.put("waitingStateLabel", waitingStateLabel = new JLabel());
        
        waitingStateLabel.setName("waitingStateLabel");
        waitingStateLabel.setText(t("faxtomail.demande.waitingState.label"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSearchToGroupPanel();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add($JPanel2, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add(searchScrollPane, BorderLayout.CENTER);
        $JPanel0.add($JPanel1, BorderLayout.SOUTH);
        addChildrenToSearchScrollPane();
        // inline complete setup of $Table0
        $Table0.add(receivedBetweenLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(receivedBetweenStartDatePicker, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(receivedBetweenEndDatePicker, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(priorityLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(priorityComboBox, new GridBagConstraints(5, 0, 1, 1, 2.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(commandNbLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(commandNbField, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(waitingStateLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(waitingStateComboBox, new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(projectReferenceLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(projectReferenceField, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(localReferenceLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(localReferenceField, new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gammeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gammeComboBox, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(objectLabel, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(objectField, new GridBagConstraints(5, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(docTypeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(docTypeComboBox, new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(bodyLabel, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(bodyField, new GridBagConstraints(5, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(clientLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(clientField, new GridBagConstraints(1, 5, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(messageLabel, new GridBagConstraints(4, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(messageField, new GridBagConstraints(5, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(senderLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(senderField, new GridBagConstraints(1, 6, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(statusLabel, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(statusComboBox, new GridBagConstraints(5, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(showAdvancedSearchButton, new GridBagConstraints(0, 7, 6, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(takenByLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(takenByComboBox, new GridBagConstraints(1, 8, 3, 1, 2.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ediCodeNumberLabel, new GridBagConstraints(4, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ediCodeNumberField, new GridBagConstraints(5, 8, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedBetweenLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedBetweenStartDatePicker, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedBetweenEndDatePicker, new GridBagConstraints(3, 9, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedByLabel, new GridBagConstraints(4, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(modifiedByComboBox, new GridBagConstraints(5, 9, 3, 1, 2.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferBetweenLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferBetweenStartDatePicker, new GridBagConstraints(1, 10, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferBetweenEndDatePicker, new GridBagConstraints(3, 10, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferByLabel, new GridBagConstraints(4, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(transferByComboBox, new GridBagConstraints(5, 10, 3, 1, 2.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedBetweenLabel, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedBetweenStartDatePicker, new GridBagConstraints(1, 11, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(2, 11, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedBetweenEndDatePicker, new GridBagConstraints(3, 11, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedByLabel, new GridBagConstraints(4, 11, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(archivedByComboBox, new GridBagConstraints(5, 11, 3, 1, 2.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedBetweenLabel, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedBetweenStartDatePicker, new GridBagConstraints(1, 12, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(2, 12, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedBetweenEndDatePicker, new GridBagConstraints(3, 12, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedByLabel, new GridBagConstraints(4, 12, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(printedByComboBox, new GridBagConstraints(5, 12, 3, 1, 2.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedBetweenLabel, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedBetweenStartDatePicker, new GridBagConstraints(1, 13, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel5, new GridBagConstraints(2, 13, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedBetweenEndDatePicker, new GridBagConstraints(3, 13, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedByLabel, new GridBagConstraints(4, 13, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(repliedByComboBox, new GridBagConstraints(5, 13, 3, 1, 2.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(searchButton);
        // inline complete setup of $JPanel2
        $JPanel2.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel2.add($JPanel3, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(dataTable);
        // inline complete setup of $JPanel3
        $JPanel3.add(totalDemandCountLabel);
        $JPanel3.add(totalDemandCountValue);
        $JPanel3.add($JLabel6);
        $JPanel3.add(resultsPerPageLabel);
        $JPanel3.add(resultPerPageCombo);
        $JPanel3.add($JLabel7);
        $JPanel3.add(pageNumberLabel);
        $JPanel3.add(previousPageButton);
        $JPanel3.add(currentPageLabel);
        $JPanel3.add($JLabel8);
        $JPanel3.add(totalPageNumberLabel);
        $JPanel3.add(nextPageButton);
        // inline complete setup of $JPanel4
        $JPanel4.add(cancelButton);
        $JPanel4.add(groupButton);
        
        // apply 66 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 23 property setters
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        takenByComboBox.setBeanType(FaxToMailUser.class);
        modifiedByComboBox.setBeanType(FaxToMailUser.class);
        transferByComboBox.setBeanType(FaxToMailUser.class);
        archivedByComboBox.setBeanType(FaxToMailUser.class);
        printedByComboBox.setBeanType(FaxToMailUser.class);
        repliedByComboBox.setBeanType(FaxToMailUser.class);
        showAdvancedSearchButton.setSelectedIcon( JAXXWidgetUtil.createActionIcon("collapse") );
        showAdvancedSearchButton.setIcon(SwingUtil.createActionIcon("expand"));
        takenByComboBox.setBean(model);
        modifiedByComboBox.setBean(model);
        transferByComboBox.setBean(model);
        archivedByComboBox.setBean(model);
        printedByComboBox.setBean(model);
        repliedByComboBox.setBean(model);
        searchButton.setMnemonic(SwingUtil.getFirstCharAt(t("faxtomail.search.button.mnemonic"),'Z'));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        groupButton.setIcon(SwingUtil.createActionIcon("group"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("searchToGroupPanel", searchToGroupPanel);
        createModel();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createSearchScrollPane();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createReceivedBetweenLabel();
        createReceivedBetweenStartDatePicker();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("faxtomail.search.between2ndPart.label"));
        createReceivedBetweenEndDatePicker();
        createPriorityLabel();
        createPriorityComboBox();
        createCommandNbLabel();
        createCommandNbField();
        createWaitingStateLabel();
        createWaitingStateComboBox();
        createProjectReferenceLabel();
        createProjectReferenceField();
        createLocalReferenceLabel();
        createLocalReferenceField();
        createGammeLabel();
        createGammeComboBox();
        createObjectLabel();
        createObjectField();
        createDocTypeLabel();
        createDocTypeComboBox();
        createBodyLabel();
        createBodyField();
        createClientLabel();
        createClientField();
        createMessageLabel();
        createMessageField();
        createSenderLabel();
        createSenderField();
        createStatusLabel();
        createStatusComboBox();
        createShowAdvancedSearchButton();
        createTakenByLabel();
        createTakenByComboBox();
        createEdiCodeNumberLabel();
        createEdiCodeNumberField();
        createModifiedBetweenLabel();
        createModifiedBetweenStartDatePicker();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("faxtomail.search.between2ndPart.label"));
        createModifiedBetweenEndDatePicker();
        createModifiedByLabel();
        createModifiedByComboBox();
        createTransferBetweenLabel();
        createTransferBetweenStartDatePicker();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("faxtomail.search.between2ndPart.label"));
        createTransferBetweenEndDatePicker();
        createTransferByLabel();
        createTransferByComboBox();
        createArchivedBetweenLabel();
        createArchivedBetweenStartDatePicker();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("faxtomail.search.between2ndPart.label"));
        createArchivedBetweenEndDatePicker();
        createArchivedByLabel();
        createArchivedByComboBox();
        createPrintedBetweenLabel();
        createPrintedBetweenStartDatePicker();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("faxtomail.search.between2ndPart.label"));
        createPrintedBetweenEndDatePicker();
        createPrintedByLabel();
        createPrintedByComboBox();
        createRepliedBetweenLabel();
        createRepliedBetweenStartDatePicker();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("faxtomail.search.between2ndPart.label"));
        createRepliedBetweenEndDatePicker();
        createRepliedByLabel();
        createRepliedByComboBox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createSearchButton();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createDataTable();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new FlowLayout(FlowLayout.LEADING));
        createTotalDemandCountLabel();
        createTotalDemandCountValue();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(t(" | "));
        createResultsPerPageLabel();
        createResultPerPageCombo();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(t(" | "));
        createPageNumberLabel();
        createPreviousPageButton();
        createCurrentPageLabel();
        // inline creation of $JLabel8
        $objectMap.put("$JLabel8", $JLabel8 = new JLabel());
        
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(t("/"));
        createTotalPageNumberLabel();
        createNextPageButton();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createGroupButton();
        // inline creation of searchToGroupPanel
        setName("searchToGroupPanel");
        setLayout(new BorderLayout());
        
        // registers 66 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 66 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEIVED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minReceptionDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    receivedBetweenStartDatePicker.setDate( model.getMinReceptionDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minReceptionDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEIVED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxReceptionDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    receivedBetweenEndDatePicker.setDate( model.getMaxReceptionDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxReceptionDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMAND_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("commandNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commandNbField,  model.getCommandNb() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("commandNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_REFERENCE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("projectReference", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(projectReferenceField,  model.getProjectReference() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("projectReference", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCAL_REFERENCE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("localReference", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(localReferenceField,  model.getLocalReference() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("localReference", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OBJECT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("demandObject", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(objectField, model.getDemandObject());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("demandObject", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BODY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("body", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(bodyField,  model.getBody() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("body", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MESSAGE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("message", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(messageField,  model.getMessage() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("message", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SENDER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sender", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(senderField, model.getSender());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sender", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SHOW_ADVANCED_SEARCH_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_SHOW_ADVANCED_SEARCH_BUTTON_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    showAdvancedSearchButton.setText(t( showAdvancedSearchButton.isSelected() ? "faxtomail.search.hideAdvancedSearch.label" : "faxtomail.search.showAdvancedSearch.label" ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_SHOW_ADVANCED_SEARCH_BUTTON_TEXT));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TAKEN_BY_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TAKEN_BY_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    takenByLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TAKEN_BY_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TAKEN_BY_COMBO_BOX_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TAKEN_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    takenByComboBox.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TAKEN_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TAKEN_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("takenBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    takenByComboBox.setSelectedItem( model.getTakenBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("takenBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDI_CODE_NUMBER_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_EDI_CODE_NUMBER_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ediCodeNumberLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_EDI_CODE_NUMBER_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDI_CODE_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ediCodeNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(ediCodeNumberField,  model.getEdiCodeNumber() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ediCodeNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDI_CODE_NUMBER_FIELD_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_EDI_CODE_NUMBER_FIELD_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ediCodeNumberField.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u4"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_EDI_CODE_NUMBER_FIELD_VISIBLE));
                }
            }
        
            public void $pr$u4(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BETWEEN_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_MODIFIED_BETWEEN_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    modifiedBetweenLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u5"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_MODIFIED_BETWEEN_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u5(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BETWEEN_START_DATE_PICKER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_MODIFIED_BETWEEN_START_DATE_PICKER_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    modifiedBetweenStartDatePicker.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u6"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_MODIFIED_BETWEEN_START_DATE_PICKER_VISIBLE));
                }
            }
        
            public void $pr$u6(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minModificationDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    modifiedBetweenStartDatePicker.setDate( model.getMinModificationDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minModificationDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL1_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_$JLABEL1_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $JLabel1.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u7"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_$JLABEL1_VISIBLE));
                }
            }
        
            public void $pr$u7(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BETWEEN_END_DATE_PICKER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u8"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_MODIFIED_BETWEEN_END_DATE_PICKER_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    modifiedBetweenEndDatePicker.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u8"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_MODIFIED_BETWEEN_END_DATE_PICKER_VISIBLE));
                }
            }
        
            public void $pr$u8(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxModificationDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    modifiedBetweenEndDatePicker.setDate( model.getMaxModificationDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxModificationDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BY_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u9"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_MODIFIED_BY_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    modifiedByLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u9"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_MODIFIED_BY_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u9(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODIFIED_BY_COMBO_BOX_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_MODIFIED_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    modifiedByComboBox.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u10"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_MODIFIED_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            public void $pr$u10(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BETWEEN_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u11"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TRANSFER_BETWEEN_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    transferBetweenLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u11"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TRANSFER_BETWEEN_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u11(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BETWEEN_START_DATE_PICKER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u12"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TRANSFER_BETWEEN_START_DATE_PICKER_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    transferBetweenStartDatePicker.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u12"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TRANSFER_BETWEEN_START_DATE_PICKER_VISIBLE));
                }
            }
        
            public void $pr$u12(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minTransferDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transferBetweenStartDatePicker.setDate( model.getMinTransferDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minTransferDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL2_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_$JLABEL2_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $JLabel2.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u13"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_$JLABEL2_VISIBLE));
                }
            }
        
            public void $pr$u13(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BETWEEN_END_DATE_PICKER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TRANSFER_BETWEEN_END_DATE_PICKER_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    transferBetweenEndDatePicker.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u14"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TRANSFER_BETWEEN_END_DATE_PICKER_VISIBLE));
                }
            }
        
            public void $pr$u14(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxTransferDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transferBetweenEndDatePicker.setDate( model.getMaxTransferDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxTransferDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BY_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u15"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TRANSFER_BY_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    transferByLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u15"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TRANSFER_BY_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u15(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BY_COMBO_BOX_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u16"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TRANSFER_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    transferByComboBox.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u16"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_TRANSFER_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            public void $pr$u16(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSFER_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("transferBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    transferByComboBox.setSelectedItem( model.getTransferBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("transferBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BETWEEN_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u17"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_ARCHIVED_BETWEEN_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    archivedBetweenLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u17"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_ARCHIVED_BETWEEN_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u17(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BETWEEN_START_DATE_PICKER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u18"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_ARCHIVED_BETWEEN_START_DATE_PICKER_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    archivedBetweenStartDatePicker.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u18"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_ARCHIVED_BETWEEN_START_DATE_PICKER_VISIBLE));
                }
            }
        
            public void $pr$u18(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minArchivedDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archivedBetweenStartDatePicker.setDate( model.getMinArchivedDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minArchivedDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL3_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u19"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_$JLABEL3_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $JLabel3.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u19"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_$JLABEL3_VISIBLE));
                }
            }
        
            public void $pr$u19(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BETWEEN_END_DATE_PICKER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u20"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_ARCHIVED_BETWEEN_END_DATE_PICKER_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    archivedBetweenEndDatePicker.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u20"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_ARCHIVED_BETWEEN_END_DATE_PICKER_VISIBLE));
                }
            }
        
            public void $pr$u20(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxArchivedDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archivedBetweenEndDatePicker.setDate( model.getMaxArchivedDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxArchivedDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BY_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u21"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_ARCHIVED_BY_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    archivedByLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u21"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_ARCHIVED_BY_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u21(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BY_COMBO_BOX_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u22"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_ARCHIVED_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    archivedByComboBox.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u22"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_ARCHIVED_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            public void $pr$u22(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVED_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("archivedBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    archivedByComboBox.setSelectedItem( model.getArchivedBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("archivedBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BETWEEN_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u23"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_PRINTED_BETWEEN_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    printedBetweenLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u23"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_PRINTED_BETWEEN_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u23(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BETWEEN_START_DATE_PICKER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u24"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_PRINTED_BETWEEN_START_DATE_PICKER_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    printedBetweenStartDatePicker.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u24"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_PRINTED_BETWEEN_START_DATE_PICKER_VISIBLE));
                }
            }
        
            public void $pr$u24(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minPrintingDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printedBetweenStartDatePicker.setDate( model.getMinPrintingDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minPrintingDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL4_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u25"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_$JLABEL4_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $JLabel4.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u25"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_$JLABEL4_VISIBLE));
                }
            }
        
            public void $pr$u25(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BETWEEN_END_DATE_PICKER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u26"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_PRINTED_BETWEEN_END_DATE_PICKER_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    printedBetweenEndDatePicker.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u26"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_PRINTED_BETWEEN_END_DATE_PICKER_VISIBLE));
                }
            }
        
            public void $pr$u26(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxPrintingDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printedBetweenEndDatePicker.setDate( model.getMaxPrintingDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxPrintingDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BY_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u27"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_PRINTED_BY_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    printedByLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u27"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_PRINTED_BY_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u27(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BY_COMBO_BOX_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u28"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_PRINTED_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    printedByComboBox.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u28"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_PRINTED_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            public void $pr$u28(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRINTED_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("printingBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    printedByComboBox.setSelectedItem( model.getPrintingBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("printingBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BETWEEN_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u29"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_REPLIED_BETWEEN_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    repliedBetweenLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u29"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_REPLIED_BETWEEN_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u29(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BETWEEN_START_DATE_PICKER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u30"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_REPLIED_BETWEEN_START_DATE_PICKER_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    repliedBetweenStartDatePicker.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u30"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_REPLIED_BETWEEN_START_DATE_PICKER_VISIBLE));
                }
            }
        
            public void $pr$u30(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BETWEEN_START_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minReplyDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    repliedBetweenStartDatePicker.setDate( model.getMinReplyDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minReplyDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL5_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u31"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_$JLABEL5_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $JLabel5.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u31"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_$JLABEL5_VISIBLE));
                }
            }
        
            public void $pr$u31(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BETWEEN_END_DATE_PICKER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u32"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_REPLIED_BETWEEN_END_DATE_PICKER_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    repliedBetweenEndDatePicker.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u32"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_REPLIED_BETWEEN_END_DATE_PICKER_VISIBLE));
                }
            }
        
            public void $pr$u32(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BETWEEN_END_DATE_PICKER_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxReplyDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    repliedBetweenEndDatePicker.setDate( model.getMaxReplyDate() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxReplyDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BY_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u33"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_REPLIED_BY_LABEL_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    repliedByLabel.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u33"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_REPLIED_BY_LABEL_VISIBLE));
                }
            }
        
            public void $pr$u33(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BY_COMBO_BOX_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (showAdvancedSearchButton != null) {
                    $bindingSources.put("showAdvancedSearchButton.getModel()", showAdvancedSearchButton.getModel());
                    showAdvancedSearchButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u34"));
                    showAdvancedSearchButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_REPLIED_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showAdvancedSearchButton != null) {
                    repliedByComboBox.setVisible( showAdvancedSearchButton.isSelected() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showAdvancedSearchButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showAdvancedSearchButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u34"));
                    }
                    showAdvancedSearchButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI.this, BINDING_REPLIED_BY_COMBO_BOX_VISIBLE));
                }
            }
        
            public void $pr$u34(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLIED_BY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("replyBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    repliedByComboBox.setSelectedItem( model.getReplyBy() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("replyBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_DEMAND_COUNT_VALUE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("paginationResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getPaginationResult() != null) {
                    totalDemandCountValue.setText(t( String.valueOf(model.getPaginationResult().getCount()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("paginationResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PREVIOUS_PAGE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("paginationResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getPaginationResult() != null) {
                    previousPageButton.setEnabled( model.getPaginationResult().hasPreviousPage() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("paginationResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CURRENT_PAGE_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("paginationParameter", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null && getModel().getPaginationParameter() != null) {
                    currentPageLabel.setText(t( String.valueOf(getModel().getPaginationParameter().getPageNumber() + 1) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("paginationParameter", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_PAGE_NUMBER_LABEL_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("paginationResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null && getModel().getPaginationResult() != null && getModel().getPaginationResult().getLastPage() != null) {
                    totalPageNumberLabel.setText(t( String.valueOf(getModel().getPaginationResult().getLastPage().getPageNumber() + 1) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("paginationResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEXT_PAGE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("paginationResult", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getPaginationResult() != null) {
                    nextPageButton.setEnabled( model.getPaginationResult().hasNextPage() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("paginationResult", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GROUP_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("groupEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    groupButton.setEnabled( model.isGroupEnabled() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("groupEnabled", this);
                }
            }
        });
    }

}