/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyLDAPRequest;
import com.unboundid.util.Extensible;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extensible
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public abstract class LDAPRequest
implements ReadOnlyLDAPRequest {
    static final Control[] NO_CONTROLS = new Control[0];
    private static final long serialVersionUID = -2040756188243320117L;
    private Boolean followReferrals;
    private Control[] controls;
    private IntermediateResponseListener intermediateResponseListener;
    private long responseTimeout;

    protected LDAPRequest(Control[] controls) {
        this.controls = controls == null ? NO_CONTROLS : controls;
        this.followReferrals = null;
        this.responseTimeout = -1L;
        this.intermediateResponseListener = null;
    }

    public final Control[] getControls() {
        return this.controls;
    }

    @Override
    public final List<Control> getControlList() {
        return Collections.unmodifiableList(Arrays.asList(this.controls));
    }

    @Override
    public final boolean hasControl() {
        return this.controls.length > 0;
    }

    @Override
    public final boolean hasControl(String oid) {
        Validator.ensureNotNull(oid);
        for (Control c : this.controls) {
            if (!c.getOID().equals(oid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Control getControl(String oid) {
        Validator.ensureNotNull(oid);
        for (Control c : this.controls) {
            if (!c.getOID().equals(oid)) continue;
            return c;
        }
        return null;
    }

    final void setControlsInternal(Control[] controls) {
        this.controls = controls;
    }

    @Override
    public final long getResponseTimeoutMillis(LDAPConnection connection) {
        if (this.responseTimeout < 0L && connection != null) {
            return connection.getConnectionOptions().getResponseTimeoutMillis();
        }
        return this.responseTimeout;
    }

    public final void setResponseTimeoutMillis(long responseTimeout) {
        this.responseTimeout = responseTimeout < 0L ? -1L : responseTimeout;
    }

    @Override
    public final boolean followReferrals(LDAPConnection connection) {
        if (this.followReferrals == null) {
            return connection.getConnectionOptions().followReferrals();
        }
        return this.followReferrals;
    }

    final Boolean followReferralsInternal() {
        return this.followReferrals;
    }

    public final void setFollowReferrals(Boolean followReferrals) {
        this.followReferrals = followReferrals;
    }

    public final IntermediateResponseListener getIntermediateResponseListener() {
        return this.intermediateResponseListener;
    }

    public final void setIntermediateResponseListener(IntermediateResponseListener listener) {
        this.intermediateResponseListener = listener;
    }

    @InternalUseOnly
    protected abstract LDAPResult process(LDAPConnection var1, int var2) throws LDAPException;

    public abstract int getLastMessageID();

    public abstract OperationType getOperationType();

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public abstract void toString(StringBuilder var1);
}

