package com.franciaflex.faxtomail.ui.swing.content.attachment;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class AttachmentItem extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ATTACHMENT = "attachment";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENT_NAME_LABEL_TEXT = "attachmentNameLabel.text";
    public static final String BINDING_EDIT_ATTACHMENT_BUTTON_ENABLED = "editAttachmentButton.enabled";
    public static final String BINDING_EDIT_ATTACHMENT_BUTTON_VISIBLE = "editAttachmentButton.visible";
    public static final String BINDING_OPEN_EDITED_ATTACHMENT_BUTTON_ENABLED = "openEditedAttachmentButton.enabled";
    public static final String BINDING_OPEN_EDITED_ATTACHMENT_BUTTON_VISIBLE = "openEditedAttachmentButton.visible";
    public static final String BINDING_REMOVE_ATTACHMENT_BUTTON_ENABLED = "removeAttachmentButton.enabled";
    public static final String BINDING_REMOVE_ATTACHMENT_BUTTON_VISIBLE = "removeAttachmentButton.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAMVWz28bRRSebGOndlpomxAFaKUNSFVSpePSniBAW+eHmsolVZJKFT60Y+84nmp2Z5mZTTayQPwJ/Alw54LEjRPiwJkDF8S/gBAHroj3dm1v7KxjA5XwYe3MvO97730775t8/RspGE2WXrA4pjoKrPA5fXj/6dOdxgvetBvcNLUIrdIk/Uw5xKmTWa+/bix5u15DeKULr6wrP1QBD06g12qkbOyx5KbNubXk2iCiaUxlr7+9FoeR7rH2i8pj/fKP350vvM+/cgiJQ6iuDK2441BZJ9M14gjPkiuQ6ZBVJAsOoAwtggOo9yKurUtmzEfM55+Qz8hMjRRDpoHMkrcmbznhSPBxaMmrzFrWbPsQ+5gFXFqy0VQ+bWkWNAVrSR7TFout8pmQNBLUHEE5tKkCCwiagen9/s9ty/0wTFIULSlnMZa8O5o75NoIA6xNTiFWWMHNCdKMcKbNAk9ybcnOf6100xOgzJPtByljluM8hx3WkNySy6g7xXdBq0pJzoIsbC5jxZdSYw0U8Aoi4m7+h8kixpeyDiwQNRh0MD8Qug/LVaYHg+dVyIOs5GpkLbRE5gaQ6SoiFvvANxCIHXJvGI4R1waj57HjCeIWNPfVIT8rUpM3B848TBPNpik77lN1UtARLFuyWD89gLuwlY7e4tDoIWGy+9fC3M/f/frtVm/eSpD7tdzQE3YBcxBq0EbjCYMBSIctskJWHrFwrQ4sXILXJF5yNaewve42FAf50vOBcPqAmTZQFGZ++f6Hhec/nSPOFilLxbwthvHbpGTbGlRQ0ovDu/eSii4cnYfnJawNavFZLPzI31VH6yrCgXFu34pBgas5CvTLaJR+/HNu75t7PRUcqOr1keGZEoWPSVEEUgQ88Z2upeT6zGxoeOSpzDryzISAnSxUYUC2hLRc4/iADzVUVcXdkbmDIRcwZGhjJXnezNOk2FDaw2mvdNxq8jNV85g2NWeWb/qhPU43lm+vundWXXyuuJ/GEXK+gyzd5KfdLhyff9ryGF7EZsfNsO7SB24QSenedQ/4ialZXqHw944WByJgEmTgqOHyivteGp5bU56JjKvLsaTUgpPV9ahCi0kD3xdTrR4zAabn9dbzkvYsaIJEZZBbqGAbnZSU0FRutgRmnUWOfRHuJwLdyMyXDRksTRkoYqkVYV5BuTY3rrppaIQHqAE0u9FxuzdD//Vcv95bosIM2j6ClodeHhwaIDwURiSqXuq4wvRjk80BLabRMv+FDAgbKUOeDf+/MlzuuEtn6jDbAkPj+lmeHLcmOxU8uaZGiXLGTfaPpNmcWJpdvORewhEpeuC69tSsrI5XJb1mRyky4haewM6Kkh0rCCavvO+BfbgNEXjwL8SHp7JM4bMMjH8D+1ENo5MLAAA=";
    private static final Log log = LogFactory.getLog(AttachmentItem.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Attachment attachment;
    protected JLabel attachmentNameLabel;
    protected AttachmentItem attachmentPanel = this;
    protected JButton editAttachmentButton;
    protected Boolean editable;
    protected AttachmentEditorUIHandler handler;
    protected JButton openAttachmentButton;
    protected JButton openEditedAttachmentButton;
    protected JButton removeAttachmentButton;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentItem() {
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(boolean param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.editAttachment(attachment);
    }

    public void doActionPerformed__on__openAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openAttachment(attachment);
    }

    public void doActionPerformed__on__openEditedAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.editAttachment(attachment);
    }

    public void doActionPerformed__on__removeAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeAttachment(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Attachment getAttachment() {
        return attachment;
    }

    public JLabel getAttachmentNameLabel() {
        return attachmentNameLabel;
    }

    public JButton getEditAttachmentButton() {
        return editAttachmentButton;
    }

    public Boolean getEditable() {
        return editable;
    }

    public AttachmentEditorUIHandler getHandler() {
        return handler;
    }

    public JButton getOpenAttachmentButton() {
        return openAttachmentButton;
    }

    public JButton getOpenEditedAttachmentButton() {
        return openEditedAttachmentButton;
    }

    public JButton getRemoveAttachmentButton() {
        return removeAttachmentButton;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAttachment(Attachment attachment) {
        Attachment oldValue = this.attachment;
        this.attachment = attachment;
        firePropertyChange(PROPERTY_ATTACHMENT, oldValue, attachment);
    }

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setHandler(AttachmentEditorUIHandler handler) {
        AttachmentEditorUIHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(attachmentNameLabel, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(openAttachmentButton);
        toolbar.add(openEditedAttachmentButton);
        toolbar.add(editAttachmentButton);
        toolbar.add(removeAttachmentButton);
    }

    protected void createAttachment() {
        $objectMap.put("attachment", attachment = null);
    }

    protected void createAttachmentNameLabel() {
        $objectMap.put("attachmentNameLabel", attachmentNameLabel = new JLabel());
        
        attachmentNameLabel.setName("attachmentNameLabel");
    }

    protected void createEditAttachmentButton() {
        $objectMap.put("editAttachmentButton", editAttachmentButton = new JButton());
        
        editAttachmentButton.setName("editAttachmentButton");
        editAttachmentButton.setToolTipText(t("faxtomail.attachmentEditor.action.edit.tip"));
        editAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editAttachmentButton"));
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createOpenAttachmentButton() {
        $objectMap.put("openAttachmentButton", openAttachmentButton = new JButton());
        
        openAttachmentButton.setName("openAttachmentButton");
        openAttachmentButton.setToolTipText(t("faxtomail.attachmentEditor.action.open.tip"));
        openAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openAttachmentButton"));
    }

    protected void createOpenEditedAttachmentButton() {
        $objectMap.put("openEditedAttachmentButton", openEditedAttachmentButton = new JButton());
        
        openEditedAttachmentButton.setName("openEditedAttachmentButton");
        openEditedAttachmentButton.setToolTipText(t("faxtomail.attachmentEditor.action.openedited.tip"));
        openEditedAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openEditedAttachmentButton"));
    }

    protected void createRemoveAttachmentButton() {
        $objectMap.put("removeAttachmentButton", removeAttachmentButton = new JButton());
        
        removeAttachmentButton.setName("removeAttachmentButton");
        removeAttachmentButton.setToolTipText(t("faxtomail.attachmentEditor.action.remove.tip"));
        removeAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeAttachmentButton"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentPanel();
        addChildrenToToolbar();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        setBorder( BorderFactory.createEmptyBorder(2, 3, 2, 3) );
        openAttachmentButton.setIcon(SwingUtil.createActionIcon("open-file"));
        openEditedAttachmentButton.setIcon(SwingUtil.createActionIcon("folder_edit"));
        editAttachmentButton.setIcon(SwingUtil.createActionIcon("edit"));
        removeAttachmentButton.setIcon(SwingUtil.createActionIcon("delete"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("attachmentPanel", attachmentPanel);
        createAttachment();
        createHandler();
        createEditable();
        createAttachmentNameLabel();
        createToolbar();
        createOpenAttachmentButton();
        createOpenEditedAttachmentButton();
        createEditAttachmentButton();
        createRemoveAttachmentButton();
        // inline creation of attachmentPanel
        setName("attachmentPanel");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ATTACHMENT_NAME_LABEL_TEXT, true ,"attachment") {
        
            @Override
            public void processDataBinding() {
                if (getAttachment() != null) {
                    attachmentNameLabel.setText(t( attachment != null ? getAttachment().getOriginalFileName() : null ));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OPEN_EDITED_ATTACHMENT_BUTTON_ENABLED, true ,"attachment") {
        
            @Override
            public void processDataBinding() {
                openEditedAttachmentButton.setEnabled( handler != null && handler.isAttachmentEditable(getAttachment()) );
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OPEN_EDITED_ATTACHMENT_BUTTON_VISIBLE, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                openEditedAttachmentButton.setVisible( !isEditable() );
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT_ATTACHMENT_BUTTON_ENABLED, true ,"attachment") {
        
            @Override
            public void processDataBinding() {
                editAttachmentButton.setEnabled( handler != null && handler.isAttachmentEditable(getAttachment()) );
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDIT_ATTACHMENT_BUTTON_VISIBLE, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                editAttachmentButton.setVisible( isEditable() );
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ATTACHMENT_BUTTON_ENABLED, true ,"attachment") {
        
            @Override
            public void processDataBinding() {
                removeAttachmentButton.setEnabled( handler != null && handler.isAttachmentRemovable(getAttachment()) );
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ATTACHMENT_BUTTON_VISIBLE, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                removeAttachmentButton.setVisible( isEditable() );
            }
        });
    }

}