/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.exceptions.AlreadyLockedMailException;
import com.franciaflex.faxtomail.services.service.exceptions.FolderNotReadableException;
import com.franciaflex.faxtomail.ui.swing.FaxToMailScreen;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractChangeScreenAction;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ShowDemandeAction
extends AbstractChangeScreenAction {
    private static final Log log = LogFactory.getLog(ShowDemandeAction.class);
    protected boolean takeEmail;

    public ShowDemandeAction(MainUIHandler handler) {
        super(handler, true, FaxToMailScreen.DEMANDE);
        this.setActionDescription(I18n.t((String)"faxtomail.action.goto.demand.tip", (Object[])new Object[0]));
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        String topiaId = currentEmail.getTopiaId();
        if (StringUtils.isNotBlank((CharSequence)topiaId)) {
            FaxToMailUser currentUser = this.getContext().getCurrentUser();
            int answer = -1;
            try {
                FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
                EmailService emailService = serviceContext.getEmailService();
                Email email = emailService.lockEmail(topiaId, currentUser);
                FaxToMailUser takenBy = email.getTakenBy();
                if (takenBy != null && !currentUser.equals(takenBy)) {
                    String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"faxtomail.alert.alreadyTakenBy.message", (Object[])new Object[]{this.decorate(takenBy)}), I18n.t((String)"faxtomail.alert.alreadyTakenBy.help", (Object[])new Object[0]));
                    answer = JOptionPane.showConfirmDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.alreadyTakenBy.title", (Object[])new Object[0]), 1, 3);
                }
                if (answer == 2) {
                    result = false;
                    emailService.unlockEmail(topiaId);
                } else if (answer == 1) {
                    currentEmail.setEditable(false);
                    this.takeEmail = false;
                } else if (answer == 0) {
                    this.takeEmail = true;
                    currentEmail.setEditable(true);
                }
            }
            catch (AlreadyLockedMailException ex) {
                result = false;
                String htmlMessage = I18n.t((String)"faxtomail.alert.alreadyLockedBy.message", (Object[])new Object[]{this.decorate(ex.getLockedBy())});
                JOptionPane.showMessageDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.alreadyLockedBy.title", (Object[])new Object[0]), 0);
            }
            catch (FolderNotReadableException e) {
                result = false;
                String htmlMessage = I18n.t((String)"faxtomail.alert.userNotAuthorizedToReadEmail.message", (Object[])new Object[]{e.getForbiddenFolder().getName()});
                JOptionPane.showMessageDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.userNotAuthorizedToReadEmail.title", (Object[])new Object[0]), 0);
            }
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        if (StringUtils.isNotBlank((CharSequence)currentEmail.getTopiaId())) {
            FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
            Email email = serviceContext.getEmailService().openEmail(currentEmail.getTopiaId(), this.getContext().getCurrentUser(), this.takeEmail);
            MailFolder currentFolder = currentEmail.getMailFolder();
            MailFolder actualFolder = email.getMailFolder();
            if (currentFolder != null && !currentFolder.equals(actualFolder)) {
                this.displayWarningMessage(I18n.t((String)"faxtomail.alert.emailMoved.title", (Object[])new Object[0]), I18n.t((String)"faxtomail.alert.emailMoved.message", (Object[])new Object[]{currentFolder.getName(), actualFolder.getName(), currentEmail.getTitle()}));
            }
            currentEmail.fromEntity(email);
            MailFolder folder = currentEmail.getMailFolder();
            if (currentEmail.getArchiveDate() != null || !folder.isFolderWritable() || !currentEmail.getDemandStatus().isEditableStatus()) {
                currentEmail.setEditable(false);
            }
        }
        super.doAction();
    }
}

