/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.print;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.print.AttachmentToPrintChooserUI;
import com.franciaflex.faxtomail.ui.swing.content.print.AttachmentToPrintChooserUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.Cancelable;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AttachmentToPrintChooserUIHandler
extends AbstractFaxToMailUIHandler<AttachmentToPrintChooserUIModel, AttachmentToPrintChooserUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(AttachmentToPrintChooserUIHandler.class);

    public void afterInit(AttachmentToPrintChooserUI attachmentToPrintChooserUI) {
        this.initUI(attachmentToPrintChooserUI);
        AttachmentToPrintChooserUIModel model = (AttachmentToPrintChooserUIModel)((Object)this.getModel());
        DemandeUIModel demand = model.getDemand();
        JPanel attachmentPanel = ((AttachmentToPrintChooserUI)this.ui).getAttachmentPanel();
        JCheckBox checkBox = new JCheckBox(I18n.t((String)"faxtomail.chooseMailFolder.element", (Object[])new Object[0]), false);
        attachmentPanel.add(checkBox);
        for (Attachment attachment : demand.getAttachment()) {
            this.createCheckBox(attachment.getOriginalFile());
            AttachmentFile file = attachment.getEditedFile();
            if (file == null) continue;
            this.createCheckBox(file);
        }
    }

    protected void createCheckBox(final AttachmentFile attachmentFile) {
        JCheckBox checkBox = new JCheckBox(attachmentFile.getFilename(), true);
        ((AttachmentToPrintChooserUI)this.ui).getAttachmentPanel().add(checkBox);
        ((AttachmentToPrintChooserUIModel)((Object)this.getModel())).addAttachmentToPrint(attachmentFile);
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                log.info((Object)("state changed " + e.getStateChange()));
                if (e.getStateChange() == 1) {
                    ((AttachmentToPrintChooserUIModel)((Object)AttachmentToPrintChooserUIHandler.this.getModel())).addAttachmentToPrint(attachmentFile);
                } else {
                    ((AttachmentToPrintChooserUIModel)((Object)AttachmentToPrintChooserUIHandler.this.getModel())).removeAttachmentToPrint(attachmentFile);
                }
            }
        });
    }

    public void onCloseUI() {
    }

    public SwingValidator<AttachmentToPrintChooserUIModel> getValidator() {
        return null;
    }

    @Override
    public void cancel() {
        this.closeDialog();
    }

    protected JComponent getComponentToFocus() {
        return ((AttachmentToPrintChooserUI)this.ui).getAttachmentPanel();
    }

    public void print() {
        for (AttachmentFile attachmentFile : ((AttachmentToPrintChooserUIModel)((Object)this.getModel())).getAttachmentsToPrint()) {
            FaxToMailUIUtil.print(attachmentFile, true);
        }
    }
}

