/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande;

import com.ezware.oxbow.swingbits.table.filter.DistinctColumnItem;
import com.ezware.oxbow.swingbits.table.filter.ITableFilter;
import com.ezware.oxbow.swingbits.table.filter.JTableFilter;
import com.ezware.oxbow.swingbits.table.filter.TableRowFilterSupport;
import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryImpl;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.actions.ArchiveFromListAction;
import com.franciaflex.faxtomail.ui.swing.actions.ComputeQuantitiesByRangeAction;
import com.franciaflex.faxtomail.ui.swing.actions.LoadFolderEmailsAction;
import com.franciaflex.faxtomail.ui.swing.actions.SaveDemandeFromListAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailDemandListHandler;
import com.franciaflex.faxtomail.ui.swing.util.CloseableUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.franciaflex.faxtomail.ui.swing.util.FolderTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;

public class DemandeListUIHandler
extends AbstractFaxToMailDemandListHandler<DemandeListUIModel, DemandeListUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(DemandeListUIHandler.class);
    public final PropertyChangeListener selectedDemandeChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("priority".equals(propertyName) && (evt.getNewValue() != null || evt.getOldValue() != null)) {
                SaveDemandeFromListAction saveAction = (SaveDemandeFromListAction)DemandeListUIHandler.this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)DemandeListUIHandler.this, SaveDemandeFromListAction.class);
                saveAction.setModifiedProperties(propertyName);
                DemandeListUIHandler.this.getContext().getActionEngine().runAction((AbstractApplicationAction)saveAction);
            }
        }
    };

    public void beforeInit(DemandeListUI ui) {
        super.beforeInit((ApplicationUI)ui);
        DemandeListUIModel model = new DemandeListUIModel();
        List folders = this.getContext().getMailFolderService().getRootMailFolders();
        model.setFolders(new ArrayList<MailFolder>(folders));
        model.addPropertyChangeListener("selectedFolder", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MailFolder folder = (MailFolder)evt.getNewValue();
                while (folder.getAllowCreateDemandIntoFolder() == null && folder.getParent() != null) {
                    folder = folder.getParent();
                }
                DemandeListUIModel model = (DemandeListUIModel)((Object)DemandeListUIHandler.this.getModel());
                model.setComputeQuantitiesByRangeEnabled(true);
                model.setNewDemandEnabled(folder != null && Boolean.TRUE.equals(folder.getAllowCreateDemandIntoFolder()));
                LoadFolderEmailsAction loadFolderEmailsAction = (LoadFolderEmailsAction)DemandeListUIHandler.this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)DemandeListUIHandler.this, LoadFolderEmailsAction.class);
                DemandeListUIHandler.this.getContext().getActionEngine().runAction((AbstractApplicationAction)loadFolderEmailsAction);
            }
        });
        ((DemandeListUI)this.ui).setContextValue(model);
    }

    public void afterInit(DemandeListUI ui) {
        this.initUI(ui);
        DemandeListUIModel model = (DemandeListUIModel)((Object)this.getModel());
        final JXTable dataTable = ((DemandeListUI)this.getUI()).getDataTable();
        this.initDemandeTable(dataTable, false);
        JTableFilter tableFilter = new JTableFilter((JTable)dataTable){

            protected boolean execute(int col, Collection<DistinctColumnItem> items) {
                boolean b = super.execute(col, items);
                ArrayList<DemandeUIModel> filteredEmails = new ArrayList<DemandeUIModel>();
                AbstractApplicationTableModel dataTableModel = (AbstractApplicationTableModel)dataTable.getModel();
                for (int i = 0; i < dataTable.getRowCount(); ++i) {
                    int modelIndex = dataTable.convertRowIndexToModel(i);
                    filteredEmails.add((DemandeUIModel)dataTableModel.getEntry(modelIndex));
                }
                ((DemandeListUIModel)((Object)DemandeListUIHandler.this.getModel())).setFilteredEmails(filteredEmails);
                return b;
            }

            public void modelChanged(TableModel model) {
            }
        };
        TableRowFilterSupport.forFilter((ITableFilter)tableFilter).searchable(true).useTableRenderers(true).apply();
        dataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                DemandeListUIModel model = (DemandeListUIModel)((Object)DemandeListUIHandler.this.getModel());
                if (source.isSelectionEmpty()) {
                    model.setCurrentEmails(null);
                } else {
                    ArrayList<DemandeUIModel> selectedRows = new ArrayList<DemandeUIModel>();
                    AbstractApplicationTableModel dataTableModel = (AbstractApplicationTableModel)dataTable.getModel();
                    for (int i = source.getMinSelectionIndex(); i <= source.getMaxSelectionIndex(); ++i) {
                        if (!source.isSelectedIndex(i)) continue;
                        selectedRows.add((DemandeUIModel)dataTableModel.getEntry(i));
                    }
                    model.setCurrentEmails(selectedRows);
                }
            }
        });
        model.addPropertyChangeListener("emails", new PropertyChangeListener((ITableFilter)tableFilter){
            final /* synthetic */ ITableFilter val$tableFilter;
            {
                this.val$tableFilter = iTableFilter;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List emails = (List)evt.getNewValue();
                AbstractApplicationTableModel dataTableModel = (AbstractApplicationTableModel)dataTable.getModel();
                dataTableModel.setRows(emails);
                this.val$tableFilter.clear();
            }
        });
        model.addPropertyChangeListener("filteredEmails", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List emails = (List)evt.getNewValue();
                int quotationNb = 0;
                int pfNb = 0;
                int savNb = 0;
                for (DemandeUIModel email : emails) {
                    quotationNb += email.getQuotationNb();
                    pfNb += email.getPfNb();
                    savNb += email.getSavNb();
                }
                DemandeListUIModel model = (DemandeListUIModel)((Object)evt.getSource());
                model.setQuotationNb(quotationNb);
                model.setPfNb(pfNb);
                model.setSavNb(savNb);
            }
        });
        model.addPropertyChangeListener("currentEmails", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List newDemands;
                List oldDemands = (List)evt.getOldValue();
                if (oldDemands != null) {
                    for (DemandeUIModel demand : oldDemands) {
                        demand.removePropertyChangeListener(DemandeListUIHandler.this.selectedDemandeChangeListener);
                    }
                }
                if ((newDemands = (List)evt.getNewValue()) != null) {
                    for (DemandeUIModel demand : newDemands) {
                        demand.addPropertyChangeListener(DemandeListUIHandler.this.selectedDemandeChangeListener);
                    }
                }
            }
        });
        Map<MailFolder, DefaultMutableTreeNode> nodesByFolder = FaxToMailUIUtil.initFolderTree(this.getContext(), ui.getNavigationTree(), model.getFolders());
        ui.getNavigationTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AbstractApplicationTableModel dataTableModel;
                int row;
                FolderTreeNode folderNode = (FolderTreeNode)e.getPath().getLastPathComponent();
                MailFolder folder = folderNode.getMailFolder();
                ((DemandeListUIModel)((Object)DemandeListUIHandler.this.getModel())).setSelectedFolder(folder);
                DemandeListUIHandler.this.getContext().setCurrentMailFolder(folder);
                DemandeUIModel currentEmail = DemandeListUIHandler.this.getContext().getCurrentEmail();
                if (currentEmail != null && (row = (dataTableModel = (AbstractApplicationTableModel)dataTable.getModel()).getRowIndex((Serializable)currentEmail)) > 0) {
                    dataTable.setRowSelectionInterval(row, row);
                }
            }
        });
        MailFolder currentMailFolder = this.getContext().getCurrentMailFolder();
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        if (currentMailFolder == null && currentEmail != null) {
            currentMailFolder = currentEmail.getMailFolder();
        }
        if (currentMailFolder != null) {
            DefaultMutableTreeNode node = nodesByFolder.get(currentMailFolder);
            ui.getNavigationTree().setSelectionPath(new TreePath(node.getPath()));
        }
    }

    @Override
    public void initDemandeTable(final JXTable table, boolean sortable) {
        super.initDemandeTable(table, sortable);
        HighlightPredicate testPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int viewRow = adapter.row;
                int modelRow = adapter.convertRowIndexToModel(viewRow);
                DemandeUIModel row = (DemandeUIModel)((AbstractApplicationTableModel)table.getModel()).getEntry(modelRow);
                MailFolder folder = ((DemandeListUIModel)((Object)DemandeListUIHandler.this.getModel())).getSelectedFolder();
                while (folder.getOpenAttachmentReportNoTaken() == null && folder.getParent() != null) {
                    folder = folder.getParent();
                }
                return Boolean.TRUE.equals(folder.getOpenAttachmentReportNoTaken()) && row.getLastAttachmentOpeningInThisFolderUser() != null && !row.getLastAttachmentOpeningInThisFolderUser().equals(row.getTakenBy());
            }
        };
        Color color = Color.ORANGE;
        table.addHighlighter((Highlighter)new ColorHighlighter(testPredicate, color, Color.WHITE, color.darker(), Color.WHITE));
    }

    @Override
    protected List<MailField> getColumns() {
        List tableColumns = null;
        MailFolder selectedFolder = ((DemandeListUIModel)((Object)this.getModel())).getSelectedFolder();
        if (selectedFolder != null) {
            tableColumns = selectedFolder.getFolderTableColumns();
        }
        return tableColumns;
    }

    @Override
    protected MailField[] getEditableTableProperties() {
        return new MailField[]{MailField.PRIORITY, MailField.ATTACHMENT, MailField.REPLIES};
    }

    @Override
    protected void onDoubleClickOnDemande(DemandeUIModel selectedEmail) {
        super.onDoubleClickOnDemande(selectedEmail);
        selectedEmail.removePropertyChangeListener(this.selectedDemandeChangeListener);
    }

    protected JComponent getComponentToFocus() {
        return ((DemandeListUI)this.getUI()).getNavigationTree();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        JTree tree = ((DemandeListUI)this.getUI()).getNavigationTree();
        TreeModel treeModel = tree.getModel();
        Enumeration<TreePath> paths = tree.getExpandedDescendants(new TreePath(treeModel.getRoot()));
        ArrayList<MailFolder> folders = new ArrayList<MailFolder>();
        while (paths.hasMoreElements()) {
            TreePath path = paths.nextElement();
            Object lastPathComponent = path.getLastPathComponent();
            if (!FolderTreeNode.class.isAssignableFrom(lastPathComponent.getClass())) continue;
            folders.add(((FolderTreeNode)lastPathComponent).getMailFolder());
        }
        this.getContext().setExpandedFolders(folders);
        this.clearValidators();
    }

    @Override
    public boolean quitUI() {
        return true;
    }

    public SwingValidator<DemandeListUIModel> getValidator() {
        return null;
    }

    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        int selectedRowCount = ((DemandeListUI)this.getUI()).getDataTable().getSelectedRowCount();
        DemandeListUIModel model = (DemandeListUIModel)((Object)this.getModel());
        model.setReplyEnabled(selectedRowCount == 1 && model.getCurrentEmails().get(0).isEditable());
        model.setArchiveEnabled(selectedRowCount > 1 || selectedRowCount > 0 && model.getCurrentEmails().get(0).isEditable());
    }

    public void autoSelectNodeInTree(MouseEvent e, JPopupMenu popup) {
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick) {
            JTree source = (JTree)e.getSource();
            int rowIndex = source.getClosestRowForLocation(e.getX(), e.getY());
            if (log.isDebugEnabled()) {
                log.debug((Object)("At point [" + e.getPoint() + "] found Row " + rowIndex));
            }
            if (rowIndex == -1) {
                source.clearSelection();
            } else {
                source.setSelectionRow(rowIndex);
            }
            popup.show(source, e.getX(), e.getY());
        }
    }

    public void computeQuantitiesByRange() {
        QuantitiesByRangeUI dialogContent = new QuantitiesByRangeUI((FaxToMailUI)this.ui);
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)new ComputeQuantitiesByRangeAction(dialogContent.getHandler()));
    }

    public void newDemand() {
        FaxToMailUser currentUser = this.getContext().getCurrentUser();
        Date now = new Date();
        ArrayList<History> histories = new ArrayList<History>();
        DemandeUIModel email = new DemandeUIModel();
        HistoryImpl history = new HistoryImpl();
        history.setFaxToMailUser(currentUser);
        history.setType(HistoryType.CREATION);
        history.setModificationDate(now);
        histories.add((History)history);
        history = new HistoryImpl();
        history.setFaxToMailUser(currentUser);
        history.setType(HistoryType.OPENING);
        history.setModificationDate(now);
        histories.add((History)history);
        email.setMailFolder(((DemandeListUIModel)((Object)this.getModel())).getSelectedFolder());
        email.setReceptionDate(now);
        email.setTakenBy(currentUser);
        email.setHistory(histories);
        email.setDemandStatus(DemandStatus.UNTREATED);
        this.openDemand(email);
    }

    public void print() {
        List<DemandeUIModel> currentEmails = ((DemandeListUIModel)((Object)this.getModel())).getCurrentEmails();
        for (DemandeUIModel demandeUIModel : currentEmails) {
            for (Attachment attachment : demandeUIModel.getAttachment()) {
                AttachmentFile attachmentFile = attachment.getEditedFile();
                if (attachmentFile == null) {
                    attachmentFile = attachment.getOriginalFile();
                }
                FaxToMailUIUtil.print(attachmentFile, true);
            }
        }
    }

    public void reply() {
        DemandeUIModel demand = ((DemandeListUIModel)((Object)this.getModel())).getCurrentEmails().get(0);
        this.getContext().setCurrentEmail(demand);
        ReplyFormUI dialogContent = new ReplyFormUI((FaxToMailUI)this.ui);
        ReplyFormUIModel model = dialogContent.getModel();
        model.setTo(demand.getSender());
        this.openFrame(dialogContent, I18n.t((String)"faxtomail.reply.title", (Object[])new Object[]{demand.getObject()}), new Dimension(800, 600));
    }

    public void archive() {
        ArchiveFromListAction saveAction = (ArchiveFromListAction)this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)this, ArchiveFromListAction.class);
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)saveAction);
    }
}

