package com.franciaflex.faxtomail.ui.swing.util;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import org.apache.commons.logging.LogFactory;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since x.x
 */
public class FolderTreeNode extends DefaultMutableTreeNode {

    protected boolean canSelect;

    public FolderTreeNode(MailFolder folder) {
        super(folder);
    }

    public MailFolder getMailFolder() {
        return (MailFolder) userObject;
    }

    public boolean isCanSelect() {
        return canSelect;
    }

    public void setCanSelect(boolean canSelect) {
        this.canSelect = canSelect;
    }

    @Override
    public String toString() {
        MailFolder folder = (MailFolder) userObject;
        return folder.getName();
    }
}
