package com.franciaflex.faxtomail.ui.swing.content.demande.replies;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class DemandReplyItem extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_REPLY = "reply";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REPLY_DATE_LABEL_TEXT = "replyDateLabel.text";
    public static final String BINDING_REPLY_SUBJECT_LABEL_TEXT = "replySubjectLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1US48TRxAum7WNvQECSwgRRJosEtmFpS0Rbot4LJsVuzLh4UVC+EJ7pr3bqD3TdNfAWIiIn5CfEO5ckHLjhHLgzCEXxF+Iohy4Iqp7/FhjI/aAJbfH1VVffVXzVT3/F0rWwE/3eZYxk8You4JtXL5z53r7vghxVdjQSI2JgfxTKEKxBbPR0G4RTrQaLrzeD69fSbo6iUW8I3q5ATWLPSXsthCI8ON4RGhtvTm8Xs50agaoQ1LTUP/8/7/iH9HTZ0WATBO7CpUSfClqVMlMA4oyQjhEmR7yuuLxFtEwMt4ivvuc7Yri1v7Gu+IB/A6VBpQ1NwSGML/7kj2Gj880Qs0IrXo3eCwUwkaYdFnH8DiUvKNExjo8w6TLpWKpZPYRMWFhEiMBs0h0eRwJ5uKlsGzV/7/l0NZRdLX2OcoIJZ8B4dznwbUwVlqCDQUjbIkO0EONYCrbBK+EQbj5VVjSv9vrV3PMUZb9nuwqR9HgbdeSQ67tWR91wxuda3UYcdBHNFOvz+H94XGnCiaJanMif3gMb5PMK9yMOx9ItIh99SspIhUCc2NBudU5f69JYMfGBEbSZSPpjrRVaNGLSMmMcLQ1qfZbdJXr/OgnOneA/vbDkbl/Xr77a20g7jLl/m6q647ZJNFpQ/UY90qptFzZKUpVv8b1cguqVihqnB/c41OINfvXRI7yHXThzIWzq9xuE0Sp8vbV30fuvdkDxTWoqYRHa9z5r0MVtw11IVFRpi9e8oy+ebSXzm8dN4RyOzGR01P9cbDiH/PIHguNIAH82tXYyy8Wzi4FvywF7lwMnmTUpeNTujSk2q6+fj/XfHFp0KkCMf/hs+6jbpXuQlnGSsbCL4L+jE8d/FltRRolo1meNt0wNt66r/J5f56caEkRYQZFRstk+XGwJbA/GwuLNERhYqgjC2T1uiQbPTbdfnHmxcXgdDAfnKHvE0rZIcme8WSoyRK5kmGWupynfC/c0xJMjNqX6BWG9I55ejuJ5MO34N/NZKLJCd1FK6od0hLytiui1OHK0u++XDE3uKTlEg3s01IO5n0XiWokOpnE625jwYwbfYRZF74p9aav9+fRfot2ri+WRzIXw1DqaUQ+3SW76HJZ8V5CzrD/fEQdCNoyjmjvXJiAL7izRogfAdIZXHC1BwAA";
    private static final Log log = LogFactory.getLog(DemandReplyItem.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemandRepliesUIHandler handler;
    protected JButton openReplyButton;
    protected Reply reply;
    protected JLabel replyDateLabel;
    protected DemandReplyItem replyPanel = this;
    protected JLabel replySubjectLabel;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandReplyItem(DemandRepliesUIHandler handler) {
        setContextValue(handler);
            $initialize();
    }

    public DemandReplyItem(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandReplyItem(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandReplyItem() {
        $initialize();
    }

    public DemandReplyItem(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandReplyItem(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemandReplyItem(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandReplyItem(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemandReplyItem(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__openReplyButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openReply(reply);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandRepliesUIHandler getHandler() {
        return handler;
    }

    public JButton getOpenReplyButton() {
        return openReplyButton;
    }

    public Reply getReply() {
        return reply;
    }

    public JLabel getReplyDateLabel() {
        return replyDateLabel;
    }

    public JLabel getReplySubjectLabel() {
        return replySubjectLabel;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setReply(Reply reply) {
        Reply oldValue = this.reply;
        this.reply = reply;
        firePropertyChange(PROPERTY_REPLY, oldValue, reply);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToReplyPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(replyDateLabel, BorderLayout.WEST);
        add(replySubjectLabel, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(openReplyButton);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DemandRepliesUIHandler.class));
    }

    protected void createOpenReplyButton() {
        $objectMap.put("openReplyButton", openReplyButton = new JButton());
        
        openReplyButton.setName("openReplyButton");
        openReplyButton.setToolTipText(t("faxtomail.demandReplies.action.open.tip"));
        openReplyButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openReplyButton"));
    }

    protected void createReply() {
        $objectMap.put("reply", reply = null);
    }

    protected void createReplyDateLabel() {
        $objectMap.put("replyDateLabel", replyDateLabel = new JLabel());
        
        replyDateLabel.setName("replyDateLabel");
        if (replyDateLabel.getFont() != null) {
            replyDateLabel.setFont(replyDateLabel.getFont().deriveFont(replyDateLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createReplySubjectLabel() {
        $objectMap.put("replySubjectLabel", replySubjectLabel = new JLabel());
        
        replySubjectLabel.setName("replySubjectLabel");
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplyPanel();
        addChildrenToToolbar();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setBorder( BorderFactory.createEmptyBorder(2, 3, 2, 3) );
        openReplyButton.setIcon(SwingUtil.createActionIcon("open"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("replyPanel", replyPanel);
        createReply();
        createHandler();
        createReplyDateLabel();
        createReplySubjectLabel();
        createToolbar();
        createOpenReplyButton();
        // inline creation of replyPanel
        setName("replyPanel");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLY_DATE_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("reply", this);
                if (getReply() != null) {
                    getReply().addPropertyChangeListener("sentDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getReply() != null) {
                    replyDateLabel.setText(t( getHandler().decorate(getReply().getSentDate()) + " - " ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("reply", this);
                if (getReply() != null) {
                    getReply().removePropertyChangeListener("sentDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLY_SUBJECT_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("reply", this);
                if (getReply() != null) {
                    getReply().addPropertyChangeListener("subject", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getReply() != null) {
                    replySubjectLabel.setText(t( getReply().getSubject() ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("reply", this);
                if (getReply() != null) {
                    getReply().removePropertyChangeListener("subject", this);
                }
            }
        });
    }

}