package com.franciaflex.faxtomail.ui.swing.content.demande.history;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupUI;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class HistoryListUI extends AbstractToolbarPopupUI<com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel, HistoryListUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1TwU4UQRAtRhZc0CAQEQUS0RhvvR/AQRBCgCxqXEmIe7F3pne3sWe67a6V4WL8BD9B715MvHkyHjx78GL8BWM8eDVWzw47i47ROIeeyVS9V6+qX738AhVnYfmApymzvQRlLNjO2v7+7daBCHFDuNBKg9pC/xkJIGjCZDT47xCuNuseXsvhtXUdG52IZAi9UocJh0dKuK4QiLB0EhE6V2sMwiup6dlj1oGoMtbn374Gz6KnLwKA1JA638rlv6GKTkbrEMgIYYYqPeY1xZMOybAy6ZDes/7fuuLO3eKxeARPYLwOY4ZbIkO48u8tZxwZPjUI013pKHpUp9eG5Ep3ELZCHbO25UkoeVuJlLV5ijrmUrGeZO6QBLFQJ0j8LBIxTyLBchq2VdDtbRuTFRpDqMQ6Egph7T+oN/rvve1dz1FwjrZ0dISwrG2HHZADHqI2fYqU7ezfk6hEdIcnw5B5jsjDbkz0NwncCK1WyucgXPDzTXMJO0XEI6cGBNV+n1KQzy6VF/at++wZQ7e/cOL2yVes8FVx8SNNqNie8qTzzd+teJdCfRPO/2JCT5hFf8zNfnzz+fXmsfMCqn2+NHVoccgRxmojLGb9TPVt10OparvcrDSh6oSircu2arFEWCMPkziqN+3hzMPZFnddoqiMf3r7bu7Bh1MQbMKE0jza5D5/G6rYtTQFraLU3FjNFJ05PE3nOa+N/IL++hAWCn8MGZVl0ZQGslgykIGqVvX999nGq9XjoYyQyIt/TC8GU7kPYzJRMhHZQua7VrqAk8aJXqSLnSrbMsi9anIjLmXnclnf4yLhLfItTaDNlaMefeq1TLz/ug7DHiTCn6xAINoxBQAA";
    private static final Log log = LogFactory.getLog(HistoryListUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane attachmentBodyScrollPane;
    protected final HistoryListUIHandler handler = new HistoryListUIHandler();
    protected JXList histories;
    protected HistoryListUI historyListDialog = this;
    protected DemandeUIModel model;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HistoryListUI(FaxToMailUIContext param0) {
        super(param0);
        $initialize();
    }

    public HistoryListUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI() {
        $initialize();
    }

    public HistoryListUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public HistoryListUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public HistoryListUI(Window param0) {
        super(param0);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public HistoryListUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public HistoryListUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HistoryListUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryListUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JScrollPane getAttachmentBodyScrollPane() {
        return attachmentBodyScrollPane;
    }

    public HistoryListUIHandler getHandler() {
        return handler;
    }

    public JXList getHistories() {
        return histories;
    }

    public DemandeUIModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentBodyScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentBodyScrollPane.getViewport().add(histories);
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(attachmentBodyScrollPane);
    }

    protected void createAttachmentBodyScrollPane() {
        $objectMap.put("attachmentBodyScrollPane", attachmentBodyScrollPane = new JScrollPane());
        
        attachmentBodyScrollPane.setName("attachmentBodyScrollPane");
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
        body.setTitle(t("faxtomail.historyList.title"));
    }

    protected void createHistories() {
        $objectMap.put("histories", histories = new JXList());
        
        histories.setName("histories");
        histories.setEnabled(false);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DemandeUIModel.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToAttachmentBodyScrollPane();
        // late initializer
        historyListDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("historyListDialog", historyListDialog);
        createModel();
        createAttachmentBodyScrollPane();
        createHistories();
        // inline creation of historyListDialog
        setName("historyListDialog");
        
        $completeSetup();
        handler.afterInit(this);
    }

}