package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class DemandesUIModel extends AbstractBean {

    private static final Log log = LogFactory.getLog(DemandesUIModel.class);

    public static final String PROPERTY_CURRENT_DEMAND = "currentDemand";
    public static final String PROPERTY_TRANSMIT_ENABLED = "transmitEnabled";

    protected boolean transmitEnabled;

    protected List<DemandeUIModel> demands = new ArrayList<DemandeUIModel>();

    protected List<DemandsListener> listeners = new ArrayList<DemandsListener>();

    protected int currentIndex = -1;

    public boolean isTransmitEnabled() {
        return transmitEnabled;
    }

    public void setTransmitEnabled(boolean transmitEnabled) {
        Object oldValue = isTransmitEnabled();
        this.transmitEnabled = transmitEnabled;
        firePropertyChange(PROPERTY_TRANSMIT_ENABLED,oldValue, transmitEnabled);
    }

    protected List<DemandeUIModel> getDemands() {
        return demands;
    }

    public void addDemand(DemandeUIModel demand) {
        boolean added = !demands.contains(demand);
        if (added) {
            demands.add(demand);
        }
        int index = demands.indexOf(demand);
        fireDemandAdded(demand, index, added);
    }

    public void removeDemand(int i) {
        DemandeUIModel demand = demands.get(i);
        demands.remove(i);
        fireDemandRemoved(demand, i);
    }

    public void addDemandsListener(DemandsListener listener) {
        listeners.add(listener);
    }

    public void removeDemandsListener(DemandsListener listener) {
        listeners.remove(listener);
    }

    protected void fireDemandAdded(DemandeUIModel demand, int index, boolean added) {
        for (DemandsListener listener : listeners) {
            listener.onDemandAdded(demand, index, added);
        }
    }

    protected void fireDemandRemoved(DemandeUIModel demand, int index) {
        for (DemandsListener listener : listeners) {
            listener.onDemandRemoved(demand, index);
        }
    }

    public static interface DemandsListener {

        void onDemandAdded(DemandeUIModel demand, int index, boolean added);

        void onDemandRemoved(DemandeUIModel demand, int index);

    }

    public DemandeUIModel getCurrentDemand() {
        int currentIndex = getCurrentIndex();
        if (currentIndex < 0 || currentIndex >= demands.size()) {
            return null;
        }
        return demands.get(currentIndex);
    }

    public int getCurrentIndex() {
        return currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        Object oldValue = getCurrentDemand();
        this.currentIndex = currentIndex;
        Object newValue = getCurrentDemand();
        firePropertyChange(PROPERTY_CURRENT_DEMAND, oldValue, newValue);
    }
}
