package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import org.jdesktop.beans.AbstractSerializableBean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since x.x
 */
public class DemandeListUIModel extends AbstractSerializableBean {

    public static final String PROPERTY_FOLDERS = "folders";
    public static final String PROPERTY_EMAILS = "emails";
    public static final String PROPERTY_FILTERED_EMAILS = "filteredEmails";
    public static final String PROPERTY_CURRENT_EMAILS = "currentEmails";
    public static final String PROPERTY_EMAIL_NB = "emailNb";
    public static final String PROPERTY_SELECTED_FOLDER = "selectedFolder";
    public static final String PROPERTY_QUOTATION_NB = "quotationNb";
    public static final String PROPERTY_PF_NB = "pfNb";
    public static final String PROPERTY_SAV_NB = "savNb";
    public static final String PROPERTY_REPLY_ENABLED = "replyEnabled";
    public static final String PROPERTY_ARCHIVE_ENABLED = "archiveEnabled";
    public static final String PROPERTY_COMPUTE_QUANTITIES_BY_RANGE_ENABLED = "computeQuantitiesByRangeEnabled";
    public static final String PROPERTY_NEW_DEMAND_ENABLED = "newDemandEnabled";

    protected List<MailFolder> folders;

    protected List<DemandeUIModel> emails;

    protected List<DemandeUIModel> filteredEmails;

    protected List<DemandeUIModel> currentEmails;

    protected MailFolder selectedFolder;

    protected boolean replyEnabled;

    protected boolean archiveEnabled;

    protected boolean computeQuantitiesByRangeEnabled;

    protected boolean newDemandEnabled;

    protected int quotationNb;

    protected int pfNb;

    protected int savNb;

    public List<MailFolder> getFolders() {
        return folders;
    }

    public void setFolders(List<MailFolder> folders) {
        Object oldValue = getFolders();
        this.folders = folders;
        firePropertyChange(PROPERTY_FOLDERS, oldValue, folders);
    }

    public List<DemandeUIModel> getEmails() {
        return emails;
    }

    public void setEmails(List<DemandeUIModel> emails) {
        this.emails = emails;
        setFilteredEmails(emails);
        firePropertyChange(PROPERTY_EMAILS, null, emails);
    }

    public List<DemandeUIModel> getFilteredEmails() {
        return filteredEmails;
    }

    public void setFilteredEmails(List<DemandeUIModel> filteredEmails) {
        Object oldValue = getEmailNb();
        this.filteredEmails = filteredEmails;
        Object newValue = getEmailNb();
        firePropertyChange(PROPERTY_FILTERED_EMAILS, null, this.filteredEmails);
        firePropertyChange(PROPERTY_EMAIL_NB, oldValue, newValue);
    }

    public List<DemandeUIModel> getCurrentEmails() {
        return currentEmails;
    }

    public void setCurrentEmails(List<DemandeUIModel> currentEmails) {
        Object oldValue = getCurrentEmails();
        this.currentEmails = currentEmails;
        firePropertyChange(PROPERTY_CURRENT_EMAILS, oldValue, currentEmails);
    }

    public int getEmailNb() {
        return filteredEmails == null ? 0 : filteredEmails.size();
    }

    public void addEmail(DemandeUIModel email) {
        if (emails == null) {
            emails = new ArrayList<DemandeUIModel>();
        }
        Object oldValue = getEmailNb();
        emails.add(email);
        Object newValue = getEmailNb();
        firePropertyChange(PROPERTY_EMAILS, null, emails);
        firePropertyChange(PROPERTY_EMAIL_NB, oldValue, newValue);
    }

    public void removeEmails(List<DemandeUIModel> emails) {
        if (emails != null) {
            Object oldValue = getEmailNb();
            this.emails.removeAll(emails);
            this.filteredEmails.removeAll(emails);
            Object newValue = getEmailNb();
            firePropertyChange(PROPERTY_EMAILS, null, this.emails);
            firePropertyChange(PROPERTY_FILTERED_EMAILS, null, this.filteredEmails);
            firePropertyChange(PROPERTY_EMAIL_NB, oldValue, newValue);
        }
    }

    public MailFolder getSelectedFolder() {
        return selectedFolder;
    }

    public void setSelectedFolder(MailFolder selectedFolder) {
        Object oldValue = getSelectedFolder();
        this.selectedFolder = selectedFolder;
        firePropertyChange(PROPERTY_SELECTED_FOLDER, oldValue, selectedFolder);
    }

    public boolean isReplyEnabled() {
        return replyEnabled;
    }

    public void setReplyEnabled(boolean replyEnabled) {
        Object oldValue = isReplyEnabled();
        this.replyEnabled = replyEnabled;
        firePropertyChange(PROPERTY_REPLY_ENABLED, oldValue, replyEnabled);
    }

    public boolean isArchiveEnabled() {
        return archiveEnabled;
    }

    public void setArchiveEnabled(boolean archiveEnabled) {
        Object oldValue = isArchiveEnabled();
        this.archiveEnabled = archiveEnabled;
        firePropertyChange(PROPERTY_ARCHIVE_ENABLED, oldValue, archiveEnabled);
    }

    public boolean isComputeQuantitiesByRangeEnabled() {
        return computeQuantitiesByRangeEnabled;
    }

    public void setComputeQuantitiesByRangeEnabled(boolean computeQuantitiesByRangeEnabled) {
        Object oldValue = isComputeQuantitiesByRangeEnabled();
        this.computeQuantitiesByRangeEnabled = computeQuantitiesByRangeEnabled;
        firePropertyChange(PROPERTY_COMPUTE_QUANTITIES_BY_RANGE_ENABLED, oldValue, computeQuantitiesByRangeEnabled);
    }

    public boolean isNewDemandEnabled() {
        return newDemandEnabled;
    }

    public void setNewDemandEnabled(boolean newDemandEnabled) {
        Object oldValue = isNewDemandEnabled();
        this.newDemandEnabled = newDemandEnabled;
        firePropertyChange(PROPERTY_NEW_DEMAND_ENABLED, oldValue, newDemandEnabled);
    }

    public int getQuotationNb() {
        return quotationNb;
    }

    public void setQuotationNb(int quotationNb) {
        Object oldValue = getPfNb();
        this.quotationNb = quotationNb;
        firePropertyChange(PROPERTY_QUOTATION_NB, oldValue, quotationNb);
    }

    public int getPfNb() {
        return pfNb;
    }

    public void setPfNb(int pfNb) {
        Object oldValue = getPfNb();
        this.pfNb = pfNb;
        firePropertyChange(PROPERTY_PF_NB, oldValue, pfNb);
    }

    public int getSavNb() {
        return savNb;
    }

    public void setSavNb(int savNb) {
        Object oldValue = getSavNb();
        this.savNb = savNb;
        firePropertyChange(PROPERTY_SAV_NB, oldValue, savNb);
    }
}
