package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: ComputeQuantitiesByRangeAction.java 185 2014-06-11 05:32:51Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/actions/ComputeQuantitiesByRangeAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.RangeRowImpl;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.QuantitiesByRangeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.*;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class ComputeQuantitiesByRangeAction extends AbstractFaxToMailAction<QuantitiesByRangeUIModel, QuantitiesByRangeUI, QuantitiesByRangeUIHandler> {

    private static final Log log = LogFactory.getLog(ComputeQuantitiesByRangeAction.class);

    public ComputeQuantitiesByRangeAction(QuantitiesByRangeUIHandler handler) {
        super(handler, false);
        setActionDescription(t("faxtomail.action.computeQuantitiesByRange.tip"));
    }

    @Override
    public void doAction() throws Exception {
        Map<Range, RangeRowModel> quantitiesByRange = new HashMap<Range, RangeRowModel>();
        MailFolder folder = getModel().getRootFolder();
        List<Email> emails = getContext().getEmailService().getEmailForFolderAndSubfolders(folder);

        for (Email email : emails) {
            Collection<RangeRow> rangeRows = email.getRangeRow();
            if (rangeRows != null) {
                for (RangeRow rangeRow : rangeRows) {
                    Range range = rangeRow.getRange();
                    RangeRowModel row = quantitiesByRange.get(range);
                    if (row == null) {
                        row = new RangeRowModel();
                        row.fromEntity(rangeRow);
                        quantitiesByRange.put(range, row);

                    } else {
                        Integer productQuantity = rangeRow.getProductQuantity();
                        if (productQuantity != null) {
                            row.setProductQuantity(row.getProductQuantity() + productQuantity);
                        }

                        Integer savQuantity = rangeRow.getSavQuantity();
                        if (savQuantity != null) {
                            row.setSavQuantity(row.getSavQuantity() + savQuantity);
                        }

                        Integer quotationQuantity = rangeRow.getQuotationQuantity();
                        if (quotationQuantity != null) {
                            row.setQuotationQuantity(row.getQuotationQuantity() + quotationQuantity);
                        }
                    }

                }
            }
        }
        getModel().setRangeRows(quantitiesByRange.values());
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        handler.openDialog(getUI(), t("faxtomail.quantitiesByRange.title"), new Dimension(350, 300));
    }
}