package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: ArchiveAction.java 86 2014-05-21 19:30:41Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/actions/ArchiveAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

import javax.swing.*;

import java.util.Date;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class ArchiveAction extends SaveDemandeAndExitAction {

    public ArchiveAction(DemandeUIHandler handler) {
        super(handler);
        setActionDescription(t("faxtomail.action.archive.tip"));
    }

    @Override
    public boolean prepareAction() throws Exception {
        int i = JOptionPane.showConfirmDialog(
                null,
                t("faxtomail.alert.archiveConfirmation.message"),
                t("faxtomail.alert.archiveConfirmation.title"),
                JOptionPane.YES_NO_OPTION,
                JOptionPane.QUESTION_MESSAGE);

        boolean result = i == JOptionPane.YES_OPTION;
        return result;
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel model = getModel();
        model.setArchiveDate(new Date());
        model.setDemandStatus(DemandStatus.ARCHIVED);
        model.setTakenBy(null);
        super.doAction();
    }
}
