/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.util;

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HasLabel;
import com.franciaflex.faxtomail.services.DecoratorService;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;
import com.franciaflex.faxtomail.ui.swing.util.CheckBoxComboBoxModel;
import com.franciaflex.faxtomail.ui.swing.util.CheckBoxListCellRenderer;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.UIMessageNotifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationDataUtil;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.util.Cancelable;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public abstract class AbstractFaxToMailUIHandler<M, UI extends FaxToMailUI<M, ?>>
extends AbstractApplicationUIHandler<M, UI>
implements UIMessageNotifier {
    private static final Log log = LogFactory.getLog(AbstractFaxToMailUIHandler.class);

    @Override
    public void showInformationMessage(String message) {
        this.getContext().showInformationMessage(message);
    }

    public FaxToMailUIContext getContext() {
        return (FaxToMailUIContext)super.getContext();
    }

    public FaxToMailConfiguration getConfig() {
        return this.getContext().getConfig();
    }

    public Component getTopestUI() {
        ApplicationActionUI actionUI;
        ApplicationActionUI result = actionUI = this.getContext().getActionUI();
        return result;
    }

    public void clearValidators() {
        MainUI main = this.getContext().getMainUI();
        Preconditions.checkNotNull((Object)main, (Object)"No mainUI registred in application context");
        MainUIHandler handler = main.getHandler();
        handler.clearValidators();
    }

    public <O> Decorator<O> getDecorator(Class<O> type, String name) {
        DecoratorService decoratorService = this.getContext().getDecoratorService();
        Preconditions.checkNotNull(type);
        Decorator decorator = decoratorService.getDecoratorByType(type, name);
        Preconditions.checkNotNull((Object)decorator);
        return decorator;
    }

    public String decorate(Serializable s) {
        return super.decorate(s);
    }

    public String decorateUser(FaxToMailUser user, boolean systemIfNull) {
        if (user == null && systemIfNull) {
            return I18n.t((String)"faxtomail.systemUser", (Object[])new Object[0]);
        }
        return this.decorate((Serializable)user);
    }

    public void setText(ItemEvent e, String property) {
        String value = JAXXUtil.getStringValue((Object)e.getItem());
        ApplicationDataUtil.setProperty((Object)this.getModel(), (String)property, (Object)value);
    }

    public void setText(KeyEvent event, String property) {
        JTextComponent field = (JTextComponent)event.getSource();
        if (field.isEditable()) {
            super.setText(event, property);
        }
    }

    protected void registerValidators(SwingValidator ... validators) {
        MainUI main = this.getContext().getMainUI();
        Preconditions.checkNotNull((Object)main, (Object)"No mainUI registred in application context");
        MainUIHandler handler = main.getHandler();
        handler.clearValidators();
        for (SwingValidator validator : validators) {
            handler.registerValidator(validator);
        }
    }

    protected void listenValidatorValid(SimpleBeanValidator validator, final AbstractFaxToMailBeanUIModel model) {
        validator.addPropertyChangeListener("valid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Model [" + (Object)((Object)model) + "] pass to valid state [" + evt.getNewValue() + "]"));
                }
                model.setValid((Boolean)evt.getNewValue());
            }
        });
    }

    protected void listenValidationTableHasNoFatalError(final SimpleBeanValidator validator, final AbstractFaxToMailBeanUIModel model) {
        this.getContext().getMainUI().getValidatorMessageWidget().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean valid;
                boolean bl = valid = !validator.hasFatalErrors();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Model [" + (Object)((Object)model) + "] pass to valid state [" + valid + "]"));
                }
                model.setValid(valid);
            }
        });
    }

    protected void listModelIsModify(AbstractFaxToMailBeanUIModel model) {
        model.addPropertyChangeListener(new PropertyChangeListener(){
            final Set<String> excludeProperties;
            {
                this.excludeProperties = AbstractFaxToMailUIHandler.this.getPropertiesToIgnore();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                Object oldValue = evt.getOldValue();
                if (!this.excludeProperties.contains(evt.getPropertyName()) && newValue != oldValue) {
                    ((AbstractFaxToMailBeanUIModel)((Object)evt.getSource())).setModify(true);
                }
            }
        });
    }

    protected Set<String> getPropertiesToIgnore() {
        return Sets.newHashSet((Object[])new String[]{"modify", "valid"});
    }

    public void openFrame(ApplicationUI dialogContent, String title, Dimension dim) {
        JFrame result = this.getContext().getSecondaryFrame();
        if (result == null) {
            result = new JFrame();
            result.setResizable(true);
            this.getContext().setSecondaryFrame(result);
        }
        result.setTitle(title);
        result.setContentPane((Container)dialogContent);
        result.setSize(dim);
        final AbstractApplicationUIHandler handler = dialogContent.getHandler();
        if (handler instanceof Cancelable) {
            JRootPane rootPane = result.getRootPane();
            KeyStroke shortcutClosePopup = this.getContext().getConfiguration().getShortcutClosePopup();
            rootPane.getInputMap(2).put(shortcutClosePopup, "close");
            rootPane.getActionMap().put("close", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Cancelable)handler).cancel();
                }
            });
        }
        SwingUtil.center((Component)this.getContext().getMainUI(), (Component)result);
        result.setVisible(true);
    }

    public void closeFrame() {
        ((JFrame)this.getParentContainer(JFrame.class)).setVisible(false);
    }

    protected <HL extends HasLabel> void initCheckBoxComboBox(final JComboBox comboBox, List<HL> values, List<HL> selection, String property, boolean addNull) {
        ArrayList<HL> universe = new ArrayList<HL>();
        if (addNull) {
            universe.add(null);
        }
        if (values != null) {
            universe.addAll(values);
        }
        final CheckBoxComboBoxModel comboModel = new CheckBoxComboBoxModel(universe, selection);
        comboBox.setModel(comboModel);
        comboBox.setRenderer(new CheckBoxListCellRenderer(){

            @Override
            protected boolean isCheckBoxSelected(Object value) {
                return ((List)comboModel.getSelectedItem()).contains(value);
            }
        });
        final Method mutator = BeanUIUtil.getMutator((Object)this.getModel(), (String)property);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                comboBox.showPopup();
                if (e.getStateChange() == 1) {
                    BeanUIUtil.invokeMethod((Method)mutator, (Object)AbstractFaxToMailUIHandler.this.getModel(), (Object[])new Object[]{e.getItem()});
                }
            }
        });
    }
}

