/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.history;

import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.history.HistoryItem;
import com.franciaflex.faxtomail.ui.swing.content.demande.history.HistoryListUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.model.JaxxDefaultListModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;

public class HistoryListUIHandler
extends AbstractToolbarPopupHandler<DemandeUIModel, HistoryListUI> {
    private static final Log log = LogFactory.getLog(HistoryListUIHandler.class);
    protected Action sendAction;

    public void beforeInit(HistoryListUI ui) {
        super.beforeInit((ApplicationUI)ui);
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        ((HistoryListUI)this.ui).setContextValue(currentEmail);
    }

    @Override
    public void afterInit(HistoryListUI ui) {
        super.afterInit(ui);
        JXList list = ui.getHistories();
        list.setCellRenderer((ListCellRenderer)new HistoryListCellRenderer());
        JaxxDefaultListModel listModel = new JaxxDefaultListModel();
        listModel.setAllElements(((DemandeUIModel)this.getModel()).getHistory());
        list.setModel((ListModel)listModel);
        list.addHighlighter(HighlighterFactory.createAlternateStriping());
        ((DemandeUIModel)this.getModel()).addPropertyChangeListener("history", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Collection history = (Collection)evt.getNewValue();
                ((JaxxDefaultListModel)((HistoryListUI)HistoryListUIHandler.this.getUI()).getHistories().getModel()).setAllElements(history);
            }
        });
        this.sendAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder historyAsString = new StringBuilder();
                Collection<History> histories = ((DemandeUIModel)HistoryListUIHandler.this.getModel()).getHistory();
                for (History history : histories) {
                    historyAsString.append(I18n.t((String)"faxtomail.common.on.label", (Object[])new Object[0]) + " " + HistoryListUIHandler.this.decorate(history.getModificationDate())).append(" : " + JAXXUtil.getStringValue((Object)history.getType().getLabel()));
                    String decoratedFields = HistoryListUIHandler.this.decorateFields(history.getFields());
                    if (!decoratedFields.isEmpty()) {
                        historyAsString.append(" (" + decoratedFields + ")");
                    }
                    historyAsString.append("\n");
                }
                FaxToMailUIUtil.mail((String)I18n.t((String)"faxtomail.demande.history.send.subject", (Object[])new Object[]{((DemandeUIModel)HistoryListUIHandler.this.getModel()).getTitle()}), (String)historyAsString.toString());
            }
        };
        ImageIcon actionIcon = SwingUtil.createActionIcon((String)"reply");
        this.sendAction.putValue("SmallIcon", actionIcon);
        this.sendAction.putValue("SwingLargeIconKey", actionIcon);
        this.sendAction.putValue("Name", "send");
        this.sendAction.putValue("ShortDescription", I18n.t((String)"faxtomail.demande.history.action.send.tip", (Object[])new Object[0]));
        JButton sendButton = new JButton(this.sendAction);
        sendButton.setText(null);
        sendButton.setFocusPainted(false);
        sendButton.setRequestFocusEnabled(false);
        sendButton.setFocusable(false);
        ui.getBody().getRightDecoration().add((Component)sendButton, 0);
    }

    public void onCloseUI() {
    }

    public SwingValidator<DemandeUIModel> getValidator() {
        return null;
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public String decorateFields(Collection<String> fields) {
        ArrayList<String> fieldLabels = new ArrayList<String>();
        if (fields != null) {
            for (String field : fields) {
                String label = I18n.hasKey((String)("faxtomail.demande." + field + ".label")) ? I18n.t((String)("faxtomail.demande." + field + ".label"), (Object[])new Object[0]) : field;
                fieldLabels.add(label);
            }
        }
        return StringUtils.join(fieldLabels, (String)", ");
    }

    static {
        I18n.n((String)"faxtomail.demande.receptionDate.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.ediCodeNumber.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.projectReference.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.sender.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.fax.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.recipient.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.subject.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.clientCode.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.mailFolder.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.attachment.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.demandStatus.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.demandType.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.priority.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.etatAttente.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.takenBy.label", (Object[])new Object[0]);
        I18n.n((String)"faxtomail.demande.rangeRow.label", (Object[])new Object[0]);
    }

    protected class HistoryListCellRenderer
    extends HistoryItem
    implements ListCellRenderer {
        public HistoryListCellRenderer() {
            super(HistoryListUIHandler.this);
            this.getModel().addPropertyChangeListener("fields", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() != null) {
                        HistoryListCellRenderer.this.add((Component)HistoryListCellRenderer.this.getFields(), 1);
                    } else {
                        HistoryListCellRenderer.this.remove(HistoryListCellRenderer.this.getFields());
                    }
                }
            });
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            History history = (History)value;
            this.getModel().fromEntity(history);
            if (CollectionUtils.isEmpty(this.getModel().getFields())) {
                this.remove(this.getFields());
            }
            return this;
        }
    }
}

