package com.franciaflex.faxtomail.ui.swing.content;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.validator.swing.SwingValidatorMessageWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class MainUI extends JFrame implements FaxToMailUI<FaxToMailUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXTW8bRRieuLFT50NtExIKBEjSVhSp2jRIRZVSlQY3Vh3ZSVW7NCKHMN4d25PO7iwzs/VGURA/gZ8ANw5ckLhxQhw4c+CC+AsIceBa8c6svf7Ibu2oUbKOZt73med9Zt5n1j/8jbJSoNUjHIaWCDxFXWLtbO3v79WPiK0eEmkL6isuUPQzkUGZAzTjxONSoWsHZZ2+3klfL3DX5x7x+rI3y2haqmNGZIsQpdC7gxm2lOvVeHoz9APRRY1JJaF+++8/mW+cr7/LIBT6wG4OSlkZldWrZLKMMtRRaB5WeoHXGfaaQENQrwl85/RYgWEpd7FLvkRfoakyyvlYAJhCa+OXbDBMfugrlHcx9YoCIBXasLlrNQT2bIobjIRWA4eKQwCzAmrJNhCxbO4pwLUqkPa05PsGKadQ1uUOYQrdGQOjiMMaBwD2tFTQcKHq4Uy6xAsUekNXG3bidyow9ikWvaiLOqpIGZC+ciZSx1yKQxe6oQ+Jiz2HlKkEvRbPZJUUcXXKfJx5pZv5hNgtIuBPT7w5GLTYDYJKGrQZCKwo9xICZ6/vVAlsF4a9uK3Q0gCBeGYopwu+HVKVgJmvcwXigjTDitU4ZzCs4/Jx+NILzKijl6kQKXGTPKNOUx//uwNnNI7qgFX187PEVA282tu7OneOFVrlomkdQUs+V9yPMEJrZ79GFSPOY+wRNkgrJxVWATTujQEancXNXGfR/mSB3hkIh561ej3ba6qJA5QVAQwrdPXgbJs/gamowa8ONbgGNLMvlxb++Pmvn4rdrp6BtRcTQ/tMCbrNF9wnQlG99KWopQNF2XoF+5sHKC8JA0czjrWcQKzamQZysJ455ZZOtx5h2QKI7NSfv/y69MXvF1CmiKYZx04R6/gSyquWABU4c0L/kweG0Wz7Ijwvw18GWlXpnVDoeq81tQlYZtjCvs+obU7xrnGFRYc0cMBUgXFJ9qAiMwen6WTH+Ia1vV+qHe7tHhbKe9Xt0xCkXE6QMq6nnv/tv4Xqjw+6ck5AeW+lhvckzX6OctRj1CPGJjsOmGiLM74kgcN7Tpfkfajf/PyOt3xknh8nyTapjQoO0ZBqukWthrGiGQVdV6N+zQQupwWC0H5oXOqeKV//dx/1mdooMlmFpoiH69BOmpYISMxudWhROBKwWZbT733T0WBJWzmaZGZs/rBv37fsaIcfnYxh5hEYbFiLt/ssNsKwbC346bA0N0ayTNMoyc1fQ673k4mIruEPiZWTBMNwilzF88oV3yuvFOvaCI5pUp29vkYJNZUuVAoJu//SGxYrmkwRq3BesaL7dUipWbpx16t4xOUetRW6NQZLy43DB3X+YJxk0BoM9LBFGHxunKwl9Xhios5YO03ap+Q3iDEOdWdr3k7mTeCVYbjXo7HE/SidZz/MVbA1DJJyft9L5zco581Xymni01UceFUaJd4FsP4GXJlKn3Ug0MBMwmfOxaJJQYzVE4+0V8yVi9vKKnkwK2/evrUS/d75EIqcq3PhEPEYeCrdLxFIErXeW9ooXhNQR4PbgRwDNeVlboyLLC91OzFuP++VflmPVaAxxHG18zaWvnTnhW2ManItQpstfebuRVf3ClbwhaYeKHL/DPKEfk6PgZptw7eklp7+Ph3kf/q571lKDgAA";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTitledPanel body;
    protected JToolBar bottomBar;
    protected final MainUIHandler handler = new MainUIHandler();
    protected MainUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileDemandeList;
    protected JMenuItem menuFileExit;
    protected JMenuItem menuFileRecherche;
    protected FaxToMailUIContext model;
    protected StatusMessagePanel status;
    protected SwingValidatorMessageWidget validatorMessageWidget;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(FaxToMailUIContext context) {
        FaxToMailUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTitledPanel getBody() {
        return body;
    }

    public JToolBar getBottomBar() {
        return bottomBar;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileDemandeList() {
        return menuFileDemandeList;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenuItem getMenuFileRecherche() {
        return menuFileRecherche;
    }

    public FaxToMailUIContext getModel() {
        return model;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    public SwingValidatorMessageWidget getValidatorMessageWidget() {
        return validatorMessageWidget;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomBar.add(validatorMessageWidget);
    }

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(bottomBar);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileDemandeList);
        menuFile.add(menuFileRecherche);
        menuFile.add(menuFileConfiguration);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileExit);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
    }

    protected void createBottomBar() {
        $objectMap.put("bottomBar", bottomBar = new JToolBar());
        
        bottomBar.setName("bottomBar");
        bottomBar.setFloatable(false);
        bottomBar.setBorderPainted(false);
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(t("faxtomail.main.menu.file"));
        menuFile.setToolTipText(t("faxtomail.main.menu.file.tip"));
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setEnabled(true);
        menuFileConfiguration.setText(t("faxtomail.main.action.configuration"));
        menuFileConfiguration.setToolTipText(t("faxtomail.main.action.configuration.tip"));
        menuFileConfiguration.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.ShowConfigAction.class);
        menuFileConfiguration.putClientProperty("help", "faxtomail.main.menu.action.configuration.help");
    }

    protected void createMenuFileDemandeList() {
        $objectMap.put("menuFileDemandeList", menuFileDemandeList = new JMenuItem());
        
        menuFileDemandeList.setName("menuFileDemandeList");
        menuFileDemandeList.setEnabled(true);
        menuFileDemandeList.setText(t("faxtomail.main.action.demandeList"));
        menuFileDemandeList.setToolTipText(t("faxtomail.main.action.demandeList.tip"));
        menuFileDemandeList.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.ShowDemandeListAction.class);
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(t("faxtomail.main.action.exit"));
        menuFileExit.setToolTipText(t("faxtomail.main.action.exit.tip"));
        menuFileExit.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.CloseApplicationAction.class);
        menuFileExit.putClientProperty("help", "faxtomail.main.menu.action.exit.help");
    }

    protected void createMenuFileRecherche() {
        $objectMap.put("menuFileRecherche", menuFileRecherche = new JMenuItem());
        
        menuFileRecherche.setName("menuFileRecherche");
        menuFileRecherche.setEnabled(true);
        menuFileRecherche.setText(t("faxtomail.main.action.recherche"));
        menuFileRecherche.setToolTipText(t("faxtomail.main.action.recherche.tip"));
        menuFileRecherche.putClientProperty("applicationAction", com.franciaflex.faxtomail.ui.swing.actions.ShowRechercheAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(FaxToMailUIContext.class));
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
        status.setShowClock(false);
        status.setShowMemoryStatus(false);
    }

    protected void createValidatorMessageWidget() {
        $objectMap.put("validatorMessageWidget", validatorMessageWidget = new SwingValidatorMessageWidget());
        
        validatorMessageWidget.setName("validatorMessageWidget");
        validatorMessageWidget.setFocusPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToBottomBar();
        
        // apply 7 property setters
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        menuFileDemandeList.setIcon(SwingUtil.createActionIcon("list"));
        menuFileRecherche.setIcon(SwingUtil.createActionIcon("search"));
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileConfiguration.setMnemonic(SwingUtil.getFirstCharAt(t("faxtomail.main.action.configuration.mnemonic"),'Z'));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        bottomBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createMenu();
        createMenuFile();
        createMenuFileDemandeList();
        createMenuFileRecherche();
        createMenuFileConfiguration();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileExit();
        createBottomBar();
        createValidatorMessageWidget();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,780);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(t("faxtomail.main.title.applicationName"));
        
        $completeSetup();
        handler.afterInit(this);
    }

}