package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: TransmitAction.java 86 2014-05-21 19:30:41Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/actions/TransmitAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUI;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUI;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUIHandler;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class TransmitAction extends AbstractFaxToMailAction<DemandeUIModel, MailFolderChooserUI, MailFolderChooserUIHandler> {

    public TransmitAction(MailFolderChooserUIHandler handler) {
        super(handler, false);
        setActionDescription(t("faxtomail.action.transmit.tip"));
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel model = getModel();
        model.setDemandStatus(DemandStatus.QUALIFIED);
        model.setTakenBy(null);

        //TODO kmorin 20140306
        DemandesUI parentUI = (DemandesUI) getUI().getContextValue(JAXXContext.class, JAXXUtil.PARENT);
        DemandeUI demandeUI = (DemandeUI) parentUI.getDemandsTabPane().getSelectedComponent();
        SaveDemandeAction action = getContext().getActionFactory().createLogicAction(demandeUI.getHandler(),
                                                                                     SaveDemandeAndExitAction.class);
        getContext().getActionEngine().runAction(action);

    }
}
