package com.franciaflex.faxtomail.services.validators;

/*
 * #%L
 * FaxToMail :: Service
 * $Id: FaxToMailEmailValidator.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-service/src/main/java/com/franciaflex/faxtomail/services/validators/FaxToMailEmailValidator.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.opensymphony.xwork2.validator.validators.EmailValidator;

/**
 * Surcharge du validateur d'email par default de struts pour autoriser en plus le domaine ".fax".
 */
public class FaxToMailEmailValidator extends EmailValidator {

	// see XW-371 
    public static final String EMAIL_ADDRESS_PATTERN =
        "\\b^['_a-z0-9-\\+]+(\\.['_a-z0-9-\\+]+)*@[a-z0-9-]+(\\.[a-z0-9-]+)*\\.([a-z]{2}|aero|arpa|asia|biz|com|coop|edu|gov|info|int|jobs|mil|mobi|museum|name|nato|net|org|pro|tel|travel|xxx|fax)$\\b";

    public FaxToMailEmailValidator() {
        setRegex(EMAIL_ADDRESS_PATTERN);
    }

}
