package com.franciaflex.faxtomail.services.service.imports;

/*
 * #%L
 * FaxToMail :: Service
 * $Id: ArchiveImportBean.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-service/src/main/java/com/franciaflex/faxtomail/services/service/imports/ArchiveImportBean.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.EmailImpl;

/**
 * Bean model d'import des archives. (très proche de l'entité
 * {@link com.franciaflex.faxtomail.persistence.entities.Email}).
 * 
 * @author Eric Chatellier
 */
public class ArchiveImportBean extends EmailImpl {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1498046445018851410L;

    protected static final String PROPERTY_ATTACHMENT_PATHS = "attachmentPaths";
    protected static final String PROPERTY_CLIENT_CODE = "clientCode";
    protected static final String PROPERTY_CLIENT_BRAND = "clientBrand";

    protected String attachmentPaths;
    
    protected String clientCode;
    
    protected String clientBrand;

    public String getAttachmentPaths() {
        return attachmentPaths;
    }

    public void setAttachmentPaths(String attachmentPaths) {
        this.attachmentPaths = attachmentPaths;
    }
    
    public String getClientCode() {
        return clientCode;
    }
    
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }
    
    public String getClientBrand() {
        return clientBrand;
    }
    
    public void setClientBrand(String clientBrand) {
        this.clientBrand = clientBrand;
    }
}
