/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.token;

import com.ethlo.time.Field;
import com.ethlo.time.internal.util.LimitedCharArrayIntegerUtil;
import com.ethlo.time.token.DateTimeToken;
import java.text.ParsePosition;

public class DigitsToken
implements DateTimeToken {
    private final Field field;
    private final int length;

    public DigitsToken(Field field, int length) {
        this.field = field;
        this.length = length;
    }

    @Override
    public int read(String text, ParsePosition parsePosition) {
        int offset = parsePosition.getIndex();
        int end = offset + this.length;
        int value = LimitedCharArrayIntegerUtil.parsePositiveInt(text, offset, end);
        parsePosition.setIndex(end);
        return value;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    public String toString() {
        return "digits: " + (Object)((Object)this.field) + "(" + this.length + ")";
    }
}

