/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.mvs;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.mvs.model.InsertImageRequest;
import com.baidubce.services.mvs.model.InsertImageResponse;
import com.baidubce.services.mvs.model.InsertVideoRequest;
import com.baidubce.services.mvs.model.InsertVideoResponse;
import com.baidubce.services.mvs.model.SearchImageByImageRequest;
import com.baidubce.services.mvs.model.SearchImageByImageResponse;
import com.baidubce.services.mvs.model.SearchVideoByVideoRequest;
import com.baidubce.services.mvs.model.SearchVideoByVideoResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;

public class MvsClient
extends AbstractBceClient {
    private static final String VERSION = "v2";
    private static final String VIDEO_LIB = "videolib";
    private static final String IMAGE_LIB = "imagelib";
    private static final String SEARCH_BY_IMAGE = "searchByImage";
    private static final String SEARCH_BY_VIDEO = "searchByVideo";
    private static HttpResponseHandler[] mvsHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public MvsClient(BceClientConfiguration config) {
        super(config, mvsHandlers);
    }

    public InsertVideoResponse insertVideo(String lib, InsertVideoRequest insertVideoRequest) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, insertVideoRequest, VERSION, VIDEO_LIB, lib);
        return this.invokeHttpClient(internalRequest, InsertVideoResponse.class);
    }

    public SearchVideoByVideoResponse searchVideoByVideo(String lib, SearchVideoByVideoRequest searchVideoByVideoRequest) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, searchVideoByVideoRequest, VERSION, VIDEO_LIB, lib);
        internalRequest.addParameter(SEARCH_BY_VIDEO, "");
        return this.invokeHttpClient(internalRequest, SearchVideoByVideoResponse.class);
    }

    public InsertImageResponse insertImage(String lib, InsertImageRequest insertImageRequest) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, insertImageRequest, VERSION, IMAGE_LIB, lib);
        return this.invokeHttpClient(internalRequest, InsertImageResponse.class);
    }

    public SearchImageByImageResponse searchImageByImage(String lib, SearchImageByImageRequest searchImageByImageRequest) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, searchImageByImageRequest, VERSION, IMAGE_LIB, lib);
        internalRequest.addParameter(SEARCH_BY_IMAGE, "");
        return this.invokeHttpClient(internalRequest, SearchImageByImageResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }
}

