/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.demo;

import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.BosObjectSummary;
import com.baidubce.services.bos.model.ListObjectsRequest;
import com.baidubce.services.bos.model.ListObjectsResponse;

public class ListObjectsDemo {
    public static void listObjectsSimple() {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        ListObjectsResponse listing = client.listObjects("bucketName");
        for (BosObjectSummary objectSummary : listing.getContents()) {
            System.out.println("ObjectKey: " + objectSummary.getKey());
        }
        client.shutdown();
    }

    public static void listObjectsWithArgs() {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest("bucketName");
        listObjectsRequest.withMaxKeys(500);
        listObjectsRequest.withPrefix("obj");
        listObjectsRequest.withMarker("object");
        ListObjectsResponse listObjectsResponse = client.listObjects(listObjectsRequest);
        for (BosObjectSummary objectSummary : listObjectsResponse.getContents()) {
            System.out.println("ObjectKey:" + objectSummary.getKey());
        }
        client.shutdown();
    }

    public static void listAllObjects() {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest("bucketName");
        listObjectsRequest.withMaxKeys(500);
        boolean isTruncated = true;
        while (isTruncated) {
            ListObjectsResponse listObjectsResponse = client.listObjects(listObjectsRequest);
            for (BosObjectSummary objectSummary : listObjectsResponse.getContents()) {
                System.out.println("ObjectKey:" + objectSummary.getKey());
            }
            isTruncated = listObjectsResponse.isTruncated();
            if (listObjectsResponse.getNextMarker() == null) continue;
            listObjectsRequest.withMarker(listObjectsResponse.getNextMarker());
        }
        client.shutdown();
    }

    public static void listObjectsAndDir() {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest("bucketName");
        listObjectsRequest.setDelimiter("/");
        listObjectsRequest.setPrefix("fun/");
        ListObjectsResponse listing = client.listObjects(listObjectsRequest);
        System.out.println("Objects:");
        for (BosObjectSummary objectSummary : listing.getContents()) {
            System.out.println(objectSummary.getKey());
        }
        System.out.println("\nCommonPrefixs:");
        for (String commonPrefix : listing.getCommonPrefixes()) {
            System.out.println(commonPrefix);
        }
        client.shutdown();
    }
}

