/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.billing;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.billing.BillingClientConfiguration;
import com.baidubce.services.billing.model.ResourceMonthBillRequest;
import com.baidubce.services.billing.model.ResourceMonthBillResponse;
import com.baidubce.services.billing.model.bill.PrepayShareBillRequest;
import com.baidubce.services.billing.model.bill.PrepayShareBillResponse;
import com.baidubce.services.billing.model.bill.ResourceBillListQueryRequest;
import com.baidubce.services.billing.model.bill.ResourceBillListQueryResponse;
import com.baidubce.services.billing.model.finance.SupervisorBalanceQueryRequest;
import com.baidubce.services.billing.model.finance.SupervisorBalanceResponse;
import com.baidubce.services.billing.model.finance.SupervisorBalanceTransferRequest;
import com.baidubce.services.billing.model.finance.SupervisorTransactionPageRequest;
import com.baidubce.services.billing.model.finance.SupervisorTransactionResponse;
import com.baidubce.services.billing.model.finance.TransferResultResponse;
import com.baidubce.services.billing.model.order.OrderListRequest;
import com.baidubce.services.billing.model.order.OrderListResponse;
import com.baidubce.services.billing.model.price.CpcPricingRequest;
import com.baidubce.services.billing.model.price.CptPricingRequest;
import com.baidubce.services.billing.model.price.PricingQueryResponse;
import com.baidubce.services.billing.model.renew.RenewResourceListRequest;
import com.baidubce.services.billing.model.renew.RenewResourceResponse;
import com.baidubce.services.billing.model.renew.ResourceAutoRenewRequest;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillingClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(BillingClient.class);
    private static final String VERSION_V1 = "v1";
    private static final String BILL = "bill";
    private static final String RESOURCE = "resource";
    private static final String RENEW = "renew";
    private static final String MONTH = "month";
    private static final String SHARE_PREPAY = "share/prepay";
    private static final String PRICE = "price";
    private static final String CPC = "cpc";
    private static final String CPT = "cpt";
    private static final String ORDER = "order";
    private static final String LIST = "list";
    private static final String FINANCE = "finance";
    private static final String SUPERVISOR = "supervisor";
    private static final String BALANCE = "balance";
    private static final String TRANSFER = "transfer";
    private static final String GATHER = "gather";
    private static final String CASH = "cash";
    private static final String TRANSACTION = "transaction";
    private static HttpResponseHandler[] billingHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public BillingClient() {
        this(new BillingClientConfiguration());
    }

    public BillingClient(BceClientConfiguration config) {
        super(config, billingHandlers);
    }

    public ResourceMonthBillResponse getResourceMonthBill(ResourceMonthBillRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkIsTrue(!StringUtils.isEmpty((String)request.getBeginTime()) || !StringUtils.isEmpty((String)request.getEndTime()) || !StringUtils.isEmpty((String)request.getMonth()), "Parameters month , beginTime and endTime cannot all be empty!");
        Validate.checkIsTrue(!StringUtils.isEmpty((String)request.getBeginTime()) || StringUtils.isEmpty((String)request.getEndTime()), "If parameter endTime is not empty, parameter beginTime cannot be empty!");
        Validate.checkIsTrue(StringUtils.isEmpty((String)request.getBeginTime()) || !StringUtils.isEmpty((String)request.getEndTime()), "If parameter beginTime is not empty, parameter endTime cannot be empty!");
        Validate.checkStringNotEmpty(request.getProductType(), "The parameter productType should NOT be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VERSION_V1, BILL, RESOURCE, MONTH);
        if (request.getMonth() != null) {
            internalRequest.addParameter(MONTH, request.getMonth());
        }
        if (request.getBeginTime() != null) {
            internalRequest.addParameter("beginTime", request.getBeginTime());
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        internalRequest.addParameter("productType", request.getProductType());
        if (request.getServiceType() != null) {
            internalRequest.addParameter("serviceType", request.getServiceType());
        }
        if (request.getQueryAccountId() != null) {
            internalRequest.addParameter("queryAccountId", request.getQueryAccountId());
        }
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, ResourceMonthBillResponse.class);
    }

    public PrepayShareBillResponse queryPrepayShareBill(PrepayShareBillRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkIsTrue(!StringUtils.isEmpty((String)request.getMonth()), "The parameter month cannot be empty!");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VERSION_V1, BILL, SHARE_PREPAY);
        if (request.getMonth() != null) {
            internalRequest.addParameter(MONTH, request.getMonth());
        }
        if (request.getServiceType() != null) {
            internalRequest.addParameter("serviceType", request.getServiceType());
        }
        if (request.getQueryAccountId() != null) {
            internalRequest.addParameter("queryAccountId", request.getQueryAccountId());
        }
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, PrepayShareBillResponse.class);
    }

    public ResourceBillListQueryResponse getResourceBillList(ResourceBillListQueryRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkIsTrue(!StringUtils.isEmpty((String)request.getBeginTime()) || !StringUtils.isEmpty((String)request.getEndTime()) || !StringUtils.isEmpty((String)request.getBillMonth()), "Parameters billMonth , beginTime and endTime cannot all be empty!");
        Validate.checkIsTrue(!StringUtils.isEmpty((String)request.getBeginTime()) || StringUtils.isEmpty((String)request.getEndTime()), "If parameter endTime is not empty, parameter beginTime cannot be empty!");
        Validate.checkIsTrue(StringUtils.isEmpty((String)request.getBeginTime()) || !StringUtils.isEmpty((String)request.getEndTime()), "If parameter beginTime is not empty, parameter endTime cannot be empty!");
        Validate.checkStringNotEmpty(request.getProductType(), "The parameter productType should NOT be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_V1, BILL, RESOURCE, LIST);
        return this.invokeHttpClient(internalRequest, ResourceBillListQueryResponse.class);
    }

    public OrderListResponse getOrderList(OrderListRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_V1, ORDER, LIST);
        return this.invokeHttpClient(internalRequest, OrderListResponse.class);
    }

    public PricingQueryResponse getSpecificCpcPrice(CpcPricingRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getServiceType(), "The parameter serviceType should NOT be null");
        Validate.checkStringNotEmpty(request.getProductType(), "The parameter productType should NOT be null");
        Validate.checkStringNotEmpty(request.getRegion(), "The parameter region should NOT be null");
        Validate.checkNotNull(request.getFlavor(), "The parameter flavor should NOT be null");
        Validate.checkNotNull(request.getFlavor().getChargeItems(), "The parameter chargeItems should NOT be null");
        Validate.checkIsTrue(request.getFlavor().getChargeItems().size() > 0, "The parameter chargeItems should NOT be empty!");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_V1, PRICE, CPC);
        return this.invokeHttpClient(internalRequest, PricingQueryResponse.class);
    }

    public PricingQueryResponse getSpecificCptPrice(CptPricingRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getServiceType(), "The parameter serviceType should NOT be null");
        Validate.checkStringNotEmpty(request.getProductType(), "The parameter productType should NOT be null");
        Validate.checkStringNotEmpty(request.getRegion(), "The parameter region should NOT be null");
        Validate.checkNotNull(request.getFlavor(), "The parameter flavor should NOT be null");
        Validate.checkNotNull(request.getFlavor().getChargeItems(), "The parameter chargeItems should NOT be null");
        Validate.checkIsTrue(request.getFlavor().getChargeItems().size() > 0, "The parameter chargeItems should NOT be empty!");
        Validate.checkNotNull(request.getPeriod(), "The parameter period should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_V1, PRICE, CPT);
        return this.invokeHttpClient(internalRequest, PricingQueryResponse.class);
    }

    public RenewResourceResponse queryRenewResourceList(RenewResourceListRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkIsTrue(!StringUtils.isEmpty((String)request.getServiceType()), "The parameter serviceType cannot be empty!");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_V1, RENEW, "/resource/list");
        return this.invokeHttpClient(internalRequest, RenewResourceResponse.class);
    }

    public void setRenewResourceRule(ResourceAutoRenewRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getServiceType(), "The parameter serviceType should NOT be null");
        Validate.checkStringNotEmpty(request.getRegion(), "The parameter region should NOT be null");
        Validate.checkStringNotEmpty(request.getInstanceId(), "The parameter instanceId should NOT be null");
        Validate.checkNotNull(request.getRenewTime(), "The parameter renewTime should NOT be null.");
        Validate.checkNotNull(request.getRenewTimeUnit(), "The parameter renewTimeUnit should NOT be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_V1, RENEW, "/resource/rule/create");
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public TransferResultResponse balanceTransfer(SupervisorBalanceTransferRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSupervisedId(), "The parameter supervisedId should NOT be null");
        Validate.checkNotNull(request.getAmount(), "The parameter amount should NOT be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_V1, FINANCE, SUPERVISOR, BALANCE, TRANSFER);
        return this.invokeHttpClient(internalRequest, TransferResultResponse.class);
    }

    public TransferResultResponse balanceGather(SupervisorBalanceTransferRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSupervisedId(), "The parameter supervisedId should NOT be null");
        Validate.checkNotNull(request.getAmount(), "The parameter amount should NOT be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_V1, FINANCE, SUPERVISOR, BALANCE, GATHER);
        return this.invokeHttpClient(internalRequest, TransferResultResponse.class);
    }

    public SupervisorTransactionResponse transactionList(SupervisorTransactionPageRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getBeginTime(), "The parameter beginTime should NOT be null");
        Validate.checkStringNotEmpty(request.getEndTime(), "The parameter endTime should NOT be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_V1, FINANCE, SUPERVISOR, CASH, TRANSACTION);
        return this.invokeHttpClient(internalRequest, SupervisorTransactionResponse.class);
    }

    public SupervisorBalanceResponse balanceQuery(SupervisorBalanceQueryRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getAccountIds(), "The parameter accountIds should NOT be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VERSION_V1, FINANCE, SUPERVISOR, CASH, BALANCE);
        return this.invokeHttpClient(internalRequest, SupervisorBalanceResponse.class);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(request, bceRequest);
        }
        return request;
    }

    private void fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }
}

