// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The result of a list request.
 */
@Fluent
public final class KeyValueListResult implements JsonSerializable<KeyValueListResult> {
    /*
     * The collection value.
     */
    private List<KeyValue> items;

    /*
     * An identifier representing the returned state of the resource.
     */
    private String etag;

    /*
     * The URI that can be used to request the next set of paged results.
     */
    private String nextLink;

    /**
     * Creates an instance of KeyValueListResult class.
     */
    public KeyValueListResult() {
    }

    /**
     * Get the items property: The collection value.
     * 
     * @return the items value.
     */
    public List<KeyValue> getItems() {
        return this.items;
    }

    /**
     * Set the items property: The collection value.
     * 
     * @param items the items value to set.
     * @return the KeyValueListResult object itself.
     */
    public KeyValueListResult setItems(List<KeyValue> items) {
        this.items = items;
        return this;
    }

    /**
     * Get the etag property: An identifier representing the returned state of the resource.
     * 
     * @return the etag value.
     */
    public String getEtag() {
        return this.etag;
    }

    /**
     * Set the etag property: An identifier representing the returned state of the resource.
     * 
     * @param etag the etag value to set.
     * @return the KeyValueListResult object itself.
     */
    public KeyValueListResult setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next set of paged results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the KeyValueListResult object itself.
     */
    public KeyValueListResult setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("items", this.items, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeStringField("@nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyValueListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyValueListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyValueListResult.
     */
    public static KeyValueListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyValueListResult deserializedKeyValueListResult = new KeyValueListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("items".equals(fieldName)) {
                    List<KeyValue> items = reader.readArray(reader1 -> KeyValue.fromJson(reader1));
                    deserializedKeyValueListResult.items = items;
                } else if ("etag".equals(fieldName)) {
                    deserializedKeyValueListResult.etag = reader.getString();
                } else if ("@nextLink".equals(fieldName)) {
                    deserializedKeyValueListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyValueListResult;
        });
    }
}
