// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.data.appconfiguration.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;
import java.util.Locale;

/**
 * Fields in {@link ConfigurationSetting} that can be returned from GET queries.
 *
 * @see SettingSelector
 */
public final class SettingFields extends ExpandableStringEnum<SettingFields> {

    /**
     * Populates the 'key' from the service.
     */
    public static final SettingFields KEY = fromString("key");

    /**
     * Populates the 'label' from the service.
     */
    public static final SettingFields LABEL = fromString("label");

    /**
     * Populates the 'value' from the service.
     */
    public static final SettingFields VALUE = fromString("value");

    /**
     * Populates the 'content_type' from the service.
     */
    public static final SettingFields CONTENT_TYPE = fromString("content_type");

    /**
     * Populates the 'etag' from the service.
     */
    public static final SettingFields ETAG = fromString("etag");

    /**
     * Populates the 'last_modified' from the service.
     */
    public static final SettingFields LAST_MODIFIED = fromString("last_modified");

    /**
     * Populates the 'locked' from the service.
     */
    public static final SettingFields IS_READ_ONLY = fromString("locked");

    /**
     * Populates the 'tags' from the service.
     */
    public static final SettingFields TAGS = fromString("tags");

    /**
     * Creates a new instance of SettingFields value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public SettingFields() {
    }

    /**
     * Creates or finds a {@link SettingFields} from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding {@link SettingFields}
     */
    public static SettingFields fromString(String name) {
        return fromString(name, SettingFields.class);
    }

    /**
     * Gets known SettingFields values.
     *
     * @return known SettingFields values.
     */
    public static Collection<SettingFields> values() {
        return values(SettingFields.class);
    }

    /**
     * Converts the SettingFields to a string that is usable for HTTP requests and logging.
     *
     * @param field SettingFields to map.
     * @return SettingFields as a lowercase string in the US locale.
     * @deprecated This method is no longer needed. SettingFields is using lower case enum value for the HTTP requests.
     */
    @Deprecated()
    public static String toStringMapper(SettingFields field) {
        return field.toString().toLowerCase(Locale.US);
    }
}
