/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PreValidator {
    private PreValidator() {
    }

    @NonNull
    public static MergingReport.Result validate(@NonNull MergingReport.Builder mergingReport, @NonNull XmlDocument xmlDocument) {
        PreValidator.validateManifestAttribute(mergingReport, xmlDocument.getRootNode(), xmlDocument.getFileType());
        return PreValidator.validate(mergingReport, xmlDocument.getRootNode());
    }

    private static MergingReport.Result validate(MergingReport.Builder mergingReport, XmlElement xmlElement) {
        PreValidator.validateAttributeInstructions(mergingReport, xmlElement);
        PreValidator.validateAndroidAttributes(mergingReport, xmlElement);
        PreValidator.checkSelectorPresence(mergingReport, xmlElement);
        HashMap<XmlNode.NodeKey, XmlElement> childrenKeys = new HashMap<XmlNode.NodeKey, XmlElement>();
        for (XmlElement childElement : xmlElement.getMergeableElements()) {
            if (childElement.getOperationType() == NodeOperationType.REMOVE_ALL) {
                PreValidator.validateRemoveAllOperation(mergingReport, childElement);
                continue;
            }
            if (PreValidator.checkKeyPresence(mergingReport, childElement)) {
                XmlElement twin = (XmlElement)childrenKeys.get(childElement.getId());
                if (twin != null && !childElement.getType().areMultipleDeclarationAllowed()) {
                    String message = String.format("Element %1$s at %2$s duplicated with element declared at %3$s", childElement.getId(), childElement.printPosition(), ((XmlElement)childrenKeys.get(childElement.getId())).printPosition());
                    if (twin.compareTo(childElement).isPresent()) {
                        childElement.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, message);
                    } else {
                        childElement.addMessage(mergingReport, MergingReport.Record.Severity.WARNING, message);
                    }
                }
                childrenKeys.put(childElement.getId(), childElement);
            }
            PreValidator.validate(mergingReport, childElement);
        }
        return mergingReport.hasErrors() ? MergingReport.Result.ERROR : MergingReport.Result.SUCCESS;
    }

    private static void validateRemoveAllOperation(MergingReport.Builder mergingReport, XmlElement element) {
        NamedNodeMap attributes = element.getXml().getAttributes();
        if (attributes.getLength() > 1) {
            ArrayList<String> extraAttributeNames = new ArrayList<String>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node item = attributes.item(i);
                if ("http://schemas.android.com/tools".equals(item.getNamespaceURI()) && "node".equals(item.getLocalName())) continue;
                extraAttributeNames.add(item.getNodeName());
            }
            String message = String.format("Element %1$s at %2$s annotated with 'tools:node=\"removeAll\"' cannot have other attributes : %3$s", element.getId(), element.printPosition(), Joiner.on((char)',').join(extraAttributeNames));
            element.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, message);
        }
    }

    private static void checkSelectorPresence(MergingReport.Builder mergingReport, XmlElement element) {
        Attr selectorAttribute = element.getXml().getAttributeNodeNS("http://schemas.android.com/tools", "selector");
        if (selectorAttribute != null && !element.supportsSelector()) {
            String message = String.format("Unsupported tools:selector=\"%1$s\" found on node %2$s at %3$s", selectorAttribute.getValue(), element.getId(), element.printPosition());
            element.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, message);
        }
    }

    private static void validateManifestAttribute(MergingReport.Builder mergingReport, XmlElement manifest, XmlDocument.Type fileType) {
        Attr attributeNode = manifest.getXml().getAttributeNode("package");
        if (attributeNode == null && fileType != XmlDocument.Type.OVERLAY) {
            manifest.addMessage(mergingReport, fileType == XmlDocument.Type.MAIN ? MergingReport.Record.Severity.ERROR : MergingReport.Record.Severity.WARNING, String.format("Missing 'package' declaration in manifest at %1$s", manifest.printPosition()));
        }
    }

    private static boolean checkKeyPresence(MergingReport.Builder mergingReport, XmlElement xmlElement) {
        ManifestModel.NodeKeyResolver nodeKeyResolver = xmlElement.getType().getNodeKeyResolver();
        ImmutableList<String> keyAttributesNames = nodeKeyResolver.getKeyAttributesNames();
        if (keyAttributesNames.isEmpty()) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)xmlElement.getKey())) {
            String message = keyAttributesNames.size() > 1 ? String.format("Missing one of the key attributes '%1$s' on element %2$s at %3$s", Joiner.on((char)',').join(keyAttributesNames), xmlElement.getId(), xmlElement.printPosition()) : String.format("Missing '%1$s' key attribute on element %2$s at %3$s", keyAttributesNames.get(0), xmlElement.getId(), xmlElement.printPosition());
            xmlElement.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, message);
            return false;
        }
        return true;
    }

    private static void validateAndroidAttributes(MergingReport.Builder mergingReport, XmlElement xmlElement) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            AttributeModel model = xmlAttribute.getModel();
            if (model == null || model.getOnReadValidator() == null) continue;
            model.getOnReadValidator().validates(mergingReport, xmlAttribute, xmlAttribute.getValue());
        }
    }

    private static void validateAttributeInstructions(MergingReport.Builder mergingReport, XmlElement xmlElement) {
        block5: for (Map.Entry<XmlNode.NodeName, AttributeOperationType> attributeOperationTypeEntry : xmlElement.getAttributeOperations()) {
            Optional<XmlAttribute> attribute = xmlElement.getAttribute(attributeOperationTypeEntry.getKey());
            switch (attributeOperationTypeEntry.getValue()) {
                case STRICT: {
                    continue block5;
                }
                case REMOVE: {
                    if (!attribute.isPresent()) continue block5;
                    xmlElement.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("tools:remove specified at line:%d for attribute %s, but attribute also declared at line:%d, do you want to use tools:replace instead ?", xmlElement.getLine(), attributeOperationTypeEntry.getKey(), ((XmlAttribute)attribute.get()).getPosition().getLine()));
                    continue block5;
                }
                case REPLACE: {
                    if (attribute.isPresent()) continue block5;
                    xmlElement.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("tools:replace specified at line:%d for attribute %s, but no new value specified", xmlElement.getLine(), attributeOperationTypeEntry.getKey()));
                    continue block5;
                }
            }
            throw new IllegalStateException("Unhandled AttributeOperationType " + (Object)((Object)attributeOperationTypeEntry.getValue()));
        }
    }
}

