/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.testing.SimpleTestCallable;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.TestException;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.ILogger;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;

public class SimpleTestRunner
implements TestRunner {
    @Override
    public boolean runTests(@NonNull String projectName, @NonNull String variantName, @NonNull File testApk, @Nullable File testedApk, @NonNull TestData testData, @NonNull List<? extends DeviceConnector> deviceList, int maxThreads, int timeout, @NonNull File resultsDir, @NonNull ILogger logger) throws TestException, InterruptedException {
        int n;
        WaitableExecutor executor = new WaitableExecutor(maxThreads);
        int minSdkVersion = testData.getMinSdkVersion();
        for (DeviceConnector deviceConnector : deviceList) {
            int deviceApiLevel = deviceConnector.getApiLevel();
            if (minSdkVersion <= deviceApiLevel) {
                executor.execute((Callable)new SimpleTestCallable(deviceConnector, projectName, variantName, testApk, testedApk, testData, resultsDir, timeout, logger));
                continue;
            }
            if (deviceApiLevel == 0) {
                logger.info("Skipping device '%s' for '%s:%s': Unknown API Level", new Object[]{deviceConnector.getName(), projectName, variantName});
                continue;
            }
            logger.info("Skipping device '%s' for '%s:%s'", new Object[]{deviceConnector.getName(), projectName, variantName});
        }
        List results = executor.waitForAllTasks();
        boolean bl = true;
        for (WaitableExecutor.TaskResult result : results) {
            if (result.value != null) {
                n &= (Boolean)result.value == false ? 1 : 0;
                continue;
            }
            n = 0;
            logger.error(result.exception, null, new Object[0]);
        }
        return n != 0;
    }
}

