/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.AaptOptions;
import com.android.builder.DexOptions;
import com.android.builder.SdkParser;
import com.android.builder.VariantConfiguration;
import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.dependency.ManifestDependency;
import com.android.builder.dependency.SymbolFileProvider;
import com.android.builder.internal.BuildConfigGenerator;
import com.android.builder.internal.SymbolLoader;
import com.android.builder.internal.SymbolWriter;
import com.android.builder.internal.TestManifestGenerator;
import com.android.builder.internal.compiler.AidlProcessor;
import com.android.builder.internal.compiler.FileGatherer;
import com.android.builder.internal.compiler.LeafFolderGatherer;
import com.android.builder.internal.compiler.SourceSearcher;
import com.android.builder.internal.packaging.JavaResourceProcessor;
import com.android.builder.internal.packaging.Packager;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import com.android.builder.packaging.SigningException;
import com.android.builder.signing.CertificateInfo;
import com.android.builder.signing.KeystoreHelper;
import com.android.builder.signing.KeytoolException;
import com.android.builder.signing.SigningConfig;
import com.android.ide.common.internal.AaptRunner;
import com.android.ide.common.internal.CommandLineRunner;
import com.android.manifmerger.ManifestMerger;
import com.android.manifmerger.MergerLog;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class AndroidBuilder {
    private static final FullRevision MIN_BUILD_TOOLS_REV = new FullRevision(16, 0, 0);
    private static final DependencyFileProcessor sNoOpDependencyFileProcessor = new DependencyFileProcessor(){

        @Override
        public boolean processFile(@NonNull File dependencyFile) {
            return true;
        }
    };
    private final SdkParser mSdkParser;
    private final ILogger mLogger;
    private final CommandLineRunner mCmdLineRunner;
    private final boolean mVerboseExec;
    @NonNull
    private final IAndroidTarget mTarget;
    @NonNull
    private final BuildToolInfo mBuildTools;
    private String mCreatedBy;

    public AndroidBuilder(@NonNull SdkParser sdkParser, @Nullable String createdBy, @NonNull ILogger logger, boolean verboseExec) {
        this.mCreatedBy = createdBy;
        this.mSdkParser = (SdkParser)Preconditions.checkNotNull((Object)sdkParser);
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
        this.mCmdLineRunner = new CommandLineRunner(this.mLogger);
        BuildToolInfo buildToolInfo = this.mSdkParser.getBuildTools();
        FullRevision buildToolsRevision = buildToolInfo.getRevision();
        if (buildToolsRevision.compareTo(MIN_BUILD_TOOLS_REV) < 0) {
            throw new IllegalArgumentException(String.format("The SDK Build Tools revision (%1$s) is too low. Minimum required is %2$s", buildToolsRevision, MIN_BUILD_TOOLS_REV));
        }
        this.mTarget = this.mSdkParser.getTarget();
        this.mBuildTools = this.mSdkParser.getBuildTools();
    }

    AndroidBuilder(@NonNull SdkParser sdkParser, @NonNull CommandLineRunner cmdLineRunner, @NonNull ILogger logger, boolean verboseExec) {
        this.mSdkParser = (SdkParser)Preconditions.checkNotNull((Object)sdkParser);
        this.mCmdLineRunner = (CommandLineRunner)Preconditions.checkNotNull((Object)cmdLineRunner);
        this.mLogger = (ILogger)Preconditions.checkNotNull((Object)logger);
        this.mVerboseExec = verboseExec;
        this.mTarget = this.mSdkParser.getTarget();
        this.mBuildTools = this.mSdkParser.getBuildTools();
    }

    public static List<String> getBootClasspath(@NonNull SdkParser sdkParser) {
        ArrayList classpath = Lists.newArrayList();
        IAndroidTarget target = sdkParser.getTarget();
        classpath.addAll(target.getBootClasspath());
        IAndroidTarget.IOptionalLibrary[] libs = target.getOptionalLibraries();
        if (libs != null) {
            for (IAndroidTarget.IOptionalLibrary lib : libs) {
                classpath.add(lib.getJarPath());
            }
        }
        if (target.getVersion().getApiLevel() <= 15) {
            classpath.add(sdkParser.getAnnotationsJar());
        }
        return classpath;
    }

    public AaptRunner getAaptRunner() {
        return new AaptRunner(this.mBuildTools.getPath(BuildToolInfo.PathId.AAPT), this.mCmdLineRunner);
    }

    public void generateBuildConfig(@NonNull String packageName, boolean debuggable, @NonNull List<String> javaLines, @NonNull String sourceOutputDir) throws IOException {
        BuildConfigGenerator generator = new BuildConfigGenerator(sourceOutputDir, packageName, debuggable);
        generator.generate(javaLines);
    }

    public void processManifest(@NonNull File mainManifest, @NonNull List<File> manifestOverlays, @NonNull List<? extends ManifestDependency> libraries, String packageOverride, int versionCode, String versionName, int minSdkVersion, int targetSdkVersion, @NonNull String outManifestLocation) {
        Preconditions.checkNotNull((Object)mainManifest, (Object)"mainManifest cannot be null.");
        Preconditions.checkNotNull(manifestOverlays, (Object)"manifestOverlays cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)outManifestLocation, (Object)"outManifestLocation cannot be null.");
        try {
            Map<String, String> attributeInjection = this.getAttributeInjectionMap(versionCode, versionName, minSdkVersion, targetSdkVersion);
            if (manifestOverlays.isEmpty() && libraries.isEmpty()) {
                if (attributeInjection.isEmpty() && packageOverride == null) {
                    Files.copy((File)mainManifest, (File)new File(outManifestLocation));
                } else {
                    ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)this.mLogger), null);
                    this.doMerge(merger, new File(outManifestLocation), mainManifest, attributeInjection, packageOverride);
                }
            } else {
                File outManifest = new File(outManifestLocation);
                if (!manifestOverlays.isEmpty()) {
                    File mainManifestOut = outManifest;
                    if (!libraries.isEmpty()) {
                        mainManifestOut = File.createTempFile("manifestMerge", ".xml");
                        mainManifestOut.deleteOnExit();
                    }
                    ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)this.mLogger), null);
                    this.doMerge(merger, mainManifestOut, mainManifest, manifestOverlays, attributeInjection, packageOverride);
                    mainManifest = mainManifestOut;
                    attributeInjection = null;
                }
                if (!libraries.isEmpty()) {
                    this.mergeLibraryManifests(mainManifest, libraries, new File(outManifestLocation), attributeInjection, packageOverride);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processTestManifest(@NonNull String testPackageName, int minSdkVersion, int targetSdkVersion, @NonNull String testedPackageName, @NonNull String instrumentationRunner, @NonNull List<? extends ManifestDependency> libraries, @NonNull String outManifestLocation) {
        Preconditions.checkNotNull((Object)testPackageName, (Object)"testPackageName cannot be null.");
        Preconditions.checkNotNull((Object)testedPackageName, (Object)"testedPackageName cannot be null.");
        Preconditions.checkNotNull((Object)instrumentationRunner, (Object)"instrumentationRunner cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)outManifestLocation, (Object)"outManifestLocation cannot be null.");
        if (!libraries.isEmpty()) {
            try {
                File generatedTestManifest = File.createTempFile("manifestMerge", ".xml");
                this.generateTestManifest(testPackageName, minSdkVersion, targetSdkVersion, testedPackageName, instrumentationRunner, generatedTestManifest.getAbsolutePath());
                this.mergeLibraryManifests(generatedTestManifest, libraries, new File(outManifestLocation), null, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.generateTestManifest(testPackageName, minSdkVersion, targetSdkVersion, testedPackageName, instrumentationRunner, outManifestLocation);
        }
    }

    private void generateTestManifest(String testPackageName, int minSdkVersion, int targetSdkVersion, String testedPackageName, String instrumentationRunner, String outManifestLocation) {
        TestManifestGenerator generator = new TestManifestGenerator(outManifestLocation, testPackageName, minSdkVersion, targetSdkVersion, testedPackageName, instrumentationRunner);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    private Map<String, String> getAttributeInjectionMap(int versionCode, @Nullable String versionName, int minSdkVersion, int targetSdkVersion) {
        HashMap attributeInjection = Maps.newHashMap();
        if (versionCode != -1) {
            attributeInjection.put("/manifest|http://schemas.android.com/apk/res/android versionCode", Integer.toString(versionCode));
        }
        if (versionName != null) {
            attributeInjection.put("/manifest|http://schemas.android.com/apk/res/android versionName", versionName);
        }
        if (minSdkVersion != -1) {
            attributeInjection.put("/manifest/uses-sdk|http://schemas.android.com/apk/res/android minSdkVersion", Integer.toString(minSdkVersion));
        }
        if (targetSdkVersion != -1) {
            attributeInjection.put("/manifest/uses-sdk|http://schemas.android.com/apk/res/android targetSdkVersion", Integer.toString(targetSdkVersion));
        }
        return attributeInjection;
    }

    private void mergeLibraryManifests(File mainManifest, Iterable<? extends ManifestDependency> directLibraries, File outManifest, Map<String, String> attributeInjection, String packageOverride) throws IOException {
        ArrayList manifests = Lists.newArrayList();
        for (ManifestDependency manifestDependency : directLibraries) {
            List<? extends ManifestDependency> subLibraries = manifestDependency.getManifestDependencies();
            if (subLibraries.isEmpty()) {
                manifests.add(manifestDependency.getManifest());
                continue;
            }
            File mergeLibManifest = File.createTempFile("manifestMerge", ".xml");
            mergeLibManifest.deleteOnExit();
            this.mergeLibraryManifests(manifestDependency.getManifest(), subLibraries, mergeLibManifest, null, null);
            manifests.add(mergeLibManifest);
        }
        ManifestMerger merger = new ManifestMerger(MergerLog.wrapSdkLog((ILogger)this.mLogger), null);
        this.doMerge(merger, outManifest, mainManifest, manifests, attributeInjection, packageOverride);
    }

    private void doMerge(ManifestMerger merger, File output, File input, Map<String, String> injectionMap, String packageOverride) {
        List<File> list = Collections.emptyList();
        this.doMerge(merger, output, input, list, injectionMap, packageOverride);
    }

    private void doMerge(ManifestMerger merger, File output, File input, List<File> subManifests, Map<String, String> injectionMap, String packageOverride) {
        if (!merger.process(output, input, subManifests.toArray(new File[subManifests.size()]), injectionMap, packageOverride)) {
            throw new RuntimeException();
        }
    }

    public void processResources(@NonNull File manifestFile, @NonNull File resFolder, @Nullable File assetsDir, @NonNull List<? extends SymbolFileProvider> libraries, @Nullable String packageForR, @Nullable String sourceOutputDir, @Nullable String symbolOutputDir, @Nullable String resPackageOutput, @Nullable String proguardOutput, VariantConfiguration.Type type, boolean debuggable, @NonNull AaptOptions options) throws IOException, InterruptedException {
        List<String> noCompressList;
        String ignoreAssets;
        Preconditions.checkNotNull((Object)manifestFile, (Object)"manifestFile cannot be null.");
        Preconditions.checkNotNull((Object)resFolder, (Object)"resFolder cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)options, (Object)"options cannot be null.");
        Preconditions.checkArgument((sourceOutputDir != null || resPackageOutput != null ? 1 : 0) != 0, (Object)"No output provided for aapt task");
        ArrayList command = Lists.newArrayList();
        String aapt = this.mBuildTools.getPath(BuildToolInfo.PathId.AAPT);
        if (aapt == null || !new File(aapt).isFile()) {
            throw new IllegalStateException("aapt is missing");
        }
        command.add(aapt);
        command.add("package");
        if (this.mVerboseExec) {
            command.add("-v");
        }
        command.add("-f");
        command.add("--no-crunch");
        command.add("-I");
        command.add(this.mTarget.getPath(1));
        command.add("-M");
        command.add(manifestFile.getAbsolutePath());
        if (resFolder.isDirectory()) {
            command.add("-S");
            command.add(resFolder.getAbsolutePath());
        }
        if (assetsDir != null && assetsDir.isDirectory()) {
            command.add("-A");
            command.add(assetsDir.getAbsolutePath());
        }
        if (sourceOutputDir != null) {
            command.add("-m");
            command.add("-J");
            command.add(sourceOutputDir);
        }
        if (type != VariantConfiguration.Type.LIBRARY && resPackageOutput != null) {
            command.add("-F");
            command.add(resPackageOutput);
            if (proguardOutput != null) {
                command.add("-G");
                command.add(proguardOutput);
            }
        }
        if (debuggable) {
            command.add("--debug-mode");
        }
        if (type == VariantConfiguration.Type.DEFAULT && packageForR != null) {
            command.add("--custom-package");
            command.add(packageForR);
            this.mLogger.verbose("Custom package for R class: '%s'", new Object[]{packageForR});
        }
        if (type == VariantConfiguration.Type.LIBRARY) {
            command.add("--non-constant-id");
        }
        if ((ignoreAssets = options.getIgnoreAssets()) != null) {
            command.add("---ignore-assets");
            command.add(ignoreAssets);
        }
        if ((noCompressList = options.getNoCompress()) != null) {
            for (String noCompress : noCompressList) {
                command.add("-0");
                command.add(noCompress);
            }
        }
        if (!(symbolOutputDir == null || type != VariantConfiguration.Type.LIBRARY && libraries.isEmpty())) {
            command.add("--output-text-symbols");
            command.add(symbolOutputDir);
        }
        this.mCmdLineRunner.runCmdLine((List)command);
        if (type != VariantConfiguration.Type.LIBRARY && !libraries.isEmpty()) {
            SymbolLoader fullSymbolValues = null;
            String appPackageName = packageForR;
            if (appPackageName == null) {
                appPackageName = VariantConfiguration.getManifestPackage(manifestFile);
            }
            ArrayListMultimap libMap = ArrayListMultimap.create();
            for (SymbolFileProvider symbolFileProvider : libraries) {
                String packageName;
                File rFile = symbolFileProvider.getSymbolFile();
                if (!rFile.isFile() || appPackageName.equals(packageName = VariantConfiguration.getManifestPackage(symbolFileProvider.getManifest()))) continue;
                if (fullSymbolValues == null) {
                    fullSymbolValues = new SymbolLoader(new File(symbolOutputDir, "R.txt"), this.mLogger);
                    fullSymbolValues.load();
                }
                SymbolLoader libSymbols = new SymbolLoader(rFile, this.mLogger);
                libSymbols.load();
                libMap.put((Object)packageName, (Object)libSymbols);
            }
            for (String string : libMap.keySet()) {
                Collection symbols = libMap.get((Object)string);
                SymbolWriter writer = new SymbolWriter(sourceOutputDir, string, fullSymbolValues);
                for (SymbolLoader symbolLoader : symbols) {
                    writer.addSymbolsToWrite(symbolLoader);
                }
                writer.write();
            }
        }
    }

    public void compileAllAidlFiles(@NonNull List<File> sourceFolders, @NonNull File sourceOutputDir, @NonNull List<File> importFolders, @Nullable DependencyFileProcessor dependencyFileProcessor) throws IOException, InterruptedException, ExecutionException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        String aidl = this.mBuildTools.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        ArrayList fullImportList = Lists.newArrayListWithCapacity((int)(sourceFolders.size() + importFolders.size()));
        fullImportList.addAll(sourceFolders);
        fullImportList.addAll(importFolders);
        AidlProcessor processor = new AidlProcessor(aidl, this.mTarget.getPath(2), fullImportList, sourceOutputDir, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mCmdLineRunner);
        SourceSearcher searcher = new SourceSearcher(sourceFolders, "aidl");
        searcher.setUseExecutor(true);
        searcher.search(processor);
    }

    public void compileAidlFile(@NonNull File aidlFile, @NonNull File sourceOutputDir, @NonNull List<File> importFolders, @Nullable DependencyFileProcessor dependencyFileProcessor) throws IOException, InterruptedException {
        Preconditions.checkNotNull((Object)aidlFile, (Object)"aidlFile cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        String aidl = this.mBuildTools.getPath(BuildToolInfo.PathId.AIDL);
        if (aidl == null || !new File(aidl).isFile()) {
            throw new IllegalStateException("aidl is missing");
        }
        AidlProcessor processor = new AidlProcessor(aidl, this.mTarget.getPath(2), importFolders, sourceOutputDir, dependencyFileProcessor != null ? dependencyFileProcessor : sNoOpDependencyFileProcessor, this.mCmdLineRunner);
        processor.processFile(aidlFile);
    }

    public void compileAllRenderscriptFiles(@NonNull List<File> sourceFolders, @NonNull List<File> importFolders, @NonNull File sourceOutputDir, @NonNull File resOutputDir, int targetApi, boolean debugBuild, int optimLevel) throws IOException, InterruptedException, ExecutionException {
        Preconditions.checkNotNull(sourceFolders, (Object)"sourceFolders cannot be null.");
        Preconditions.checkNotNull(importFolders, (Object)"importFolders cannot be null.");
        Preconditions.checkNotNull((Object)sourceOutputDir, (Object)"sourceOutputDir cannot be null.");
        Preconditions.checkNotNull((Object)resOutputDir, (Object)"resOutputDir cannot be null.");
        String renderscript = this.mBuildTools.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (renderscript == null || !new File(renderscript).isFile()) {
            throw new IllegalStateException("llvm-rs-cc is missing");
        }
        FileGatherer fileGatherer = new FileGatherer();
        SourceSearcher searcher = new SourceSearcher(sourceFolders, "rs", "fs");
        searcher.setUseExecutor(false);
        searcher.search(fileGatherer);
        List<File> renderscriptFiles = fileGatherer.getFiles();
        if (renderscriptFiles.isEmpty()) {
            return;
        }
        String rsPath = this.mBuildTools.getPath(BuildToolInfo.PathId.ANDROID_RS);
        String rsClangPath = this.mBuildTools.getPath(BuildToolInfo.PathId.ANDROID_RS_CLANG);
        File rawFolder = new File(resOutputDir, "raw");
        ArrayList command = Lists.newArrayList();
        command.add(renderscript);
        if (debugBuild) {
            command.add("-g");
        }
        command.add("-O");
        command.add(Integer.toString(optimLevel));
        command.add("-I");
        command.add(rsPath);
        command.add("-I");
        command.add(rsClangPath);
        for (File importPath : importFolders) {
            if (!importPath.isDirectory()) continue;
            command.add("-I");
            command.add(importPath.getAbsolutePath());
        }
        command.add("-p");
        command.add(sourceOutputDir.getAbsolutePath());
        command.add("-o");
        command.add(rawFolder.getAbsolutePath());
        command.add("-target-api");
        command.add(Integer.toString(targetApi < 11 ? 11 : targetApi));
        for (File sourceFile : renderscriptFiles) {
            command.add(sourceFile.getAbsolutePath());
        }
        this.mCmdLineRunner.runCmdLine((List)command);
    }

    @NonNull
    public List<File> getLeafFolders(@NonNull String extension, List<File> ... importFolders) {
        ArrayList results = Lists.newArrayList();
        if (importFolders != null) {
            for (List<File> folders : importFolders) {
                SourceSearcher searcher = new SourceSearcher(folders, extension);
                searcher.setUseExecutor(false);
                LeafFolderGatherer processor = new LeafFolderGatherer();
                try {
                    searcher.search(processor);
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                results.addAll(processor.getFolders());
            }
        }
        return results;
    }

    public void convertByteCode(@NonNull Iterable<File> classesLocation, @NonNull Iterable<File> libraries, @Nullable File proguardFile, @NonNull String outDexFile, @NonNull DexOptions dexOptions, boolean incremental) throws IOException, InterruptedException {
        Preconditions.checkNotNull(classesLocation, (Object)"classesLocation cannot be null.");
        Preconditions.checkNotNull(libraries, (Object)"libraries cannot be null.");
        Preconditions.checkNotNull((Object)outDexFile, (Object)"outDexFile cannot be null.");
        Preconditions.checkNotNull((Object)dexOptions, (Object)"dexOptions cannot be null.");
        ArrayList command = Lists.newArrayList();
        String dx = this.mBuildTools.getPath(BuildToolInfo.PathId.DX);
        if (dx == null || !new File(dx).isFile()) {
            throw new IllegalStateException("dx is missing");
        }
        command.add(dx);
        command.add("--dex");
        if (this.mVerboseExec) {
            command.add("--verbose");
        }
        if (dexOptions.isCoreLibrary()) {
            command.add("--core-library");
        }
        if (incremental) {
            command.add("--incremental");
            command.add("--no-strict");
        }
        command.add("--output");
        command.add(outDexFile);
        ArrayList classesList = Lists.newArrayList();
        for (File f : classesLocation) {
            if (f == null || !f.exists()) continue;
            classesList.add(f.getAbsolutePath());
        }
        if (!classesList.isEmpty()) {
            this.mLogger.verbose("Dex class inputs: " + classesList, new Object[0]);
            command.addAll(classesList);
        }
        ArrayList libraryList = Lists.newArrayList();
        for (File f : libraries) {
            if (f == null || !f.exists()) continue;
            libraryList.add(f.getAbsolutePath());
        }
        if (!libraryList.isEmpty()) {
            this.mLogger.verbose("Dex library inputs: " + libraryList, new Object[0]);
            command.addAll(libraryList);
        }
        if (proguardFile != null && proguardFile.exists()) {
            this.mLogger.verbose("ProGuarded inputs " + proguardFile, new Object[0]);
            command.add(proguardFile.getAbsolutePath());
        }
        this.mCmdLineRunner.runCmdLine((List)command);
    }

    public void packageApk(@NonNull String androidResPkgLocation, @NonNull String classesDexLocation, @NonNull List<File> packagedJars, @Nullable String javaResourcesLocation, @Nullable String jniLibsLocation, boolean jniDebugBuild, @Nullable SigningConfig signingConfig, @NonNull String outApkLocation) throws DuplicateFileException, FileNotFoundException, KeytoolException, PackagerException, SigningException {
        Preconditions.checkNotNull((Object)androidResPkgLocation, (Object)"androidResPkgLocation cannot be null.");
        Preconditions.checkNotNull((Object)classesDexLocation, (Object)"classesDexLocation cannot be null.");
        Preconditions.checkNotNull((Object)outApkLocation, (Object)"outApkLocation cannot be null.");
        CertificateInfo certificateInfo = null;
        if (signingConfig != null && signingConfig.isSigningReady() && (certificateInfo = KeystoreHelper.getCertificateInfo(signingConfig)) == null) {
            throw new SigningException("Failed to read key from keystore", new Object[0]);
        }
        try {
            Packager packager = new Packager(outApkLocation, androidResPkgLocation, classesDexLocation, certificateInfo, this.mCreatedBy, this.mLogger);
            packager.setJniDebugMode(jniDebugBuild);
            JavaResourceProcessor resProcessor = new JavaResourceProcessor(packager);
            if (javaResourcesLocation != null) {
                resProcessor.addSourceFolder(javaResourcesLocation);
            }
            for (File jar : packagedJars) {
                packager.addResourcesFromJar(jar);
            }
            if (jniLibsLocation != null) {
                packager.addNativeLibraries(jniLibsLocation);
            }
            packager.sealApk();
        }
        catch (SealedPackageException e) {
            throw new RuntimeException(e);
        }
    }
}

