/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transcribe.model.InputType;
import com.amazonaws.services.transcribe.model.Rule;
import com.amazonaws.services.transcribe.model.transform.CategoryPropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CategoryProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String categoryName;
    private List<Rule> rules;
    private Date createTime;
    private Date lastUpdateTime;
    private String inputType;

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public CategoryProperties withCategoryName(String categoryName) {
        this.setCategoryName(categoryName);
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<Rule>(rules);
    }

    public CategoryProperties withRules(Rule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<Rule>(rules.length));
        }
        for (Rule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public CategoryProperties withRules(Collection<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public CategoryProperties withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public CategoryProperties withLastUpdateTime(Date lastUpdateTime) {
        this.setLastUpdateTime(lastUpdateTime);
        return this;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getInputType() {
        return this.inputType;
    }

    public CategoryProperties withInputType(String inputType) {
        this.setInputType(inputType);
        return this;
    }

    public CategoryProperties withInputType(InputType inputType) {
        this.inputType = inputType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCategoryName() != null) {
            sb.append("CategoryName: ").append(this.getCategoryName()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getLastUpdateTime() != null) {
            sb.append("LastUpdateTime: ").append(this.getLastUpdateTime()).append(",");
        }
        if (this.getInputType() != null) {
            sb.append("InputType: ").append(this.getInputType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryProperties)) {
            return false;
        }
        CategoryProperties other = (CategoryProperties)obj;
        if (other.getCategoryName() == null ^ this.getCategoryName() == null) {
            return false;
        }
        if (other.getCategoryName() != null && !other.getCategoryName().equals(this.getCategoryName())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getLastUpdateTime() == null ^ this.getLastUpdateTime() == null) {
            return false;
        }
        if (other.getLastUpdateTime() != null && !other.getLastUpdateTime().equals(this.getLastUpdateTime())) {
            return false;
        }
        if (other.getInputType() == null ^ this.getInputType() == null) {
            return false;
        }
        return other.getInputType() == null || other.getInputType().equals(this.getInputType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCategoryName() == null ? 0 : this.getCategoryName().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdateTime() == null ? 0 : this.getLastUpdateTime().hashCode());
        hashCode = 31 * hashCode + (this.getInputType() == null ? 0 : this.getInputType().hashCode());
        return hashCode;
    }

    public CategoryProperties clone() {
        try {
            return (CategoryProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CategoryPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

