/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamwrite.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.timestreamwrite.model.S3EncryptionOption;
import com.amazonaws.services.timestreamwrite.model.transform.ReportS3ConfigurationMarshaller;
import java.io.Serializable;

public class ReportS3Configuration
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketName;
    private String objectKeyPrefix;
    private String encryptionOption;
    private String kmsKeyId;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public ReportS3Configuration withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setObjectKeyPrefix(String objectKeyPrefix) {
        this.objectKeyPrefix = objectKeyPrefix;
    }

    public String getObjectKeyPrefix() {
        return this.objectKeyPrefix;
    }

    public ReportS3Configuration withObjectKeyPrefix(String objectKeyPrefix) {
        this.setObjectKeyPrefix(objectKeyPrefix);
        return this;
    }

    public void setEncryptionOption(String encryptionOption) {
        this.encryptionOption = encryptionOption;
    }

    public String getEncryptionOption() {
        return this.encryptionOption;
    }

    public ReportS3Configuration withEncryptionOption(String encryptionOption) {
        this.setEncryptionOption(encryptionOption);
        return this;
    }

    public ReportS3Configuration withEncryptionOption(S3EncryptionOption encryptionOption) {
        this.encryptionOption = encryptionOption.toString();
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public ReportS3Configuration withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getObjectKeyPrefix() != null) {
            sb.append("ObjectKeyPrefix: ").append(this.getObjectKeyPrefix()).append(",");
        }
        if (this.getEncryptionOption() != null) {
            sb.append("EncryptionOption: ").append(this.getEncryptionOption()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportS3Configuration)) {
            return false;
        }
        ReportS3Configuration other = (ReportS3Configuration)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getObjectKeyPrefix() == null ^ this.getObjectKeyPrefix() == null) {
            return false;
        }
        if (other.getObjectKeyPrefix() != null && !other.getObjectKeyPrefix().equals(this.getObjectKeyPrefix())) {
            return false;
        }
        if (other.getEncryptionOption() == null ^ this.getEncryptionOption() == null) {
            return false;
        }
        if (other.getEncryptionOption() != null && !other.getEncryptionOption().equals(this.getEncryptionOption())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        return other.getKmsKeyId() == null || other.getKmsKeyId().equals(this.getKmsKeyId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getObjectKeyPrefix() == null ? 0 : this.getObjectKeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionOption() == null ? 0 : this.getEncryptionOption().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        return hashCode;
    }

    public ReportS3Configuration clone() {
        try {
            return (ReportS3Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReportS3ConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

