/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.textract.model.ExpenseDocument;
import java.util.List;

@SdkInternalApi
public class ExpenseDocumentMarshaller {
    private static final MarshallingInfo<Integer> EXPENSEINDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpenseIndex").build();
    private static final MarshallingInfo<List> SUMMARYFIELDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SummaryFields").build();
    private static final MarshallingInfo<List> LINEITEMGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LineItemGroups").build();
    private static final MarshallingInfo<List> BLOCKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Blocks").build();
    private static final ExpenseDocumentMarshaller instance = new ExpenseDocumentMarshaller();

    public static ExpenseDocumentMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExpenseDocument expenseDocument, ProtocolMarshaller protocolMarshaller) {
        if (expenseDocument == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)expenseDocument.getExpenseIndex(), EXPENSEINDEX_BINDING);
            protocolMarshaller.marshall(expenseDocument.getSummaryFields(), SUMMARYFIELDS_BINDING);
            protocolMarshaller.marshall(expenseDocument.getLineItemGroups(), LINEITEMGROUPS_BINDING);
            protocolMarshaller.marshall(expenseDocument.getBlocks(), BLOCKS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

