/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.storagegateway.model.RetentionLockType;
import com.amazonaws.services.storagegateway.model.Tag;
import com.amazonaws.services.storagegateway.model.TapeStorageClass;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateTapePoolRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String poolName;
    private String storageClass;
    private String retentionLockType;
    private Integer retentionLockTimeInDays;
    private SdkInternalList<Tag> tags;

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public CreateTapePoolRequest withPoolName(String poolName) {
        this.setPoolName(poolName);
        return this;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public CreateTapePoolRequest withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public CreateTapePoolRequest withStorageClass(TapeStorageClass storageClass) {
        this.storageClass = storageClass.toString();
        return this;
    }

    public void setRetentionLockType(String retentionLockType) {
        this.retentionLockType = retentionLockType;
    }

    public String getRetentionLockType() {
        return this.retentionLockType;
    }

    public CreateTapePoolRequest withRetentionLockType(String retentionLockType) {
        this.setRetentionLockType(retentionLockType);
        return this;
    }

    public CreateTapePoolRequest withRetentionLockType(RetentionLockType retentionLockType) {
        this.retentionLockType = retentionLockType.toString();
        return this;
    }

    public void setRetentionLockTimeInDays(Integer retentionLockTimeInDays) {
        this.retentionLockTimeInDays = retentionLockTimeInDays;
    }

    public Integer getRetentionLockTimeInDays() {
        return this.retentionLockTimeInDays;
    }

    public CreateTapePoolRequest withRetentionLockTimeInDays(Integer retentionLockTimeInDays) {
        this.setRetentionLockTimeInDays(retentionLockTimeInDays);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateTapePoolRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateTapePoolRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPoolName() != null) {
            sb.append("PoolName: ").append(this.getPoolName()).append(",");
        }
        if (this.getStorageClass() != null) {
            sb.append("StorageClass: ").append(this.getStorageClass()).append(",");
        }
        if (this.getRetentionLockType() != null) {
            sb.append("RetentionLockType: ").append(this.getRetentionLockType()).append(",");
        }
        if (this.getRetentionLockTimeInDays() != null) {
            sb.append("RetentionLockTimeInDays: ").append(this.getRetentionLockTimeInDays()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTapePoolRequest)) {
            return false;
        }
        CreateTapePoolRequest other = (CreateTapePoolRequest)obj;
        if (other.getPoolName() == null ^ this.getPoolName() == null) {
            return false;
        }
        if (other.getPoolName() != null && !other.getPoolName().equals(this.getPoolName())) {
            return false;
        }
        if (other.getStorageClass() == null ^ this.getStorageClass() == null) {
            return false;
        }
        if (other.getStorageClass() != null && !other.getStorageClass().equals(this.getStorageClass())) {
            return false;
        }
        if (other.getRetentionLockType() == null ^ this.getRetentionLockType() == null) {
            return false;
        }
        if (other.getRetentionLockType() != null && !other.getRetentionLockType().equals(this.getRetentionLockType())) {
            return false;
        }
        if (other.getRetentionLockTimeInDays() == null ^ this.getRetentionLockTimeInDays() == null) {
            return false;
        }
        if (other.getRetentionLockTimeInDays() != null && !other.getRetentionLockTimeInDays().equals(this.getRetentionLockTimeInDays())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPoolName() == null ? 0 : this.getPoolName().hashCode());
        hashCode = 31 * hashCode + (this.getStorageClass() == null ? 0 : this.getStorageClass().hashCode());
        hashCode = 31 * hashCode + (this.getRetentionLockType() == null ? 0 : this.getRetentionLockType().hashCode());
        hashCode = 31 * hashCode + (this.getRetentionLockTimeInDays() == null ? 0 : this.getRetentionLockTimeInDays().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateTapePoolRequest clone() {
        return (CreateTapePoolRequest)super.clone();
    }
}

