/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.serverlessapplicationrepository.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.serverlessapplicationrepository.model.RollbackTrigger;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.RollbackConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RollbackConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer monitoringTimeInMinutes;
    private List<RollbackTrigger> rollbackTriggers;

    public void setMonitoringTimeInMinutes(Integer monitoringTimeInMinutes) {
        this.monitoringTimeInMinutes = monitoringTimeInMinutes;
    }

    public Integer getMonitoringTimeInMinutes() {
        return this.monitoringTimeInMinutes;
    }

    public RollbackConfiguration withMonitoringTimeInMinutes(Integer monitoringTimeInMinutes) {
        this.setMonitoringTimeInMinutes(monitoringTimeInMinutes);
        return this;
    }

    public List<RollbackTrigger> getRollbackTriggers() {
        return this.rollbackTriggers;
    }

    public void setRollbackTriggers(Collection<RollbackTrigger> rollbackTriggers) {
        if (rollbackTriggers == null) {
            this.rollbackTriggers = null;
            return;
        }
        this.rollbackTriggers = new ArrayList<RollbackTrigger>(rollbackTriggers);
    }

    public RollbackConfiguration withRollbackTriggers(RollbackTrigger ... rollbackTriggers) {
        if (this.rollbackTriggers == null) {
            this.setRollbackTriggers(new ArrayList<RollbackTrigger>(rollbackTriggers.length));
        }
        for (RollbackTrigger ele : rollbackTriggers) {
            this.rollbackTriggers.add(ele);
        }
        return this;
    }

    public RollbackConfiguration withRollbackTriggers(Collection<RollbackTrigger> rollbackTriggers) {
        this.setRollbackTriggers(rollbackTriggers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMonitoringTimeInMinutes() != null) {
            sb.append("MonitoringTimeInMinutes: ").append(this.getMonitoringTimeInMinutes()).append(",");
        }
        if (this.getRollbackTriggers() != null) {
            sb.append("RollbackTriggers: ").append(this.getRollbackTriggers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RollbackConfiguration)) {
            return false;
        }
        RollbackConfiguration other = (RollbackConfiguration)obj;
        if (other.getMonitoringTimeInMinutes() == null ^ this.getMonitoringTimeInMinutes() == null) {
            return false;
        }
        if (other.getMonitoringTimeInMinutes() != null && !other.getMonitoringTimeInMinutes().equals(this.getMonitoringTimeInMinutes())) {
            return false;
        }
        if (other.getRollbackTriggers() == null ^ this.getRollbackTriggers() == null) {
            return false;
        }
        return other.getRollbackTriggers() == null || other.getRollbackTriggers().equals(this.getRollbackTriggers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMonitoringTimeInMinutes() == null ? 0 : this.getMonitoringTimeInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getRollbackTriggers() == null ? 0 : this.getRollbackTriggers().hashCode());
        return hashCode;
    }

    public RollbackConfiguration clone() {
        try {
            return (RollbackConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RollbackConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

