/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.sagemaker.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Configures a hyperparameter tuning job.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/HyperParameterTuningJobConfig"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class HyperParameterTuningJobConfig implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job
     * it launches. For information about search strategies, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     * Hyperparameter Tuning Works</a>.
     * </p>
     */
    private String strategy;
    /**
     * <p>
     * The configuration for the <code>Hyperband</code> optimization strategy. This parameter should be provided only if
     * <code>Hyperband</code> is selected as the strategy for <code>HyperParameterTuningJobConfig</code>.
     * </p>
     */
    private HyperParameterTuningJobStrategyConfig strategyConfig;
    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html">
     * HyperParameterTuningJobObjective</a> specifies the objective metric used to evaluate the performance of training
     * jobs launched by this tuning job.
     * </p>
     */
    private HyperParameterTuningJobObjective hyperParameterTuningJobObjective;
    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html">ResourceLimits</a>
     * object that specifies the maximum number of training and parallel training jobs that can be used for this
     * hyperparameter tuning job.
     * </p>
     */
    private ResourceLimits resourceLimits;
    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html">ParameterRanges</a>
     * object that specifies the ranges of hyperparameters that this tuning job searches over to find the optimal
     * configuration for the highest model performance against your chosen objective metric.
     * </p>
     */
    private ParameterRanges parameterRanges;
    /**
     * <p>
     * Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job. Because the
     * <code>Hyperband</code> strategy has its own advanced internal early stopping mechanism,
     * <code>TrainingJobEarlyStoppingType</code> must be <code>OFF</code> to use <code>Hyperband</code>. This parameter
     * can take on one of the following values (the default value is <code>OFF</code>):
     * </p>
     * <dl>
     * <dt>OFF</dt>
     * <dd>
     * <p>
     * Training jobs launched by the hyperparameter tuning job do not use early stopping.
     * </p>
     * </dd>
     * <dt>AUTO</dt>
     * <dd>
     * <p>
     * SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform better
     * than previously completed training jobs. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop Training
     * Jobs Early</a>.
     * </p>
     * </dd>
     * </dl>
     */
    private String trainingJobEarlyStoppingType;
    /**
     * <p>
     * The tuning job's completion criteria.
     * </p>
     */
    private TuningJobCompletionCriteria tuningJobCompletionCriteria;
    /**
     * <p>
     * A value used to initialize a pseudo-random number generator. Setting a random seed and using the same seed later
     * for the same tuning job will allow hyperparameter optimization to find more a consistent hyperparameter
     * configuration between the two runs.
     * </p>
     */
    private Integer randomSeed;

    /**
     * <p>
     * Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job
     * it launches. For information about search strategies, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     * Hyperparameter Tuning Works</a>.
     * </p>
     * 
     * @param strategy
     *        Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the
     *        training job it launches. For information about search strategies, see <a
     *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     *        Hyperparameter Tuning Works</a>.
     * @see HyperParameterTuningJobStrategyType
     */

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    /**
     * <p>
     * Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job
     * it launches. For information about search strategies, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     * Hyperparameter Tuning Works</a>.
     * </p>
     * 
     * @return Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the
     *         training job it launches. For information about search strategies, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     *         Hyperparameter Tuning Works</a>.
     * @see HyperParameterTuningJobStrategyType
     */

    public String getStrategy() {
        return this.strategy;
    }

    /**
     * <p>
     * Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job
     * it launches. For information about search strategies, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     * Hyperparameter Tuning Works</a>.
     * </p>
     * 
     * @param strategy
     *        Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the
     *        training job it launches. For information about search strategies, see <a
     *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     *        Hyperparameter Tuning Works</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see HyperParameterTuningJobStrategyType
     */

    public HyperParameterTuningJobConfig withStrategy(String strategy) {
        setStrategy(strategy);
        return this;
    }

    /**
     * <p>
     * Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job
     * it launches. For information about search strategies, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     * Hyperparameter Tuning Works</a>.
     * </p>
     * 
     * @param strategy
     *        Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the
     *        training job it launches. For information about search strategies, see <a
     *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How
     *        Hyperparameter Tuning Works</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see HyperParameterTuningJobStrategyType
     */

    public HyperParameterTuningJobConfig withStrategy(HyperParameterTuningJobStrategyType strategy) {
        this.strategy = strategy.toString();
        return this;
    }

    /**
     * <p>
     * The configuration for the <code>Hyperband</code> optimization strategy. This parameter should be provided only if
     * <code>Hyperband</code> is selected as the strategy for <code>HyperParameterTuningJobConfig</code>.
     * </p>
     * 
     * @param strategyConfig
     *        The configuration for the <code>Hyperband</code> optimization strategy. This parameter should be provided
     *        only if <code>Hyperband</code> is selected as the strategy for <code>HyperParameterTuningJobConfig</code>.
     */

    public void setStrategyConfig(HyperParameterTuningJobStrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
    }

    /**
     * <p>
     * The configuration for the <code>Hyperband</code> optimization strategy. This parameter should be provided only if
     * <code>Hyperband</code> is selected as the strategy for <code>HyperParameterTuningJobConfig</code>.
     * </p>
     * 
     * @return The configuration for the <code>Hyperband</code> optimization strategy. This parameter should be provided
     *         only if <code>Hyperband</code> is selected as the strategy for <code>HyperParameterTuningJobConfig</code>
     *         .
     */

    public HyperParameterTuningJobStrategyConfig getStrategyConfig() {
        return this.strategyConfig;
    }

    /**
     * <p>
     * The configuration for the <code>Hyperband</code> optimization strategy. This parameter should be provided only if
     * <code>Hyperband</code> is selected as the strategy for <code>HyperParameterTuningJobConfig</code>.
     * </p>
     * 
     * @param strategyConfig
     *        The configuration for the <code>Hyperband</code> optimization strategy. This parameter should be provided
     *        only if <code>Hyperband</code> is selected as the strategy for <code>HyperParameterTuningJobConfig</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public HyperParameterTuningJobConfig withStrategyConfig(HyperParameterTuningJobStrategyConfig strategyConfig) {
        setStrategyConfig(strategyConfig);
        return this;
    }

    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html">
     * HyperParameterTuningJobObjective</a> specifies the objective metric used to evaluate the performance of training
     * jobs launched by this tuning job.
     * </p>
     * 
     * @param hyperParameterTuningJobObjective
     *        The <a href=
     *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html"
     *        >HyperParameterTuningJobObjective</a> specifies the objective metric used to evaluate the performance of
     *        training jobs launched by this tuning job.
     */

    public void setHyperParameterTuningJobObjective(HyperParameterTuningJobObjective hyperParameterTuningJobObjective) {
        this.hyperParameterTuningJobObjective = hyperParameterTuningJobObjective;
    }

    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html">
     * HyperParameterTuningJobObjective</a> specifies the objective metric used to evaluate the performance of training
     * jobs launched by this tuning job.
     * </p>
     * 
     * @return The <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html"
     *         >HyperParameterTuningJobObjective</a> specifies the objective metric used to evaluate the performance of
     *         training jobs launched by this tuning job.
     */

    public HyperParameterTuningJobObjective getHyperParameterTuningJobObjective() {
        return this.hyperParameterTuningJobObjective;
    }

    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html">
     * HyperParameterTuningJobObjective</a> specifies the objective metric used to evaluate the performance of training
     * jobs launched by this tuning job.
     * </p>
     * 
     * @param hyperParameterTuningJobObjective
     *        The <a href=
     *        "https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html"
     *        >HyperParameterTuningJobObjective</a> specifies the objective metric used to evaluate the performance of
     *        training jobs launched by this tuning job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public HyperParameterTuningJobConfig withHyperParameterTuningJobObjective(HyperParameterTuningJobObjective hyperParameterTuningJobObjective) {
        setHyperParameterTuningJobObjective(hyperParameterTuningJobObjective);
        return this;
    }

    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html">ResourceLimits</a>
     * object that specifies the maximum number of training and parallel training jobs that can be used for this
     * hyperparameter tuning job.
     * </p>
     * 
     * @param resourceLimits
     *        The <a
     *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html">ResourceLimits
     *        </a> object that specifies the maximum number of training and parallel training jobs that can be used for
     *        this hyperparameter tuning job.
     */

    public void setResourceLimits(ResourceLimits resourceLimits) {
        this.resourceLimits = resourceLimits;
    }

    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html">ResourceLimits</a>
     * object that specifies the maximum number of training and parallel training jobs that can be used for this
     * hyperparameter tuning job.
     * </p>
     * 
     * @return The <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html">ResourceLimits
     *         </a> object that specifies the maximum number of training and parallel training jobs that can be used for
     *         this hyperparameter tuning job.
     */

    public ResourceLimits getResourceLimits() {
        return this.resourceLimits;
    }

    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html">ResourceLimits</a>
     * object that specifies the maximum number of training and parallel training jobs that can be used for this
     * hyperparameter tuning job.
     * </p>
     * 
     * @param resourceLimits
     *        The <a
     *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html">ResourceLimits
     *        </a> object that specifies the maximum number of training and parallel training jobs that can be used for
     *        this hyperparameter tuning job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public HyperParameterTuningJobConfig withResourceLimits(ResourceLimits resourceLimits) {
        setResourceLimits(resourceLimits);
        return this;
    }

    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html">ParameterRanges</a>
     * object that specifies the ranges of hyperparameters that this tuning job searches over to find the optimal
     * configuration for the highest model performance against your chosen objective metric.
     * </p>
     * 
     * @param parameterRanges
     *        The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html">
     *        ParameterRanges</a> object that specifies the ranges of hyperparameters that this tuning job searches over
     *        to find the optimal configuration for the highest model performance against your chosen objective metric.
     */

    public void setParameterRanges(ParameterRanges parameterRanges) {
        this.parameterRanges = parameterRanges;
    }

    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html">ParameterRanges</a>
     * object that specifies the ranges of hyperparameters that this tuning job searches over to find the optimal
     * configuration for the highest model performance against your chosen objective metric.
     * </p>
     * 
     * @return The <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html">ParameterRanges
     *         </a> object that specifies the ranges of hyperparameters that this tuning job searches over to find the
     *         optimal configuration for the highest model performance against your chosen objective metric.
     */

    public ParameterRanges getParameterRanges() {
        return this.parameterRanges;
    }

    /**
     * <p>
     * The <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html">ParameterRanges</a>
     * object that specifies the ranges of hyperparameters that this tuning job searches over to find the optimal
     * configuration for the highest model performance against your chosen objective metric.
     * </p>
     * 
     * @param parameterRanges
     *        The <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html">
     *        ParameterRanges</a> object that specifies the ranges of hyperparameters that this tuning job searches over
     *        to find the optimal configuration for the highest model performance against your chosen objective metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public HyperParameterTuningJobConfig withParameterRanges(ParameterRanges parameterRanges) {
        setParameterRanges(parameterRanges);
        return this;
    }

    /**
     * <p>
     * Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job. Because the
     * <code>Hyperband</code> strategy has its own advanced internal early stopping mechanism,
     * <code>TrainingJobEarlyStoppingType</code> must be <code>OFF</code> to use <code>Hyperband</code>. This parameter
     * can take on one of the following values (the default value is <code>OFF</code>):
     * </p>
     * <dl>
     * <dt>OFF</dt>
     * <dd>
     * <p>
     * Training jobs launched by the hyperparameter tuning job do not use early stopping.
     * </p>
     * </dd>
     * <dt>AUTO</dt>
     * <dd>
     * <p>
     * SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform better
     * than previously completed training jobs. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop Training
     * Jobs Early</a>.
     * </p>
     * </dd>
     * </dl>
     * 
     * @param trainingJobEarlyStoppingType
     *        Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job.
     *        Because the <code>Hyperband</code> strategy has its own advanced internal early stopping mechanism,
     *        <code>TrainingJobEarlyStoppingType</code> must be <code>OFF</code> to use <code>Hyperband</code>. This
     *        parameter can take on one of the following values (the default value is <code>OFF</code>):</p>
     *        <dl>
     *        <dt>OFF</dt>
     *        <dd>
     *        <p>
     *        Training jobs launched by the hyperparameter tuning job do not use early stopping.
     *        </p>
     *        </dd>
     *        <dt>AUTO</dt>
     *        <dd>
     *        <p>
     *        SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform
     *        better than previously completed training jobs. For more information, see <a
     *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop
     *        Training Jobs Early</a>.
     *        </p>
     *        </dd>
     * @see TrainingJobEarlyStoppingType
     */

    public void setTrainingJobEarlyStoppingType(String trainingJobEarlyStoppingType) {
        this.trainingJobEarlyStoppingType = trainingJobEarlyStoppingType;
    }

    /**
     * <p>
     * Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job. Because the
     * <code>Hyperband</code> strategy has its own advanced internal early stopping mechanism,
     * <code>TrainingJobEarlyStoppingType</code> must be <code>OFF</code> to use <code>Hyperband</code>. This parameter
     * can take on one of the following values (the default value is <code>OFF</code>):
     * </p>
     * <dl>
     * <dt>OFF</dt>
     * <dd>
     * <p>
     * Training jobs launched by the hyperparameter tuning job do not use early stopping.
     * </p>
     * </dd>
     * <dt>AUTO</dt>
     * <dd>
     * <p>
     * SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform better
     * than previously completed training jobs. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop Training
     * Jobs Early</a>.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job.
     *         Because the <code>Hyperband</code> strategy has its own advanced internal early stopping mechanism,
     *         <code>TrainingJobEarlyStoppingType</code> must be <code>OFF</code> to use <code>Hyperband</code>. This
     *         parameter can take on one of the following values (the default value is <code>OFF</code>):</p>
     *         <dl>
     *         <dt>OFF</dt>
     *         <dd>
     *         <p>
     *         Training jobs launched by the hyperparameter tuning job do not use early stopping.
     *         </p>
     *         </dd>
     *         <dt>AUTO</dt>
     *         <dd>
     *         <p>
     *         SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform
     *         better than previously completed training jobs. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop
     *         Training Jobs Early</a>.
     *         </p>
     *         </dd>
     * @see TrainingJobEarlyStoppingType
     */

    public String getTrainingJobEarlyStoppingType() {
        return this.trainingJobEarlyStoppingType;
    }

    /**
     * <p>
     * Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job. Because the
     * <code>Hyperband</code> strategy has its own advanced internal early stopping mechanism,
     * <code>TrainingJobEarlyStoppingType</code> must be <code>OFF</code> to use <code>Hyperband</code>. This parameter
     * can take on one of the following values (the default value is <code>OFF</code>):
     * </p>
     * <dl>
     * <dt>OFF</dt>
     * <dd>
     * <p>
     * Training jobs launched by the hyperparameter tuning job do not use early stopping.
     * </p>
     * </dd>
     * <dt>AUTO</dt>
     * <dd>
     * <p>
     * SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform better
     * than previously completed training jobs. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop Training
     * Jobs Early</a>.
     * </p>
     * </dd>
     * </dl>
     * 
     * @param trainingJobEarlyStoppingType
     *        Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job.
     *        Because the <code>Hyperband</code> strategy has its own advanced internal early stopping mechanism,
     *        <code>TrainingJobEarlyStoppingType</code> must be <code>OFF</code> to use <code>Hyperband</code>. This
     *        parameter can take on one of the following values (the default value is <code>OFF</code>):</p>
     *        <dl>
     *        <dt>OFF</dt>
     *        <dd>
     *        <p>
     *        Training jobs launched by the hyperparameter tuning job do not use early stopping.
     *        </p>
     *        </dd>
     *        <dt>AUTO</dt>
     *        <dd>
     *        <p>
     *        SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform
     *        better than previously completed training jobs. For more information, see <a
     *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop
     *        Training Jobs Early</a>.
     *        </p>
     *        </dd>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TrainingJobEarlyStoppingType
     */

    public HyperParameterTuningJobConfig withTrainingJobEarlyStoppingType(String trainingJobEarlyStoppingType) {
        setTrainingJobEarlyStoppingType(trainingJobEarlyStoppingType);
        return this;
    }

    /**
     * <p>
     * Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job. Because the
     * <code>Hyperband</code> strategy has its own advanced internal early stopping mechanism,
     * <code>TrainingJobEarlyStoppingType</code> must be <code>OFF</code> to use <code>Hyperband</code>. This parameter
     * can take on one of the following values (the default value is <code>OFF</code>):
     * </p>
     * <dl>
     * <dt>OFF</dt>
     * <dd>
     * <p>
     * Training jobs launched by the hyperparameter tuning job do not use early stopping.
     * </p>
     * </dd>
     * <dt>AUTO</dt>
     * <dd>
     * <p>
     * SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform better
     * than previously completed training jobs. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop Training
     * Jobs Early</a>.
     * </p>
     * </dd>
     * </dl>
     * 
     * @param trainingJobEarlyStoppingType
     *        Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job.
     *        Because the <code>Hyperband</code> strategy has its own advanced internal early stopping mechanism,
     *        <code>TrainingJobEarlyStoppingType</code> must be <code>OFF</code> to use <code>Hyperband</code>. This
     *        parameter can take on one of the following values (the default value is <code>OFF</code>):</p>
     *        <dl>
     *        <dt>OFF</dt>
     *        <dd>
     *        <p>
     *        Training jobs launched by the hyperparameter tuning job do not use early stopping.
     *        </p>
     *        </dd>
     *        <dt>AUTO</dt>
     *        <dd>
     *        <p>
     *        SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform
     *        better than previously completed training jobs. For more information, see <a
     *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop
     *        Training Jobs Early</a>.
     *        </p>
     *        </dd>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TrainingJobEarlyStoppingType
     */

    public HyperParameterTuningJobConfig withTrainingJobEarlyStoppingType(TrainingJobEarlyStoppingType trainingJobEarlyStoppingType) {
        this.trainingJobEarlyStoppingType = trainingJobEarlyStoppingType.toString();
        return this;
    }

    /**
     * <p>
     * The tuning job's completion criteria.
     * </p>
     * 
     * @param tuningJobCompletionCriteria
     *        The tuning job's completion criteria.
     */

    public void setTuningJobCompletionCriteria(TuningJobCompletionCriteria tuningJobCompletionCriteria) {
        this.tuningJobCompletionCriteria = tuningJobCompletionCriteria;
    }

    /**
     * <p>
     * The tuning job's completion criteria.
     * </p>
     * 
     * @return The tuning job's completion criteria.
     */

    public TuningJobCompletionCriteria getTuningJobCompletionCriteria() {
        return this.tuningJobCompletionCriteria;
    }

    /**
     * <p>
     * The tuning job's completion criteria.
     * </p>
     * 
     * @param tuningJobCompletionCriteria
     *        The tuning job's completion criteria.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public HyperParameterTuningJobConfig withTuningJobCompletionCriteria(TuningJobCompletionCriteria tuningJobCompletionCriteria) {
        setTuningJobCompletionCriteria(tuningJobCompletionCriteria);
        return this;
    }

    /**
     * <p>
     * A value used to initialize a pseudo-random number generator. Setting a random seed and using the same seed later
     * for the same tuning job will allow hyperparameter optimization to find more a consistent hyperparameter
     * configuration between the two runs.
     * </p>
     * 
     * @param randomSeed
     *        A value used to initialize a pseudo-random number generator. Setting a random seed and using the same seed
     *        later for the same tuning job will allow hyperparameter optimization to find more a consistent
     *        hyperparameter configuration between the two runs.
     */

    public void setRandomSeed(Integer randomSeed) {
        this.randomSeed = randomSeed;
    }

    /**
     * <p>
     * A value used to initialize a pseudo-random number generator. Setting a random seed and using the same seed later
     * for the same tuning job will allow hyperparameter optimization to find more a consistent hyperparameter
     * configuration between the two runs.
     * </p>
     * 
     * @return A value used to initialize a pseudo-random number generator. Setting a random seed and using the same
     *         seed later for the same tuning job will allow hyperparameter optimization to find more a consistent
     *         hyperparameter configuration between the two runs.
     */

    public Integer getRandomSeed() {
        return this.randomSeed;
    }

    /**
     * <p>
     * A value used to initialize a pseudo-random number generator. Setting a random seed and using the same seed later
     * for the same tuning job will allow hyperparameter optimization to find more a consistent hyperparameter
     * configuration between the two runs.
     * </p>
     * 
     * @param randomSeed
     *        A value used to initialize a pseudo-random number generator. Setting a random seed and using the same seed
     *        later for the same tuning job will allow hyperparameter optimization to find more a consistent
     *        hyperparameter configuration between the two runs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public HyperParameterTuningJobConfig withRandomSeed(Integer randomSeed) {
        setRandomSeed(randomSeed);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStrategy() != null)
            sb.append("Strategy: ").append(getStrategy()).append(",");
        if (getStrategyConfig() != null)
            sb.append("StrategyConfig: ").append(getStrategyConfig()).append(",");
        if (getHyperParameterTuningJobObjective() != null)
            sb.append("HyperParameterTuningJobObjective: ").append(getHyperParameterTuningJobObjective()).append(",");
        if (getResourceLimits() != null)
            sb.append("ResourceLimits: ").append(getResourceLimits()).append(",");
        if (getParameterRanges() != null)
            sb.append("ParameterRanges: ").append(getParameterRanges()).append(",");
        if (getTrainingJobEarlyStoppingType() != null)
            sb.append("TrainingJobEarlyStoppingType: ").append(getTrainingJobEarlyStoppingType()).append(",");
        if (getTuningJobCompletionCriteria() != null)
            sb.append("TuningJobCompletionCriteria: ").append(getTuningJobCompletionCriteria()).append(",");
        if (getRandomSeed() != null)
            sb.append("RandomSeed: ").append(getRandomSeed());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof HyperParameterTuningJobConfig == false)
            return false;
        HyperParameterTuningJobConfig other = (HyperParameterTuningJobConfig) obj;
        if (other.getStrategy() == null ^ this.getStrategy() == null)
            return false;
        if (other.getStrategy() != null && other.getStrategy().equals(this.getStrategy()) == false)
            return false;
        if (other.getStrategyConfig() == null ^ this.getStrategyConfig() == null)
            return false;
        if (other.getStrategyConfig() != null && other.getStrategyConfig().equals(this.getStrategyConfig()) == false)
            return false;
        if (other.getHyperParameterTuningJobObjective() == null ^ this.getHyperParameterTuningJobObjective() == null)
            return false;
        if (other.getHyperParameterTuningJobObjective() != null
                && other.getHyperParameterTuningJobObjective().equals(this.getHyperParameterTuningJobObjective()) == false)
            return false;
        if (other.getResourceLimits() == null ^ this.getResourceLimits() == null)
            return false;
        if (other.getResourceLimits() != null && other.getResourceLimits().equals(this.getResourceLimits()) == false)
            return false;
        if (other.getParameterRanges() == null ^ this.getParameterRanges() == null)
            return false;
        if (other.getParameterRanges() != null && other.getParameterRanges().equals(this.getParameterRanges()) == false)
            return false;
        if (other.getTrainingJobEarlyStoppingType() == null ^ this.getTrainingJobEarlyStoppingType() == null)
            return false;
        if (other.getTrainingJobEarlyStoppingType() != null && other.getTrainingJobEarlyStoppingType().equals(this.getTrainingJobEarlyStoppingType()) == false)
            return false;
        if (other.getTuningJobCompletionCriteria() == null ^ this.getTuningJobCompletionCriteria() == null)
            return false;
        if (other.getTuningJobCompletionCriteria() != null && other.getTuningJobCompletionCriteria().equals(this.getTuningJobCompletionCriteria()) == false)
            return false;
        if (other.getRandomSeed() == null ^ this.getRandomSeed() == null)
            return false;
        if (other.getRandomSeed() != null && other.getRandomSeed().equals(this.getRandomSeed()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStrategy() == null) ? 0 : getStrategy().hashCode());
        hashCode = prime * hashCode + ((getStrategyConfig() == null) ? 0 : getStrategyConfig().hashCode());
        hashCode = prime * hashCode + ((getHyperParameterTuningJobObjective() == null) ? 0 : getHyperParameterTuningJobObjective().hashCode());
        hashCode = prime * hashCode + ((getResourceLimits() == null) ? 0 : getResourceLimits().hashCode());
        hashCode = prime * hashCode + ((getParameterRanges() == null) ? 0 : getParameterRanges().hashCode());
        hashCode = prime * hashCode + ((getTrainingJobEarlyStoppingType() == null) ? 0 : getTrainingJobEarlyStoppingType().hashCode());
        hashCode = prime * hashCode + ((getTuningJobCompletionCriteria() == null) ? 0 : getTuningJobCompletionCriteria().hashCode());
        hashCode = prime * hashCode + ((getRandomSeed() == null) ? 0 : getRandomSeed().hashCode());
        return hashCode;
    }

    @Override
    public HyperParameterTuningJobConfig clone() {
        try {
            return (HyperParameterTuningJobConfig) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.sagemaker.model.transform.HyperParameterTuningJobConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
