/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.AggFunction;
import com.amazonaws.services.quicksight.model.DisplayFormat;
import com.amazonaws.services.quicksight.model.DisplayFormatOptions;
import com.amazonaws.services.quicksight.model.Identifier;
import com.amazonaws.services.quicksight.model.NamedEntityRef;
import com.amazonaws.services.quicksight.model.TopicIRComparisonMethod;
import com.amazonaws.services.quicksight.model.transform.TopicIRMetricMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicIRMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private Identifier metricId;
    private AggFunction function;
    private List<Identifier> operands;
    private TopicIRComparisonMethod comparisonMethod;
    private String expression;
    private List<Identifier> calculatedFieldReferences;
    private String displayFormat;
    private DisplayFormatOptions displayFormatOptions;
    private NamedEntityRef namedEntity;

    public void setMetricId(Identifier metricId) {
        this.metricId = metricId;
    }

    public Identifier getMetricId() {
        return this.metricId;
    }

    public TopicIRMetric withMetricId(Identifier metricId) {
        this.setMetricId(metricId);
        return this;
    }

    public void setFunction(AggFunction function) {
        this.function = function;
    }

    public AggFunction getFunction() {
        return this.function;
    }

    public TopicIRMetric withFunction(AggFunction function) {
        this.setFunction(function);
        return this;
    }

    public List<Identifier> getOperands() {
        return this.operands;
    }

    public void setOperands(Collection<Identifier> operands) {
        if (operands == null) {
            this.operands = null;
            return;
        }
        this.operands = new ArrayList<Identifier>(operands);
    }

    public TopicIRMetric withOperands(Identifier ... operands) {
        if (this.operands == null) {
            this.setOperands(new ArrayList<Identifier>(operands.length));
        }
        for (Identifier ele : operands) {
            this.operands.add(ele);
        }
        return this;
    }

    public TopicIRMetric withOperands(Collection<Identifier> operands) {
        this.setOperands(operands);
        return this;
    }

    public void setComparisonMethod(TopicIRComparisonMethod comparisonMethod) {
        this.comparisonMethod = comparisonMethod;
    }

    public TopicIRComparisonMethod getComparisonMethod() {
        return this.comparisonMethod;
    }

    public TopicIRMetric withComparisonMethod(TopicIRComparisonMethod comparisonMethod) {
        this.setComparisonMethod(comparisonMethod);
        return this;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public TopicIRMetric withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public List<Identifier> getCalculatedFieldReferences() {
        return this.calculatedFieldReferences;
    }

    public void setCalculatedFieldReferences(Collection<Identifier> calculatedFieldReferences) {
        if (calculatedFieldReferences == null) {
            this.calculatedFieldReferences = null;
            return;
        }
        this.calculatedFieldReferences = new ArrayList<Identifier>(calculatedFieldReferences);
    }

    public TopicIRMetric withCalculatedFieldReferences(Identifier ... calculatedFieldReferences) {
        if (this.calculatedFieldReferences == null) {
            this.setCalculatedFieldReferences(new ArrayList<Identifier>(calculatedFieldReferences.length));
        }
        for (Identifier ele : calculatedFieldReferences) {
            this.calculatedFieldReferences.add(ele);
        }
        return this;
    }

    public TopicIRMetric withCalculatedFieldReferences(Collection<Identifier> calculatedFieldReferences) {
        this.setCalculatedFieldReferences(calculatedFieldReferences);
        return this;
    }

    public void setDisplayFormat(String displayFormat) {
        this.displayFormat = displayFormat;
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public TopicIRMetric withDisplayFormat(String displayFormat) {
        this.setDisplayFormat(displayFormat);
        return this;
    }

    public TopicIRMetric withDisplayFormat(DisplayFormat displayFormat) {
        this.displayFormat = displayFormat.toString();
        return this;
    }

    public void setDisplayFormatOptions(DisplayFormatOptions displayFormatOptions) {
        this.displayFormatOptions = displayFormatOptions;
    }

    public DisplayFormatOptions getDisplayFormatOptions() {
        return this.displayFormatOptions;
    }

    public TopicIRMetric withDisplayFormatOptions(DisplayFormatOptions displayFormatOptions) {
        this.setDisplayFormatOptions(displayFormatOptions);
        return this;
    }

    public void setNamedEntity(NamedEntityRef namedEntity) {
        this.namedEntity = namedEntity;
    }

    public NamedEntityRef getNamedEntity() {
        return this.namedEntity;
    }

    public TopicIRMetric withNamedEntity(NamedEntityRef namedEntity) {
        this.setNamedEntity(namedEntity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricId() != null) {
            sb.append("MetricId: ").append(this.getMetricId()).append(",");
        }
        if (this.getFunction() != null) {
            sb.append("Function: ").append(this.getFunction()).append(",");
        }
        if (this.getOperands() != null) {
            sb.append("Operands: ").append(this.getOperands()).append(",");
        }
        if (this.getComparisonMethod() != null) {
            sb.append("ComparisonMethod: ").append(this.getComparisonMethod()).append(",");
        }
        if (this.getExpression() != null) {
            sb.append("Expression: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCalculatedFieldReferences() != null) {
            sb.append("CalculatedFieldReferences: ").append(this.getCalculatedFieldReferences()).append(",");
        }
        if (this.getDisplayFormat() != null) {
            sb.append("DisplayFormat: ").append(this.getDisplayFormat()).append(",");
        }
        if (this.getDisplayFormatOptions() != null) {
            sb.append("DisplayFormatOptions: ").append(this.getDisplayFormatOptions()).append(",");
        }
        if (this.getNamedEntity() != null) {
            sb.append("NamedEntity: ").append(this.getNamedEntity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRMetric)) {
            return false;
        }
        TopicIRMetric other = (TopicIRMetric)obj;
        if (other.getMetricId() == null ^ this.getMetricId() == null) {
            return false;
        }
        if (other.getMetricId() != null && !other.getMetricId().equals(this.getMetricId())) {
            return false;
        }
        if (other.getFunction() == null ^ this.getFunction() == null) {
            return false;
        }
        if (other.getFunction() != null && !other.getFunction().equals(this.getFunction())) {
            return false;
        }
        if (other.getOperands() == null ^ this.getOperands() == null) {
            return false;
        }
        if (other.getOperands() != null && !other.getOperands().equals(this.getOperands())) {
            return false;
        }
        if (other.getComparisonMethod() == null ^ this.getComparisonMethod() == null) {
            return false;
        }
        if (other.getComparisonMethod() != null && !other.getComparisonMethod().equals(this.getComparisonMethod())) {
            return false;
        }
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        if (other.getExpression() != null && !other.getExpression().equals(this.getExpression())) {
            return false;
        }
        if (other.getCalculatedFieldReferences() == null ^ this.getCalculatedFieldReferences() == null) {
            return false;
        }
        if (other.getCalculatedFieldReferences() != null && !other.getCalculatedFieldReferences().equals(this.getCalculatedFieldReferences())) {
            return false;
        }
        if (other.getDisplayFormat() == null ^ this.getDisplayFormat() == null) {
            return false;
        }
        if (other.getDisplayFormat() != null && !other.getDisplayFormat().equals(this.getDisplayFormat())) {
            return false;
        }
        if (other.getDisplayFormatOptions() == null ^ this.getDisplayFormatOptions() == null) {
            return false;
        }
        if (other.getDisplayFormatOptions() != null && !other.getDisplayFormatOptions().equals(this.getDisplayFormatOptions())) {
            return false;
        }
        if (other.getNamedEntity() == null ^ this.getNamedEntity() == null) {
            return false;
        }
        return other.getNamedEntity() == null || other.getNamedEntity().equals(this.getNamedEntity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricId() == null ? 0 : this.getMetricId().hashCode());
        hashCode = 31 * hashCode + (this.getFunction() == null ? 0 : this.getFunction().hashCode());
        hashCode = 31 * hashCode + (this.getOperands() == null ? 0 : this.getOperands().hashCode());
        hashCode = 31 * hashCode + (this.getComparisonMethod() == null ? 0 : this.getComparisonMethod().hashCode());
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        hashCode = 31 * hashCode + (this.getCalculatedFieldReferences() == null ? 0 : this.getCalculatedFieldReferences().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayFormat() == null ? 0 : this.getDisplayFormat().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayFormatOptions() == null ? 0 : this.getDisplayFormatOptions().hashCode());
        hashCode = 31 * hashCode + (this.getNamedEntity() == null ? 0 : this.getNamedEntity().hashCode());
        return hashCode;
    }

    public TopicIRMetric clone() {
        try {
            return (TopicIRMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicIRMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

