/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model.transform;

import java.util.Map;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.quicksight.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * UpdateIpRestrictionRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateIpRestrictionRequestMarshaller {

    private static final MarshallingInfo<String> AWSACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH)
            .marshallLocationName("AwsAccountId").build();
    private static final MarshallingInfo<Map> IPRESTRICTIONRULEMAP_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpRestrictionRuleMap").build();
    private static final MarshallingInfo<Map> VPCIDRESTRICTIONRULEMAP_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcIdRestrictionRuleMap").build();
    private static final MarshallingInfo<Map> VPCENDPOINTIDRESTRICTIONRULEMAP_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcEndpointIdRestrictionRuleMap").build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Enabled").build();

    private static final UpdateIpRestrictionRequestMarshaller instance = new UpdateIpRestrictionRequestMarshaller();

    public static UpdateIpRestrictionRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateIpRestrictionRequest updateIpRestrictionRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateIpRestrictionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(updateIpRestrictionRequest.getAwsAccountId(), AWSACCOUNTID_BINDING);
            protocolMarshaller.marshall(updateIpRestrictionRequest.getIpRestrictionRuleMap(), IPRESTRICTIONRULEMAP_BINDING);
            protocolMarshaller.marshall(updateIpRestrictionRequest.getVpcIdRestrictionRuleMap(), VPCIDRESTRICTIONRULEMAP_BINDING);
            protocolMarshaller.marshall(updateIpRestrictionRequest.getVpcEndpointIdRestrictionRuleMap(), VPCENDPOINTIDRESTRICTIONRULEMAP_BINDING);
            protocolMarshaller.marshall(updateIpRestrictionRequest.getEnabled(), ENABLED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
