/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import javax.annotation.Generated;

/**
 * <p>
 * This resource is currently unavailable.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ResourceUnavailableException extends com.amazonaws.services.quicksight.model.AmazonQuickSightException {
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * The resource type for this request.
     * </p>
     */
    private String resourceType;
    /**
     * <p>
     * The Amazon Web Services request ID for this request.
     * </p>
     */
    private String requestId;

    /**
     * Constructs a new ResourceUnavailableException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public ResourceUnavailableException(String message) {
        super(message);
    }

    /**
     * <p>
     * The resource type for this request.
     * </p>
     * 
     * @param resourceType
     *        The resource type for this request.
     * @see ExceptionResourceType
     */

    @com.fasterxml.jackson.annotation.JsonProperty("ResourceType")
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * <p>
     * The resource type for this request.
     * </p>
     * 
     * @return The resource type for this request.
     * @see ExceptionResourceType
     */

    @com.fasterxml.jackson.annotation.JsonProperty("ResourceType")
    public String getResourceType() {
        return this.resourceType;
    }

    /**
     * <p>
     * The resource type for this request.
     * </p>
     * 
     * @param resourceType
     *        The resource type for this request.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ExceptionResourceType
     */

    public ResourceUnavailableException withResourceType(String resourceType) {
        setResourceType(resourceType);
        return this;
    }

    /**
     * <p>
     * The resource type for this request.
     * </p>
     * 
     * @param resourceType
     *        The resource type for this request.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ExceptionResourceType
     */

    public ResourceUnavailableException withResourceType(ExceptionResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this request.
     * </p>
     * 
     * @param requestId
     *        The Amazon Web Services request ID for this request.
     */

    @com.fasterxml.jackson.annotation.JsonProperty("RequestId")
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this request.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this request.
     */

    @com.fasterxml.jackson.annotation.JsonProperty("RequestId")
    public String getRequestId() {
        return this.requestId;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this request.
     * </p>
     * 
     * @param requestId
     *        The Amazon Web Services request ID for this request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResourceUnavailableException withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

}
