/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalize.model.transform.TrainingDataConfigMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrainingDataConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, List<String>> excludedDatasetColumns;

    public Map<String, List<String>> getExcludedDatasetColumns() {
        return this.excludedDatasetColumns;
    }

    public void setExcludedDatasetColumns(Map<String, List<String>> excludedDatasetColumns) {
        this.excludedDatasetColumns = excludedDatasetColumns;
    }

    public TrainingDataConfig withExcludedDatasetColumns(Map<String, List<String>> excludedDatasetColumns) {
        this.setExcludedDatasetColumns(excludedDatasetColumns);
        return this;
    }

    public TrainingDataConfig addExcludedDatasetColumnsEntry(String key, List<String> value) {
        if (null == this.excludedDatasetColumns) {
            this.excludedDatasetColumns = new HashMap<String, List<String>>();
        }
        if (this.excludedDatasetColumns.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.excludedDatasetColumns.put(key, value);
        return this;
    }

    public TrainingDataConfig clearExcludedDatasetColumnsEntries() {
        this.excludedDatasetColumns = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExcludedDatasetColumns() != null) {
            sb.append("ExcludedDatasetColumns: ").append(this.getExcludedDatasetColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataConfig)) {
            return false;
        }
        TrainingDataConfig other = (TrainingDataConfig)obj;
        if (other.getExcludedDatasetColumns() == null ^ this.getExcludedDatasetColumns() == null) {
            return false;
        }
        return other.getExcludedDatasetColumns() == null || other.getExcludedDatasetColumns().equals(this.getExcludedDatasetColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExcludedDatasetColumns() == null ? 0 : this.getExcludedDatasetColumns().hashCode());
        return hashCode;
    }

    public TrainingDataConfig clone() {
        try {
            return (TrainingDataConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrainingDataConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

