/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.KeySummary;

@SdkInternalApi
public class KeySummaryMarshaller {
    private static final MarshallingInfo<String> KEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyArn").build();
    private static final MarshallingInfo<String> KEYSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyState").build();
    private static final MarshallingInfo<StructuredPojo> KEYATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyAttributes").build();
    private static final MarshallingInfo<String> KEYCHECKVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyCheckValue").build();
    private static final MarshallingInfo<Boolean> EXPORTABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Exportable").build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final KeySummaryMarshaller instance = new KeySummaryMarshaller();

    public static KeySummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(KeySummary keySummary, ProtocolMarshaller protocolMarshaller) {
        if (keySummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)keySummary.getKeyArn(), KEYARN_BINDING);
            protocolMarshaller.marshall((Object)keySummary.getKeyState(), KEYSTATE_BINDING);
            protocolMarshaller.marshall((Object)keySummary.getKeyAttributes(), KEYATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)keySummary.getKeyCheckValue(), KEYCHECKVALUE_BINDING);
            protocolMarshaller.marshall((Object)keySummary.getExportable(), EXPORTABLE_BINDING);
            protocolMarshaller.marshall((Object)keySummary.getEnabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

