/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.paymentcryptography.model.ExportKeyCryptogram;

@SdkInternalApi
public class ExportKeyCryptogramMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEAUTHORITYPUBLICKEYIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateAuthorityPublicKeyIdentifier").build();
    private static final MarshallingInfo<String> WRAPPINGKEYCERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WrappingKeyCertificate").build();
    private static final MarshallingInfo<String> WRAPPINGSPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WrappingSpec").build();
    private static final ExportKeyCryptogramMarshaller instance = new ExportKeyCryptogramMarshaller();

    public static ExportKeyCryptogramMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExportKeyCryptogram exportKeyCryptogram, ProtocolMarshaller protocolMarshaller) {
        if (exportKeyCryptogram == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)exportKeyCryptogram.getCertificateAuthorityPublicKeyIdentifier(), CERTIFICATEAUTHORITYPUBLICKEYIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)exportKeyCryptogram.getWrappingKeyCertificate(), WRAPPINGKEYCERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)exportKeyCryptogram.getWrappingSpec(), WRAPPINGSPEC_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

