/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.organizations.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.organizations.model.PolicyTargetSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTargetsForPolicyResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PolicyTargetSummary> targets;
    private String nextToken;

    public List<PolicyTargetSummary> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<PolicyTargetSummary> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<PolicyTargetSummary>(targets);
    }

    public ListTargetsForPolicyResult withTargets(PolicyTargetSummary ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<PolicyTargetSummary>(targets.length));
        }
        for (PolicyTargetSummary ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public ListTargetsForPolicyResult withTargets(Collection<PolicyTargetSummary> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListTargetsForPolicyResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsForPolicyResult)) {
            return false;
        }
        ListTargetsForPolicyResult other = (ListTargetsForPolicyResult)obj;
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListTargetsForPolicyResult clone() {
        try {
            return (ListTargetsForPolicyResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

