/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.KeyValuePair;
import com.amazonaws.services.macie2.model.ServerSideEncryption;
import com.amazonaws.services.macie2.model.StorageClass;
import com.amazonaws.services.macie2.model.transform.S3ObjectMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class S3Object
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketArn;
    private String eTag;
    private String extension;
    private String key;
    private Date lastModified;
    private String path;
    private Boolean publicAccess;
    private ServerSideEncryption serverSideEncryption;
    private Long size;
    private String storageClass;
    private List<KeyValuePair> tags;
    private String versionId;

    public void setBucketArn(String bucketArn) {
        this.bucketArn = bucketArn;
    }

    public String getBucketArn() {
        return this.bucketArn;
    }

    public S3Object withBucketArn(String bucketArn) {
        this.setBucketArn(bucketArn);
        return this;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String getETag() {
        return this.eTag;
    }

    public S3Object withETag(String eTag) {
        this.setETag(eTag);
        return this;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public S3Object withExtension(String extension) {
        this.setExtension(extension);
        return this;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public S3Object withKey(String key) {
        this.setKey(key);
        return this;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public S3Object withLastModified(Date lastModified) {
        this.setLastModified(lastModified);
        return this;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public S3Object withPath(String path) {
        this.setPath(path);
        return this;
    }

    public void setPublicAccess(Boolean publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Boolean getPublicAccess() {
        return this.publicAccess;
    }

    public S3Object withPublicAccess(Boolean publicAccess) {
        this.setPublicAccess(publicAccess);
        return this;
    }

    public Boolean isPublicAccess() {
        return this.publicAccess;
    }

    public void setServerSideEncryption(ServerSideEncryption serverSideEncryption) {
        this.serverSideEncryption = serverSideEncryption;
    }

    public ServerSideEncryption getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public S3Object withServerSideEncryption(ServerSideEncryption serverSideEncryption) {
        this.setServerSideEncryption(serverSideEncryption);
        return this;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Long getSize() {
        return this.size;
    }

    public S3Object withSize(Long size) {
        this.setSize(size);
        return this;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public S3Object withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public S3Object withStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
        return this;
    }

    public List<KeyValuePair> getTags() {
        return this.tags;
    }

    public void setTags(Collection<KeyValuePair> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<KeyValuePair>(tags);
    }

    public S3Object withTags(KeyValuePair ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<KeyValuePair>(tags.length));
        }
        for (KeyValuePair ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public S3Object withTags(Collection<KeyValuePair> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public S3Object withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketArn() != null) {
            sb.append("BucketArn: ").append(this.getBucketArn()).append(",");
        }
        if (this.getETag() != null) {
            sb.append("ETag: ").append(this.getETag()).append(",");
        }
        if (this.getExtension() != null) {
            sb.append("Extension: ").append(this.getExtension()).append(",");
        }
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getLastModified() != null) {
            sb.append("LastModified: ").append(this.getLastModified()).append(",");
        }
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getPublicAccess() != null) {
            sb.append("PublicAccess: ").append(this.getPublicAccess()).append(",");
        }
        if (this.getServerSideEncryption() != null) {
            sb.append("ServerSideEncryption: ").append(this.getServerSideEncryption()).append(",");
        }
        if (this.getSize() != null) {
            sb.append("Size: ").append(this.getSize()).append(",");
        }
        if (this.getStorageClass() != null) {
            sb.append("StorageClass: ").append(this.getStorageClass()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVersionId() != null) {
            sb.append("VersionId: ").append(this.getVersionId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Object)) {
            return false;
        }
        S3Object other = (S3Object)obj;
        if (other.getBucketArn() == null ^ this.getBucketArn() == null) {
            return false;
        }
        if (other.getBucketArn() != null && !other.getBucketArn().equals(this.getBucketArn())) {
            return false;
        }
        if (other.getETag() == null ^ this.getETag() == null) {
            return false;
        }
        if (other.getETag() != null && !other.getETag().equals(this.getETag())) {
            return false;
        }
        if (other.getExtension() == null ^ this.getExtension() == null) {
            return false;
        }
        if (other.getExtension() != null && !other.getExtension().equals(this.getExtension())) {
            return false;
        }
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getLastModified() == null ^ this.getLastModified() == null) {
            return false;
        }
        if (other.getLastModified() != null && !other.getLastModified().equals(this.getLastModified())) {
            return false;
        }
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getPublicAccess() == null ^ this.getPublicAccess() == null) {
            return false;
        }
        if (other.getPublicAccess() != null && !other.getPublicAccess().equals(this.getPublicAccess())) {
            return false;
        }
        if (other.getServerSideEncryption() == null ^ this.getServerSideEncryption() == null) {
            return false;
        }
        if (other.getServerSideEncryption() != null && !other.getServerSideEncryption().equals(this.getServerSideEncryption())) {
            return false;
        }
        if (other.getSize() == null ^ this.getSize() == null) {
            return false;
        }
        if (other.getSize() != null && !other.getSize().equals(this.getSize())) {
            return false;
        }
        if (other.getStorageClass() == null ^ this.getStorageClass() == null) {
            return false;
        }
        if (other.getStorageClass() != null && !other.getStorageClass().equals(this.getStorageClass())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVersionId() == null ^ this.getVersionId() == null) {
            return false;
        }
        return other.getVersionId() == null || other.getVersionId().equals(this.getVersionId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketArn() == null ? 0 : this.getBucketArn().hashCode());
        hashCode = 31 * hashCode + (this.getETag() == null ? 0 : this.getETag().hashCode());
        hashCode = 31 * hashCode + (this.getExtension() == null ? 0 : this.getExtension().hashCode());
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getLastModified() == null ? 0 : this.getLastModified().hashCode());
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getPublicAccess() == null ? 0 : this.getPublicAccess().hashCode());
        hashCode = 31 * hashCode + (this.getServerSideEncryption() == null ? 0 : this.getServerSideEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getSize() == null ? 0 : this.getSize().hashCode());
        hashCode = 31 * hashCode + (this.getStorageClass() == null ? 0 : this.getStorageClass().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVersionId() == null ? 0 : this.getVersionId().hashCode());
        return hashCode;
    }

    public S3Object clone() {
        try {
            return (S3Object)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

