/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kinesisfirehose.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes an update for a destination in Amazon OpenSearch Service.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/AmazonopensearchserviceDestinationUpdate"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AmazonopensearchserviceDestinationUpdate implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Amazon OpenSearch
     * Service Configuration API and for indexing documents.
     * </p>
     */
    private String roleARN;
    /**
     * <p>
     * The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions for DescribeDomain,
     * DescribeDomains, and DescribeDomainConfig after assuming the IAM role specified in RoleARN.
     * </p>
     */
    private String domainARN;
    /**
     * <p>
     * The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the DomainARN
     * field.
     * </p>
     */
    private String clusterEndpoint;
    /**
     * <p>
     * The Amazon OpenSearch Service index name.
     * </p>
     */
    private String indexName;
    /**
     * <p>
     * The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can be only one type per index. If you try
     * to specify a new type for an existing index that already has another type, Firehose returns an error during
     * runtime.
     * </p>
     * <p>
     * If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Firehose still delivers data
     * to Elasticsearch with the old index name and type name. If you want to update your delivery stream with a new
     * index name, provide an empty string for TypeName.
     * </p>
     */
    private String typeName;
    /**
     * <p>
     * The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to IndexName to
     * facilitate the expiration of old data.
     * </p>
     */
    private String indexRotationPeriod;
    /**
     * <p>
     * The buffering options. If no value is specified, AmazonopensearchBufferingHints object default values are used.
     * </p>
     */
    private AmazonopensearchserviceBufferingHints bufferingHints;
    /**
     * <p>
     * The retry behavior in case Firehose is unable to deliver documents to Amazon OpenSearch Service. The default
     * value is 300 (5 minutes).
     * </p>
     */
    private AmazonopensearchserviceRetryOptions retryOptions;

    private S3DestinationUpdate s3Update;

    private ProcessingConfiguration processingConfiguration;

    private CloudWatchLoggingOptions cloudWatchLoggingOptions;
    /**
     * <p>
     * Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and
     * OpenSearch Service generated document ID.
     * </p>
     */
    private DocumentIdOptions documentIdOptions;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Amazon OpenSearch
     * Service Configuration API and for indexing documents.
     * </p>
     * 
     * @param roleARN
     *        The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Amazon OpenSearch
     *        Service Configuration API and for indexing documents.
     */

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Amazon OpenSearch
     * Service Configuration API and for indexing documents.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Amazon
     *         OpenSearch Service Configuration API and for indexing documents.
     */

    public String getRoleARN() {
        return this.roleARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Amazon OpenSearch
     * Service Configuration API and for indexing documents.
     * </p>
     * 
     * @param roleARN
     *        The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Amazon OpenSearch
     *        Service Configuration API and for indexing documents.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withRoleARN(String roleARN) {
        setRoleARN(roleARN);
        return this;
    }

    /**
     * <p>
     * The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions for DescribeDomain,
     * DescribeDomains, and DescribeDomainConfig after assuming the IAM role specified in RoleARN.
     * </p>
     * 
     * @param domainARN
     *        The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions for DescribeDomain,
     *        DescribeDomains, and DescribeDomainConfig after assuming the IAM role specified in RoleARN.
     */

    public void setDomainARN(String domainARN) {
        this.domainARN = domainARN;
    }

    /**
     * <p>
     * The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions for DescribeDomain,
     * DescribeDomains, and DescribeDomainConfig after assuming the IAM role specified in RoleARN.
     * </p>
     * 
     * @return The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions for DescribeDomain,
     *         DescribeDomains, and DescribeDomainConfig after assuming the IAM role specified in RoleARN.
     */

    public String getDomainARN() {
        return this.domainARN;
    }

    /**
     * <p>
     * The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions for DescribeDomain,
     * DescribeDomains, and DescribeDomainConfig after assuming the IAM role specified in RoleARN.
     * </p>
     * 
     * @param domainARN
     *        The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions for DescribeDomain,
     *        DescribeDomains, and DescribeDomainConfig after assuming the IAM role specified in RoleARN.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withDomainARN(String domainARN) {
        setDomainARN(domainARN);
        return this;
    }

    /**
     * <p>
     * The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the DomainARN
     * field.
     * </p>
     * 
     * @param clusterEndpoint
     *        The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the
     *        DomainARN field.
     */

    public void setClusterEndpoint(String clusterEndpoint) {
        this.clusterEndpoint = clusterEndpoint;
    }

    /**
     * <p>
     * The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the DomainARN
     * field.
     * </p>
     * 
     * @return The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the
     *         DomainARN field.
     */

    public String getClusterEndpoint() {
        return this.clusterEndpoint;
    }

    /**
     * <p>
     * The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the DomainARN
     * field.
     * </p>
     * 
     * @param clusterEndpoint
     *        The endpoint to use when communicating with the cluster. Specify either this ClusterEndpoint or the
     *        DomainARN field.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withClusterEndpoint(String clusterEndpoint) {
        setClusterEndpoint(clusterEndpoint);
        return this;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service index name.
     * </p>
     * 
     * @param indexName
     *        The Amazon OpenSearch Service index name.
     */

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service index name.
     * </p>
     * 
     * @return The Amazon OpenSearch Service index name.
     */

    public String getIndexName() {
        return this.indexName;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service index name.
     * </p>
     * 
     * @param indexName
     *        The Amazon OpenSearch Service index name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withIndexName(String indexName) {
        setIndexName(indexName);
        return this;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can be only one type per index. If you try
     * to specify a new type for an existing index that already has another type, Firehose returns an error during
     * runtime.
     * </p>
     * <p>
     * If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Firehose still delivers data
     * to Elasticsearch with the old index name and type name. If you want to update your delivery stream with a new
     * index name, provide an empty string for TypeName.
     * </p>
     * 
     * @param typeName
     *        The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can be only one type per index. If
     *        you try to specify a new type for an existing index that already has another type, Firehose returns an
     *        error during runtime. </p>
     *        <p>
     *        If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Firehose still
     *        delivers data to Elasticsearch with the old index name and type name. If you want to update your delivery
     *        stream with a new index name, provide an empty string for TypeName.
     */

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can be only one type per index. If you try
     * to specify a new type for an existing index that already has another type, Firehose returns an error during
     * runtime.
     * </p>
     * <p>
     * If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Firehose still delivers data
     * to Elasticsearch with the old index name and type name. If you want to update your delivery stream with a new
     * index name, provide an empty string for TypeName.
     * </p>
     * 
     * @return The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can be only one type per index. If
     *         you try to specify a new type for an existing index that already has another type, Firehose returns an
     *         error during runtime. </p>
     *         <p>
     *         If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Firehose still
     *         delivers data to Elasticsearch with the old index name and type name. If you want to update your delivery
     *         stream with a new index name, provide an empty string for TypeName.
     */

    public String getTypeName() {
        return this.typeName;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can be only one type per index. If you try
     * to specify a new type for an existing index that already has another type, Firehose returns an error during
     * runtime.
     * </p>
     * <p>
     * If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Firehose still delivers data
     * to Elasticsearch with the old index name and type name. If you want to update your delivery stream with a new
     * index name, provide an empty string for TypeName.
     * </p>
     * 
     * @param typeName
     *        The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can be only one type per index. If
     *        you try to specify a new type for an existing index that already has another type, Firehose returns an
     *        error during runtime. </p>
     *        <p>
     *        If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery stream, Firehose still
     *        delivers data to Elasticsearch with the old index name and type name. If you want to update your delivery
     *        stream with a new index name, provide an empty string for TypeName.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withTypeName(String typeName) {
        setTypeName(typeName);
        return this;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to IndexName to
     * facilitate the expiration of old data.
     * </p>
     * 
     * @param indexRotationPeriod
     *        The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to IndexName to
     *        facilitate the expiration of old data.
     * @see AmazonopensearchserviceIndexRotationPeriod
     */

    public void setIndexRotationPeriod(String indexRotationPeriod) {
        this.indexRotationPeriod = indexRotationPeriod;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to IndexName to
     * facilitate the expiration of old data.
     * </p>
     * 
     * @return The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to IndexName to
     *         facilitate the expiration of old data.
     * @see AmazonopensearchserviceIndexRotationPeriod
     */

    public String getIndexRotationPeriod() {
        return this.indexRotationPeriod;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to IndexName to
     * facilitate the expiration of old data.
     * </p>
     * 
     * @param indexRotationPeriod
     *        The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to IndexName to
     *        facilitate the expiration of old data.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AmazonopensearchserviceIndexRotationPeriod
     */

    public AmazonopensearchserviceDestinationUpdate withIndexRotationPeriod(String indexRotationPeriod) {
        setIndexRotationPeriod(indexRotationPeriod);
        return this;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to IndexName to
     * facilitate the expiration of old data.
     * </p>
     * 
     * @param indexRotationPeriod
     *        The Amazon OpenSearch Service index rotation period. Index rotation appends a timestamp to IndexName to
     *        facilitate the expiration of old data.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AmazonopensearchserviceIndexRotationPeriod
     */

    public AmazonopensearchserviceDestinationUpdate withIndexRotationPeriod(AmazonopensearchserviceIndexRotationPeriod indexRotationPeriod) {
        this.indexRotationPeriod = indexRotationPeriod.toString();
        return this;
    }

    /**
     * <p>
     * The buffering options. If no value is specified, AmazonopensearchBufferingHints object default values are used.
     * </p>
     * 
     * @param bufferingHints
     *        The buffering options. If no value is specified, AmazonopensearchBufferingHints object default values are
     *        used.
     */

    public void setBufferingHints(AmazonopensearchserviceBufferingHints bufferingHints) {
        this.bufferingHints = bufferingHints;
    }

    /**
     * <p>
     * The buffering options. If no value is specified, AmazonopensearchBufferingHints object default values are used.
     * </p>
     * 
     * @return The buffering options. If no value is specified, AmazonopensearchBufferingHints object default values are
     *         used.
     */

    public AmazonopensearchserviceBufferingHints getBufferingHints() {
        return this.bufferingHints;
    }

    /**
     * <p>
     * The buffering options. If no value is specified, AmazonopensearchBufferingHints object default values are used.
     * </p>
     * 
     * @param bufferingHints
     *        The buffering options. If no value is specified, AmazonopensearchBufferingHints object default values are
     *        used.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withBufferingHints(AmazonopensearchserviceBufferingHints bufferingHints) {
        setBufferingHints(bufferingHints);
        return this;
    }

    /**
     * <p>
     * The retry behavior in case Firehose is unable to deliver documents to Amazon OpenSearch Service. The default
     * value is 300 (5 minutes).
     * </p>
     * 
     * @param retryOptions
     *        The retry behavior in case Firehose is unable to deliver documents to Amazon OpenSearch Service. The
     *        default value is 300 (5 minutes).
     */

    public void setRetryOptions(AmazonopensearchserviceRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
    }

    /**
     * <p>
     * The retry behavior in case Firehose is unable to deliver documents to Amazon OpenSearch Service. The default
     * value is 300 (5 minutes).
     * </p>
     * 
     * @return The retry behavior in case Firehose is unable to deliver documents to Amazon OpenSearch Service. The
     *         default value is 300 (5 minutes).
     */

    public AmazonopensearchserviceRetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    /**
     * <p>
     * The retry behavior in case Firehose is unable to deliver documents to Amazon OpenSearch Service. The default
     * value is 300 (5 minutes).
     * </p>
     * 
     * @param retryOptions
     *        The retry behavior in case Firehose is unable to deliver documents to Amazon OpenSearch Service. The
     *        default value is 300 (5 minutes).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withRetryOptions(AmazonopensearchserviceRetryOptions retryOptions) {
        setRetryOptions(retryOptions);
        return this;
    }

    /**
     * @param s3Update
     */

    public void setS3Update(S3DestinationUpdate s3Update) {
        this.s3Update = s3Update;
    }

    /**
     * @return
     */

    public S3DestinationUpdate getS3Update() {
        return this.s3Update;
    }

    /**
     * @param s3Update
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withS3Update(S3DestinationUpdate s3Update) {
        setS3Update(s3Update);
        return this;
    }

    /**
     * @param processingConfiguration
     */

    public void setProcessingConfiguration(ProcessingConfiguration processingConfiguration) {
        this.processingConfiguration = processingConfiguration;
    }

    /**
     * @return
     */

    public ProcessingConfiguration getProcessingConfiguration() {
        return this.processingConfiguration;
    }

    /**
     * @param processingConfiguration
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withProcessingConfiguration(ProcessingConfiguration processingConfiguration) {
        setProcessingConfiguration(processingConfiguration);
        return this;
    }

    /**
     * @param cloudWatchLoggingOptions
     */

    public void setCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
        this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
    }

    /**
     * @return
     */

    public CloudWatchLoggingOptions getCloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    /**
     * @param cloudWatchLoggingOptions
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
        setCloudWatchLoggingOptions(cloudWatchLoggingOptions);
        return this;
    }

    /**
     * <p>
     * Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and
     * OpenSearch Service generated document ID.
     * </p>
     * 
     * @param documentIdOptions
     *        Indicates the method for setting up document ID. The supported methods are Firehose generated document ID
     *        and OpenSearch Service generated document ID.
     */

    public void setDocumentIdOptions(DocumentIdOptions documentIdOptions) {
        this.documentIdOptions = documentIdOptions;
    }

    /**
     * <p>
     * Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and
     * OpenSearch Service generated document ID.
     * </p>
     * 
     * @return Indicates the method for setting up document ID. The supported methods are Firehose generated document ID
     *         and OpenSearch Service generated document ID.
     */

    public DocumentIdOptions getDocumentIdOptions() {
        return this.documentIdOptions;
    }

    /**
     * <p>
     * Indicates the method for setting up document ID. The supported methods are Firehose generated document ID and
     * OpenSearch Service generated document ID.
     * </p>
     * 
     * @param documentIdOptions
     *        Indicates the method for setting up document ID. The supported methods are Firehose generated document ID
     *        and OpenSearch Service generated document ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmazonopensearchserviceDestinationUpdate withDocumentIdOptions(DocumentIdOptions documentIdOptions) {
        setDocumentIdOptions(documentIdOptions);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRoleARN() != null)
            sb.append("RoleARN: ").append(getRoleARN()).append(",");
        if (getDomainARN() != null)
            sb.append("DomainARN: ").append(getDomainARN()).append(",");
        if (getClusterEndpoint() != null)
            sb.append("ClusterEndpoint: ").append(getClusterEndpoint()).append(",");
        if (getIndexName() != null)
            sb.append("IndexName: ").append(getIndexName()).append(",");
        if (getTypeName() != null)
            sb.append("TypeName: ").append(getTypeName()).append(",");
        if (getIndexRotationPeriod() != null)
            sb.append("IndexRotationPeriod: ").append(getIndexRotationPeriod()).append(",");
        if (getBufferingHints() != null)
            sb.append("BufferingHints: ").append(getBufferingHints()).append(",");
        if (getRetryOptions() != null)
            sb.append("RetryOptions: ").append(getRetryOptions()).append(",");
        if (getS3Update() != null)
            sb.append("S3Update: ").append(getS3Update()).append(",");
        if (getProcessingConfiguration() != null)
            sb.append("ProcessingConfiguration: ").append(getProcessingConfiguration()).append(",");
        if (getCloudWatchLoggingOptions() != null)
            sb.append("CloudWatchLoggingOptions: ").append(getCloudWatchLoggingOptions()).append(",");
        if (getDocumentIdOptions() != null)
            sb.append("DocumentIdOptions: ").append(getDocumentIdOptions());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AmazonopensearchserviceDestinationUpdate == false)
            return false;
        AmazonopensearchserviceDestinationUpdate other = (AmazonopensearchserviceDestinationUpdate) obj;
        if (other.getRoleARN() == null ^ this.getRoleARN() == null)
            return false;
        if (other.getRoleARN() != null && other.getRoleARN().equals(this.getRoleARN()) == false)
            return false;
        if (other.getDomainARN() == null ^ this.getDomainARN() == null)
            return false;
        if (other.getDomainARN() != null && other.getDomainARN().equals(this.getDomainARN()) == false)
            return false;
        if (other.getClusterEndpoint() == null ^ this.getClusterEndpoint() == null)
            return false;
        if (other.getClusterEndpoint() != null && other.getClusterEndpoint().equals(this.getClusterEndpoint()) == false)
            return false;
        if (other.getIndexName() == null ^ this.getIndexName() == null)
            return false;
        if (other.getIndexName() != null && other.getIndexName().equals(this.getIndexName()) == false)
            return false;
        if (other.getTypeName() == null ^ this.getTypeName() == null)
            return false;
        if (other.getTypeName() != null && other.getTypeName().equals(this.getTypeName()) == false)
            return false;
        if (other.getIndexRotationPeriod() == null ^ this.getIndexRotationPeriod() == null)
            return false;
        if (other.getIndexRotationPeriod() != null && other.getIndexRotationPeriod().equals(this.getIndexRotationPeriod()) == false)
            return false;
        if (other.getBufferingHints() == null ^ this.getBufferingHints() == null)
            return false;
        if (other.getBufferingHints() != null && other.getBufferingHints().equals(this.getBufferingHints()) == false)
            return false;
        if (other.getRetryOptions() == null ^ this.getRetryOptions() == null)
            return false;
        if (other.getRetryOptions() != null && other.getRetryOptions().equals(this.getRetryOptions()) == false)
            return false;
        if (other.getS3Update() == null ^ this.getS3Update() == null)
            return false;
        if (other.getS3Update() != null && other.getS3Update().equals(this.getS3Update()) == false)
            return false;
        if (other.getProcessingConfiguration() == null ^ this.getProcessingConfiguration() == null)
            return false;
        if (other.getProcessingConfiguration() != null && other.getProcessingConfiguration().equals(this.getProcessingConfiguration()) == false)
            return false;
        if (other.getCloudWatchLoggingOptions() == null ^ this.getCloudWatchLoggingOptions() == null)
            return false;
        if (other.getCloudWatchLoggingOptions() != null && other.getCloudWatchLoggingOptions().equals(this.getCloudWatchLoggingOptions()) == false)
            return false;
        if (other.getDocumentIdOptions() == null ^ this.getDocumentIdOptions() == null)
            return false;
        if (other.getDocumentIdOptions() != null && other.getDocumentIdOptions().equals(this.getDocumentIdOptions()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRoleARN() == null) ? 0 : getRoleARN().hashCode());
        hashCode = prime * hashCode + ((getDomainARN() == null) ? 0 : getDomainARN().hashCode());
        hashCode = prime * hashCode + ((getClusterEndpoint() == null) ? 0 : getClusterEndpoint().hashCode());
        hashCode = prime * hashCode + ((getIndexName() == null) ? 0 : getIndexName().hashCode());
        hashCode = prime * hashCode + ((getTypeName() == null) ? 0 : getTypeName().hashCode());
        hashCode = prime * hashCode + ((getIndexRotationPeriod() == null) ? 0 : getIndexRotationPeriod().hashCode());
        hashCode = prime * hashCode + ((getBufferingHints() == null) ? 0 : getBufferingHints().hashCode());
        hashCode = prime * hashCode + ((getRetryOptions() == null) ? 0 : getRetryOptions().hashCode());
        hashCode = prime * hashCode + ((getS3Update() == null) ? 0 : getS3Update().hashCode());
        hashCode = prime * hashCode + ((getProcessingConfiguration() == null) ? 0 : getProcessingConfiguration().hashCode());
        hashCode = prime * hashCode + ((getCloudWatchLoggingOptions() == null) ? 0 : getCloudWatchLoggingOptions().hashCode());
        hashCode = prime * hashCode + ((getDocumentIdOptions() == null) ? 0 : getDocumentIdOptions().hashCode());
        return hashCode;
    }

    @Override
    public AmazonopensearchserviceDestinationUpdate clone() {
        try {
            return (AmazonopensearchserviceDestinationUpdate) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.kinesisfirehose.model.transform.AmazonopensearchserviceDestinationUpdateMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
