/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model.transform;

import com.amazonaws.services.kafka.model.Firehose;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class FirehoseJsonUnmarshaller
implements Unmarshaller<Firehose, JsonUnmarshallerContext> {
    private static FirehoseJsonUnmarshaller instance;

    public Firehose unmarshall(JsonUnmarshallerContext context) throws Exception {
        Firehose firehose = new Firehose();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("deliveryStream", targetDepth)) {
                    context.nextToken();
                    firehose.setDeliveryStream((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("enabled", targetDepth)) {
                    context.nextToken();
                    firehose.setEnabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return firehose;
    }

    public static FirehoseJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new FirehoseJsonUnmarshaller();
        }
        return instance;
    }
}

